package com.xdja.im.uikit.utils.sys;

import android.text.TextUtils;

import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.DateUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.timeformat.ChatTimeFormat;
import com.xdja.im.uikit.utils.timeformat.SessionTimeFormat;
import com.xdja.im.uikit.utils.timeformat.TimeFormat;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

/**
 * @Package: com.xdja.im.uikit.utils.sys
 * @Author: xdjaxa
 * @Creation: 2017-05-25 17:38
 * @Version V1.0
 * @Description:
 */
public class TimeUtil {

    private static final String FORMAT_MDYHM = "yyyy/MM/dd HH:mm";
    private static final String FORMAT_MDY = "yyyy/MM/dd";

    private static final String FORMAT_MDHM = "MM/dd HH:mm";
    private static final String FORMAT_MD = "MM/dd";
    //时/分
    private static final String FORMAT_HHMM = "HH:mm";

    private static final Map<String, ThreadLocal<SimpleDateFormat>> sdfMap = new HashMap<>();

    /**
     * 根据map中的key值，获取对应线程中的SimpleDateFormat实例
     *
     * @param pattern
     * @return
     */
    private static SimpleDateFormat getFormat(final String pattern) {

        ThreadLocal<SimpleDateFormat> formatThread = sdfMap.get(pattern);
        if (formatThread == null) {
            //双层检查，防止sdfMap多次放值
            synchronized (DateUtils.class) {
                formatThread = new ThreadLocal<SimpleDateFormat>() {

                    @Override
                    protected SimpleDateFormat initialValue() {
                        return new SimpleDateFormat(pattern);
                    }
                };
                sdfMap.put(pattern, formatThread);
            }
        }
        return formatThread.get();
    }

    /**
     * 会话界面时间展示
     *
     * @param timestamp
     * @return
     */
    public static String convertSessionTime(long timestamp) {
        return timeConvert(timestamp, new SessionTimeFormat());
    }

    /**
     * 聊天界面时间线转换
     *
     * @param timestamp
     * @return
     */
    public static String convertChatTime(long timestamp) {
        return timeConvert(timestamp, new ChatTimeFormat());
    }

    private static String timeConvert(long timestamp, TimeFormat format) {
        //今天  时间
        //昨天  昨天
        //当年  月日
        //其他  年月日
        Calendar cal = Calendar.getInstance();
        //系统当前时间
        cal.setTimeInMillis(System.currentTimeMillis());
        int currentYear = cal.get(Calendar.YEAR);
        int currentMonth = cal.get(Calendar.MONTH);
        int currentDay = cal.get(Calendar.DAY_OF_MONTH);

        //参数的年份，哪一天
        cal.setTimeInMillis(timestamp);
        int lastYear = cal.get(Calendar.YEAR);
        int lastMonth = cal.get(Calendar.MONTH);
        int lastDay = cal.get(Calendar.DAY_OF_MONTH);

        String timeStr;
        if (currentYear == lastYear) {
            if (currentMonth == lastMonth && currentDay == lastDay) {
                // 今天
                timeStr = getFormat(FORMAT_HHMM).format(timestamp);
            } else if (currentMonth == lastMonth && ((currentDay - lastDay) == 1)) {
                // 昨天
                if (TextUtils.isEmpty(format.getTimePattern())) {
                    timeStr = String.format(CommonTool.getString(R.string.im_uikit_yesterday),"");
                } else {
                    timeStr = String.format(CommonTool.getString(R.string.im_uikit_yesterday),
                            getFormat(format.getTimePattern()).format(timestamp));
                }
            } else {
                timeStr = getFormat(format.getMDPattern()).format(timestamp);
            }
        } else {
            timeStr = getFormat(format.getMDYPattern()).format(timestamp);
        }
        return timeStr;
    }
}
