/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.impl.cookie;

import com.xdja.http.annotation.Immutable;
import com.xdja.http.cookie.CommonCookieAttributeHandler;
import com.xdja.http.cookie.MalformedCookieException;
import com.xdja.http.cookie.SetCookie;
import com.xdja.http.impl.cookie.AbstractCookieAttributeHandler;
import com.xdja.http.util.Args;
import com.xdja.http.util.TextUtils;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Immutable
public class LaxMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile("^\\-?[0-9]+$");

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (TextUtils.isBlank(value)) {
            return;
        }
        Matcher matcher = MAX_AGE_PATTERN.matcher(value);
        if (matcher.matches()) {
            int age;
            try {
                age = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return;
            }
            Date expiryDate = age >= 0 ? new Date(System.currentTimeMillis() + (long)age * 1000L) : new Date(Long.MIN_VALUE);
            cookie.setExpiryDate(expiryDate);
        }
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

