/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.protocol;

import com.xdja.http.Header;
import com.xdja.http.HttpEntity;
import com.xdja.http.HttpException;
import com.xdja.http.HttpRequest;
import com.xdja.http.HttpResponse;
import com.xdja.http.HttpResponseInterceptor;
import com.xdja.http.HttpVersion;
import com.xdja.http.ProtocolVersion;
import com.xdja.http.annotation.Immutable;
import com.xdja.http.protocol.HttpContext;
import com.xdja.http.protocol.HttpCoreContext;
import com.xdja.http.util.Args;
import java.io.IOException;

@Immutable
public class ResponseConnControl
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpRequest request;
        Args.notNull(response, "HTTP response");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        int status = response.getStatusLine().getStatusCode();
        if (status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 503 || status == 501) {
            response.setHeader("Connection", "Close");
            return;
        }
        Header explicit = response.getFirstHeader("Connection");
        if (explicit != null && "Close".equalsIgnoreCase(explicit.getValue())) {
            return;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            ProtocolVersion ver = response.getStatusLine().getProtocolVersion();
            if (entity.getContentLength() < 0L && (!entity.isChunked() || ver.lessEquals(HttpVersion.HTTP_1_0))) {
                response.setHeader("Connection", "Close");
                return;
            }
        }
        if ((request = corecontext.getRequest()) != null) {
            Header header = request.getFirstHeader("Connection");
            if (header != null) {
                response.setHeader("Connection", header.getValue());
            } else if (request.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                response.setHeader("Connection", "Close");
            }
        }
    }
}

