/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.protocol;

import com.xdja.http.HttpException;
import com.xdja.http.HttpResponse;
import com.xdja.http.HttpResponseInterceptor;
import com.xdja.http.annotation.ThreadSafe;
import com.xdja.http.protocol.HttpContext;
import com.xdja.http.protocol.HttpDateGenerator;
import com.xdja.http.util.Args;
import java.io.IOException;

@ThreadSafe
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

