/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager.msg;

import com.xdja.imsdk.constant.internal.HttpApiConstant;
import com.xdja.imsdk.http.bean.Condition;
import com.xdja.imsdk.http.bean.MsgBean;
import com.xdja.imsdk.http.config.ImRequestConfig;
import com.xdja.imsdk.http.param.Info;
import com.xdja.imsdk.http.param.LoginParaN;
import com.xdja.imsdk.http.param.MsgParaN;
import com.xdja.imsdk.http.param.PullParaN;
import com.xdja.imsdk.http.param.StatePar;
import com.xdja.imsdk.http.param.StateParaN;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.manager.msg.PullAccord;

public class MsgParamGen {
    private String account;
    private String cardId;
    private String ticket;

    public MsgParamGen(String account, String cardId, String ticket) {
        this.account = account;
        this.cardId = cardId;
        this.ticket = ticket;
    }

    public LoginParaN getLoginPara() {
        Info info = new Info(this.cardId, this.account);
        return new LoginParaN(info, null);
    }

    public MsgParaN getSendPara(MsgBean msgBean, long flagId) {
        return new MsgParaN(msgBean, msgBean.getTo(), String.valueOf(flagId), 1, ImSdkCallbackManager.getInstance().getSendMessageParamExt());
    }

    public StatePar getSendStatePara(String states, long flagId) {
        StateParaN statePara = this.getStateParaN(states, ImSdkConfigManager.getInstance().getCurrentMillis());
        return new StatePar<StateParaN>(statePara, String.valueOf(flagId), ImSdkCallbackManager.getInstance().getSendMessageParamExt());
    }

    public PullParaN getPullPara(long startId, int size, Condition condition) {
        String start = "";
        if (startId > 0L) {
            start = String.valueOf(startId);
        }
        return new PullParaN<Condition>(this.account, start, size, condition, null);
    }

    public ImRequestConfig getRequestConfig(HttpApiConstant.IMRequestType type, long flagId) {
        ImRequestConfig config = new ImRequestConfig(type);
        config.setTimeoutType(this.getTimeoutType(type));
        config.setOptions("ticket", this.ticket);
        if (flagId > 0L) {
            config.setMsgId(String.valueOf(flagId));
        }
        return config;
    }

    public PullAccord getPullAccord() {
        PullAccord accord = new PullAccord();
        accord.setStartId(0L);
        accord.setEndId(-1L);
        accord.setPE(1);
        return accord;
    }

    private int getTimeoutType(HttpApiConstant.IMRequestType type) {
        int timeout = 0;
        switch (type) {
            case NORMAL: {
                timeout = 1;
                break;
            }
            case RECALL: {
                timeout = 2;
                break;
            }
        }
        return timeout;
    }

    private StateParaN getStateParaN(String state, long currentTime) {
        StateParaN statePara = new StateParaN();
        statePara.setContent(state);
        statePara.setFst(String.valueOf(currentTime));
        statePara.setFi(this.cardId);
        statePara.setI("-1");
        statePara.setSst("-1");
        statePara.setLc("-1");
        return statePara;
    }
}

