/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager.process;

import android.text.TextUtils;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.constant.internal.Constant;
import com.xdja.imsdk.db.ImSdkDbUtils;
import com.xdja.imsdk.db.bean.FileMsgDb;
import com.xdja.imsdk.db.bean.HdThumbFileDb;
import com.xdja.imsdk.db.bean.MsgEntryDb;
import com.xdja.imsdk.db.bean.RawFileDb;
import com.xdja.imsdk.db.helper.OptHelper;
import com.xdja.imsdk.db.helper.OptType;
import com.xdja.imsdk.db.helper.UpdateArgs;
import com.xdja.imsdk.db.wrapper.MessageWrapper;
import com.xdja.imsdk.db.wrapper.SessionWrapper;
import com.xdja.imsdk.http.bean.MsgBean;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.manager.ImSdkFileManager;
import com.xdja.imsdk.manager.ImSyncManager;
import com.xdja.imsdk.manager.ModelMapper;
import com.xdja.imsdk.manager.process.SendOutNode;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.IMSession;
import com.xdja.imsdk.model.internal.IMState;
import com.xdja.imsdk.security.SecurityPara;
import com.xdja.imsdk.security.SecurityResult;
import com.xdja.imsdk.util.FileSizeUtils;
import com.xdja.imsdk.util.FileUtils;
import com.xdja.imsdk.util.ToolUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public class SendOutProcess {
    private Thread sendOutThread;
    private final LinkedBlockingQueue<SendOutNode> sendOutQueue = new LinkedBlockingQueue();
    private Set<Long> stateIds = new HashSet<Long>();
    private boolean state = ImSdkConfigManager.getInstance().needState();
    private boolean encrypt = ImSdkConfigManager.getInstance().needEncrypt();

    public SendOutProcess() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MessageWrapper wrapper) {
        SendOutNode node = new SendOutNode(Constant.SentType.NORMAL);
        node.setMessage(wrapper);
        this.sendOutQueue.offer(node);
        LinkedBlockingQueue<SendOutNode> linkedBlockingQueue = this.sendOutQueue;
        synchronized (linkedBlockingQueue) {
            this.sendOutQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recall(MessageWrapper wrapper) {
        SendOutNode node = new SendOutNode(Constant.SentType.RECALL);
        node.setMessage(wrapper);
        this.sendOutQueue.offer(node);
        LinkedBlockingQueue<SendOutNode> linkedBlockingQueue = this.sendOutQueue;
        synchronized (linkedBlockingQueue) {
            this.sendOutQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IMState state) {
        SendOutNode node = new SendOutNode(Constant.SentType.STATE);
        node.setState(state);
        this.sendOutQueue.offer(node);
        LinkedBlockingQueue<SendOutNode> linkedBlockingQueue = this.sendOutQueue;
        synchronized (linkedBlockingQueue) {
            this.sendOutQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(List<IMState> states) {
        if (!this.state) {
            return;
        }
        if (states == null || states.isEmpty()) {
            return;
        }
        List<Object> newList = new ArrayList();
        if (this.stateIds.size() == 0) {
            newList = states;
        } else {
            for (IMState linkedBlockingQueue : states) {
                if (this.stateIds.contains(linkedBlockingQueue.getId())) continue;
                newList.add(linkedBlockingQueue);
            }
        }
        for (IMState iMState : newList) {
            this.stateIds.add(iMState.getId());
            SendOutNode node = new SendOutNode(Constant.SentType.STATE);
            node.setState(iMState);
            LinkedBlockingQueue<SendOutNode> linkedBlockingQueue = this.sendOutQueue;
            synchronized (linkedBlockingQueue) {
                this.sendOutQueue.offer(node);
            }
        }
        LinkedBlockingQueue<SendOutNode> linkedBlockingQueue = this.sendOutQueue;
        synchronized (linkedBlockingQueue) {
            if (this.sendOutQueue.size() > 0) {
                this.sendOutQueue.notifyAll();
            }
        }
    }

    public void removeState(long id) {
        if (this.stateIds.contains(id)) {
            this.stateIds.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.sendOutQueue.clear();
        LinkedBlockingQueue<SendOutNode> linkedBlockingQueue = this.sendOutQueue;
        synchronized (linkedBlockingQueue) {
            this.sendOutQueue.notifyAll();
        }
        if (this.sendOutThread != null) {
            this.sendOutThread.interrupt();
        }
    }

    private void init() {
        if (this.sendOutThread == null) {
            this.sendOutThread = new Thread(new SendOutRunnable());
            this.sendOutThread.setName("sendOutThread");
            this.sendOutThread.start();
        } else if (!this.sendOutThread.isAlive()) {
            this.sendOutThread.start();
        }
    }

    private void sendNormal(MessageWrapper wrapper) {
        if (!this.checkFileSize(wrapper)) {
            return;
        }
        if ((wrapper = this.encryptMessage(wrapper)) == null) {
            return;
        }
        if (wrapper.isText()) {
            this.sendText(wrapper);
        }
        if (wrapper.isFile()) {
            this.sendFile(wrapper);
        }
        if (wrapper.isWeb()) {
            if (wrapper.webExistFile()) {
                this.sendFile(wrapper);
            } else {
                this.sendText(wrapper);
            }
        }
    }

    private void sendState(IMState state) {
        if (state == null) {
            return;
        }
        ImSyncManager.getInstance().sendState(state.getContent(), state.getId());
    }

    private void sendRecall(MessageWrapper wrapper) {
        if (wrapper == null || wrapper.getMsgEntryDb() == null) {
            return;
        }
        long sendId = ToolUtils.getLong(wrapper.getMsgEntryDb().getId());
        MsgBean recall = ModelMapper.getIns().mapRecall(wrapper);
        if (recall == null) {
            return;
        }
        ImSyncManager.getInstance().sendRecall(recall, sendId);
    }

    private void sendText(MessageWrapper wrapper) {
        if (wrapper == null || wrapper.getMsgEntryDb() == null) {
            return;
        }
        long sendId = ToolUtils.getLong(wrapper.getMsgEntryDb().getId());
        MsgBean msgBean = ModelMapper.getIns().mapTextBean(wrapper);
        if (msgBean == null) {
            return;
        }
        ImSyncManager.getInstance().sendText(msgBean, sendId);
    }

    public void sendFileText(MessageWrapper wrapper) {
        if (wrapper == null || wrapper.getMsgEntryDb() == null) {
            return;
        }
        long sendId = ToolUtils.getLong(wrapper.getMsgEntryDb().getId());
        MsgBean msgBean = ModelMapper.getIns().mapFileBean(wrapper);
        if (msgBean == null || TextUtils.isEmpty((CharSequence)msgBean.getC())) {
            return;
        }
        ImSyncManager.getInstance().sendText(msgBean, sendId);
    }

    private void sendFile(MessageWrapper wrapper) {
        ImSdkFileManager.getInstance().uploadFile(wrapper);
    }

    private boolean checkFileSize(MessageWrapper wrapper) {
        if (wrapper == null || wrapper.getMsgEntryDb() == null) {
            return false;
        }
        long id = wrapper.getMsgEntryDb().getId();
        if (wrapper.isFile()) {
            RawFileDb rawFileDb;
            FileMsgDb fileMsgDb = wrapper.getFileMsgDb();
            long size = ImSdkConfigManager.getInstance().getSize();
            if (fileMsgDb != null && fileMsgDb.isNormal() && fileMsgDb.getFile_size() > size) {
                this.updateMState(id, -11);
                wrapper.getMsgEntryDb().setState(-11);
                this.callbackFail(wrapper);
                return false;
            }
            if (fileMsgDb != null && fileMsgDb.isImage() && (rawFileDb = wrapper.getRawFileDb()) != null && rawFileDb.getRaw_file_size() > size) {
                this.updateMState(id, -11);
                wrapper.getMsgEntryDb().setState(-11);
                this.callbackFail(wrapper);
                return false;
            }
            if (fileMsgDb != null) {
                fileMsgDb.isVideo();
            }
        }
        return true;
    }

    private boolean checkVersion(MessageWrapper wrapper) {
        boolean isNormalFile;
        if (wrapper == null || wrapper.getMsgEntryDb() == null) {
            return false;
        }
        if (wrapper.isService()) {
            return true;
        }
        long id = wrapper.getMsgEntryDb().getId();
        boolean bl = isNormalFile = wrapper.isFile() && wrapper.getFileMsgDb() != null && (wrapper.getFileMsgDb().isNormal() || wrapper.getFileMsgDb().isVideo());
        if (isNormalFile) {
            String account = wrapper.getMsgEntryDb().getReceiver();
            int code = ImSdkCallbackManager.getInstance().callVersion(account);
            if (code == 0) {
                wrapper.getMsgEntryDb().setState(0);
                return true;
            }
            if (code == 1) {
                this.updateMState(id, -1);
                wrapper.getMsgEntryDb().setState(-1);
                this.callbackFail(wrapper);
                return false;
            }
            if (code == 2) {
                this.updateMState(id, -2);
                wrapper.getMsgEntryDb().setState(-2);
                this.callbackFail(wrapper);
                return false;
            }
        }
        return true;
    }

    private MessageWrapper encryptMessage(MessageWrapper wrapper) {
        if (wrapper == null || wrapper.getMsgEntryDb() == null) {
            return null;
        }
        if (!this.encrypt) {
            return this.updateUnEncrypt(wrapper);
        }
        if (wrapper.getMsgEntryDb().isCustom()) {
            return this.updateUnEncrypt(wrapper);
        }
        if (wrapper.isService()) {
            return this.updateUnEncrypt(wrapper);
        }
        if (!wrapper.getMsgEntryDb().notEncrypt()) {
            this.updateFState(wrapper);
            return wrapper;
        }
        if (this.fileEncrypt(wrapper)) {
            this.updateFState(wrapper);
            return wrapper;
        }
        if (this.webEncrypt(wrapper)) {
            this.updateFState(wrapper);
            return wrapper;
        }
        boolean result = this.encrypt(wrapper);
        this.updateEncrypt(wrapper, result);
        if (!result) {
            Logger.getLogger().d("encrypt fail!!!");
            wrapper.getMsgEntryDb().setState(-3);
            this.callbackFail(wrapper);
            return null;
        }
        wrapper = ImSdkDbUtils.queryMessage(OptHelper.getIns().getAMQuery(wrapper.getMsgEntryDb().getId()), OptType.MQuery.ALL);
        return wrapper;
    }

    private boolean encrypt(MessageWrapper wrapper) {
        MsgEntryDb msg = wrapper.getMsgEntryDb();
        SecurityPara para = ModelMapper.getIns().getSecurityPara(msg);
        if (para == null) {
            return false;
        }
        if (msg.isText()) {
            SecurityResult text = ImSdkCallbackManager.getInstance().callEncryptText(msg.getContent(), para);
            if (text == null || !text.success()) {
                return false;
            }
            msg.setContent(text.getResult());
            msg.setState(-4);
            return true;
        }
        if (msg.isWeb()) {
            FileMsgDb file = wrapper.getFileMsgDb();
            if (file != null) {
                int type = file.getType();
                String name = file.getFile_name();
                String showPath = file.getFile_path();
                String showEncrypt = FileUtils.getEncryptPath(type, name);
                SecurityResult show = ImSdkCallbackManager.getInstance().callEncryptFile(showPath, showEncrypt, para);
                if (show == null || !show.success()) {
                    return false;
                }
                file.setEncrypt_path(show.getResult());
                file.setEncrypt_size(FileSizeUtils.getFileSize(show.getResult()));
            }
            msg.setState(-4);
            return true;
        }
        if (msg.isFile()) {
            RawFileDb rawFile;
            FileMsgDb file = wrapper.getFileMsgDb();
            if (file == null) {
                return false;
            }
            int type = file.getType();
            String name = file.getFile_name();
            String showPath = file.getFile_path();
            String showEncrypt = FileUtils.getEncryptPath(type, name);
            SecurityResult show = ImSdkCallbackManager.getInstance().callEncryptFile(showPath, showEncrypt, para);
            if (show == null || !show.success()) {
                return false;
            }
            file.setEncrypt_path(show.getResult());
            file.setEncrypt_size(FileSizeUtils.getFileSize(show.getResult()));
            HdThumbFileDb hdFile = wrapper.getHdThumbFileDb();
            if (hdFile != null) {
                String hdPath = hdFile.getHd_file_path();
                String hdName = hdFile.getHd_file_name();
                String hdEncrypt = FileUtils.getEncryptPath(type, hdName);
                SecurityResult hd = ImSdkCallbackManager.getInstance().callEncryptFile(hdPath, hdEncrypt, para);
                if (hd == null || !hd.success()) {
                    return false;
                }
                hdFile.setHd_encrypt_path(hd.getResult());
                hdFile.setHd_encrypt_size(FileSizeUtils.getFileSize(hd.getResult()));
            }
            if ((rawFile = wrapper.getRawFileDb()) != null) {
                String rawPath = rawFile.getRaw_file_path();
                String rawName = rawFile.getRaw_file_name();
                String rawEncrypt = FileUtils.getEncryptPath(type, rawName);
                SecurityResult raw = ImSdkCallbackManager.getInstance().callEncryptFile(rawPath, rawEncrypt, para);
                if (raw == null || !raw.success()) {
                    return false;
                }
                rawFile.setRaw_encrypt_path(raw.getResult());
                rawFile.setRaw_encrypt_size(FileSizeUtils.getFileSize(raw.getResult()));
            }
            msg.setState(-4);
            return true;
        }
        return false;
    }

    private boolean fileEncrypt(MessageWrapper wrapper) {
        if (wrapper.getMsgEntryDb().isFile()) {
            FileMsgDb file = wrapper.getFileMsgDb();
            if (file == null) {
                return true;
            }
            if (file.getFile_state() > 11) {
                return true;
            }
        }
        return false;
    }

    private boolean webEncrypt(MessageWrapper wrapper) {
        if (!wrapper.isWeb()) {
            return false;
        }
        if (!wrapper.webExistFile()) {
            return true;
        }
        FileMsgDb file = wrapper.getFileMsgDb();
        return file.getFile_state() > 11;
    }

    private void updateFState(MessageWrapper message) {
        long id = message.getMsgEntryDb().getId();
        int state = message.getMsgEntryDb().getState();
        if (state > 0) {
            return;
        }
        if (-6 == state || state == -9) {
            return;
        }
        this.updateMState(id, -4);
        message.getMsgEntryDb().setState(0);
    }

    private void updateMState(long id, int state) {
        UpdateArgs updateArgs = OptHelper.getIns().getMCUpdate(id, state);
        ImSdkDbUtils.update(updateArgs);
    }

    private void updateEncrypt(MessageWrapper message, boolean result) {
        if (message == null || message.getMsgEntryDb() == null) {
            return;
        }
        MsgEntryDb msg = message.getMsgEntryDb();
        long id = msg.getId();
        if (msg.isText()) {
            if (result) {
                UpdateArgs updateArgs = OptHelper.getIns().getEUpdate(id, -4, msg.getContent());
                ImSdkDbUtils.update(updateArgs);
                return;
            }
            this.updateMState(id, -3);
            return;
        }
        if (msg.isWeb()) {
            if (result) {
                this.updateFile(message, -4, 12);
                return;
            }
            this.updateFile(message, -3, 11);
            return;
        }
        if (msg.isFile()) {
            if (result) {
                this.updateFile(message, -4, 12);
            } else {
                this.updateFile(message, -3, 11);
            }
        }
    }

    private MessageWrapper updateUnEncrypt(MessageWrapper message) {
        if (message == null || message.getMsgEntryDb() == null) {
            return null;
        }
        MsgEntryDb msg = message.getMsgEntryDb();
        long id = msg.getId();
        if (msg.isText()) {
            if (msg.isService()) {
                if (msg.getState() == 0) {
                    UpdateArgs updateArgs = OptHelper.getIns().getEUpdate(id, 0, ToolUtils.encode(msg.getContent()));
                    ImSdkDbUtils.update(updateArgs);
                } else if (msg.getState() < 0) {
                    this.updateMState(id, 0);
                }
            } else {
                this.updateMState(id, 0);
            }
        }
        if (msg.isWeb()) {
            if (message.getFileMsgDb() != null) {
                message.getFileMsgDb().setEncrypt_path(message.getFileMsgDb().getFile_path());
                message.getFileMsgDb().setEncrypt_size(message.getFileMsgDb().getFile_size());
            }
            this.updateFile(message, 0, 12);
        }
        if (msg.isFile()) {
            RawFileDb rawFileDb;
            HdThumbFileDb hdThumbFileDb;
            FileMsgDb fileMsgDb = message.getFileMsgDb();
            if (fileMsgDb != null) {
                fileMsgDb.setEncrypt_path(fileMsgDb.getFile_path());
                fileMsgDb.setEncrypt_size(fileMsgDb.getFile_size());
            }
            if ((hdThumbFileDb = message.getHdThumbFileDb()) != null) {
                hdThumbFileDb.setHd_encrypt_path(hdThumbFileDb.getHd_file_path());
                hdThumbFileDb.setHd_encrypt_size(hdThumbFileDb.getHd_file_size());
            }
            if ((rawFileDb = message.getRawFileDb()) != null) {
                rawFileDb.setRaw_encrypt_path(rawFileDb.getRaw_file_path());
                rawFileDb.setRaw_encrypt_size(rawFileDb.getRaw_file_size());
            }
            this.updateFile(message, 0, 12);
        }
        return ImSdkDbUtils.queryMessage(OptHelper.getIns().getAMQuery(id), OptType.MQuery.ALL);
    }

    private void updateFile(MessageWrapper message, int msgState, int fileState) {
        RawFileDb raw;
        long id = message.getMsgEntryDb().getId();
        UpdateArgs msgUpdate = OptHelper.getIns().getMCUpdate(id, msgState);
        FileMsgDb file = message.getFileMsgDb();
        if (file == null) {
            ImSdkDbUtils.update(msgUpdate);
            return;
        }
        String fileMd5 = ToolUtils.getFileMD5(file.getEncrypt_path());
        UpdateArgs fileUpdate = OptHelper.getIns().getEFUpdate(ImSdkFileConstant.FileType.IS_SHOW, file.getEncrypt_path(), fileMd5, file.getEncrypt_size(), fileState, id);
        UpdateArgs hdUpdate = null;
        UpdateArgs rawUpdate = null;
        if (file.isImage()) {
            RawFileDb raw2;
            HdThumbFileDb hd = message.getHdThumbFileDb();
            if (hd != null) {
                String hdMd5 = ToolUtils.getFileMD5(hd.getHd_encrypt_path());
                hdUpdate = OptHelper.getIns().getEFUpdate(ImSdkFileConstant.FileType.IS_HD, hd.getHd_encrypt_path(), hdMd5, hd.getHd_encrypt_size(), fileState, id);
            }
            if ((raw2 = message.getRawFileDb()) != null) {
                String rawMd5 = ToolUtils.getFileMD5(raw2.getRaw_encrypt_path());
                rawUpdate = OptHelper.getIns().getEFUpdate(ImSdkFileConstant.FileType.IS_RAW, raw2.getRaw_encrypt_path(), rawMd5, raw2.getRaw_encrypt_size(), fileState, id);
            }
        } else if (file.onlyThuAndRaw() && (raw = message.getRawFileDb()) != null) {
            String rawMd5 = ToolUtils.getFileMD5(raw.getRaw_encrypt_path());
            rawUpdate = OptHelper.getIns().getEFUpdate(ImSdkFileConstant.FileType.IS_RAW, raw.getRaw_encrypt_path(), rawMd5, raw.getRaw_encrypt_size(), fileState, id);
        }
        ImSdkDbUtils.updateEF(msgUpdate, fileUpdate, hdUpdate, rawUpdate);
    }

    private void callbackFail(MessageWrapper wrapper) {
        String tag = wrapper.getMsgEntryDb().getSession_flag();
        SessionWrapper sWrapper = ImSdkDbUtils.querySession(OptHelper.getIns().getSMQuery(tag), OptType.SQuery.HAVE);
        IMSession session = ModelMapper.getIns().mapSession(sWrapper);
        IMMessage message = ModelMapper.getIns().mapMessage(wrapper);
        ImSdkCallbackManager.getInstance().callChange(session, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SendOutNode getNode() {
        SendOutNode node = null;
        try {
            while (this.sendOutThread != null && !this.sendOutThread.isInterrupted() && (node = this.sendOutQueue.poll()) == null) {
                LinkedBlockingQueue<SendOutNode> linkedBlockingQueue = this.sendOutQueue;
                synchronized (linkedBlockingQueue) {
                    this.sendOutQueue.wait();
                }
            }
        }
        catch (Exception ie) {
            Logger.getLogger().d("im exit send queue...");
        }
        return node;
    }

    protected class SendOutRunnable
    implements Runnable {
        protected SendOutRunnable() {
        }

        @Override
        public void run() {
            try {
                while (SendOutProcess.this.sendOutThread != null && !SendOutProcess.this.sendOutThread.isInterrupted()) {
                    SendOutNode node = SendOutProcess.this.getNode();
                    if (node == null) {
                        return;
                    }
                    switch (node.getType()) {
                        case NORMAL: {
                            MessageWrapper message = node.getMessage();
                            SendOutProcess.this.sendNormal(message);
                            break;
                        }
                        case STATE: {
                            IMState state = node.getState();
                            SendOutProcess.this.sendState(state);
                            break;
                        }
                        case RECALL: {
                            MessageWrapper recall = node.getMessage();
                            SendOutProcess.this.sendRecall(recall);
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger().d("im exit send thread...");
            }
        }
    }
}

