/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley.request;

import android.text.TextUtils;
import com.xdja.http.Header;
import com.xdja.http.HttpEntity;
import com.xdja.http.HttpResponse;
import com.xdja.http.util.EntityUtils;
import com.xdja.imsdk.volley.NetworkResponse;
import com.xdja.imsdk.volley.Request;
import com.xdja.imsdk.volley.Response;
import com.xdja.imsdk.volley.VolleyLog;
import com.xdja.imsdk.volley.error.CancelError;
import com.xdja.imsdk.volley.error.VolleyError;
import com.xdja.imsdk.volley.toolbox.HttpHeaderParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.zip.GZIPInputStream;

public class DownloadRequest
extends Request<String> {
    private static final int BUFFER_SIZE = 6144;
    private File mStoreFile;
    private File mTemporaryFile;
    private long mFileSize;
    private Response.Listener<String> mListener;
    boolean bSupportRange = false;

    public DownloadRequest(String url, Response.Listener<String> listener, Response.ErrorListener errorListener, Response.LoadingListener loadingListener, Response.CanceledListener canceledListener) {
        this(0, url, listener, errorListener, loadingListener, canceledListener);
    }

    public DownloadRequest(int method, String url, Response.Listener<String> listener, Response.ErrorListener errorListener, Response.LoadingListener loadingListener, Response.CanceledListener canceledListener) {
        super(method, url, errorListener, loadingListener, canceledListener);
        this.mListener = listener;
    }

    public void setTarget(String storePath, long fileSize, boolean isSupportRange) {
        this.bSupportRange = isSupportRange;
        this.setTarget(new File(storePath), fileSize);
    }

    public void setTarget(File storeFile, long fileSize) {
        File dir;
        this.mStoreFile = storeFile;
        this.mFileSize = fileSize;
        this.mTemporaryFile = new File(storeFile + ".tmp");
        if (!this.bSupportRange && this.mTemporaryFile.exists()) {
            VolleyLog.d("Illegal temp file is exist, so delete " + this.mTemporaryFile.delete(), new Object[0]);
        }
        if (!(dir = this.mTemporaryFile.getParentFile()).exists() && !dir.mkdirs()) {
            VolleyLog.e("create file dir Failed:" + dir.getAbsolutePath(), new Object[0]);
        }
    }

    @Override
    public void prepare() {
        if (this.bSupportRange) {
            if (this.mTemporaryFile.length() >= this.mFileSize) {
                this.addHeader("Range", String.format("bytes=%d-", 0));
                this.mTemporaryFile.delete();
            } else {
                this.addHeader("Range", String.format("bytes=%d-", this.mTemporaryFile.length()));
            }
        } else {
            this.addHeader("Range", String.format("bytes=%d-", 0));
        }
    }

    @Override
    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        if (!this.isCanceled()) {
            if (this.mTemporaryFile.canRead() && this.mTemporaryFile.length() > 0L && this.mTemporaryFile.length() >= this.mFileSize) {
                if (this.mTemporaryFile.renameTo(this.mStoreFile)) {
                    this.mTemporaryFile.delete();
                    return Response.success(null, HttpHeaderParser.parseCacheHeaders(response));
                }
                return Response.error(new VolleyError("Can't rename the download temporary file!"));
            }
            if (this.mStoreFile.exists() && this.mStoreFile.length() > 0L && this.mTemporaryFile.length() >= this.mFileSize) {
                return Response.success(null, HttpHeaderParser.parseCacheHeaders(response));
            }
            return Response.error(new VolleyError("Download temporary file was invalid!"));
        }
        return Response.error(new CancelError("Request was Canceled!"));
    }

    private boolean hasError(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        return statusCode < 200 || statusCode > 299;
    }

    public byte[] handleResponse(HttpResponse httpResponse) throws IOException, VolleyError {
        if (this.hasError(httpResponse)) {
            throw new IOException();
        }
        HttpEntity entity = httpResponse.getEntity();
        long fileSize = entity.getContentLength();
        long downloadedSize = this.mTemporaryFile.length();
        boolean isSupportRange = this.isSupportRange(httpResponse);
        if (isSupportRange) {
            String realRangeValue = this.getHeader(httpResponse, "Content-Range");
            if (!TextUtils.isEmpty((CharSequence)realRangeValue)) {
                String assumeRangeValue = "bytes " + downloadedSize + "-";
                VolleyLog.d("assumeRangeValue:" + assumeRangeValue + ",realRangeValue:" + realRangeValue, new Object[0]);
                try {
                    String value = realRangeValue.replace("bytes ", "");
                    int start = Integer.parseInt(value.substring(0, value.indexOf("-")));
                    VolleyLog.d("assumeRangeValue:" + assumeRangeValue + ", start:" + start, new Object[0]);
                    if (start == 0) {
                        downloadedSize = 0L;
                        this.mTemporaryFile.delete();
                    } else if (TextUtils.indexOf((CharSequence)realRangeValue, (CharSequence)assumeRangeValue) == -1) {
                        throw new IOException("The Content-Range Header is invalid Assume[" + assumeRangeValue + "] vs Real[" + realRangeValue + "], " + "please remove the temporary file [" + this.mTemporaryFile + "].");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e);
                }
            }
        } else {
            downloadedSize = 0L;
            this.mTemporaryFile.delete();
        }
        if (!this.mTemporaryFile.exists()) {
            this.mTemporaryFile.createNewFile();
        }
        RandomAccessFile tmpFileRaf = new RandomAccessFile(this.mTemporaryFile, "rw");
        if (isSupportRange) {
            tmpFileRaf.seek(downloadedSize);
        } else {
            tmpFileRaf.setLength(0L);
        }
        InputStream in = null;
        try {
            in = entity.getContent();
            if (this.isGzipContent(httpResponse) && !(in instanceof GZIPInputStream)) {
                in = new GZIPInputStream(in);
            }
            byte[] buffer = new byte[6144];
            int offset = 0;
            fileSize += downloadedSize;
            while ((offset = in.read(buffer)) != -1) {
                tmpFileRaf.write(buffer, 0, offset);
                this.deliverLoading(fileSize, downloadedSize += (long)offset);
                if (!this.isCanceled()) continue;
                this.finish("perform-discard-cancelled");
                throw new CancelError("request is canceled.");
            }
        }
        finally {
            try {
                if (tmpFileRaf != null) {
                    tmpFileRaf.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                VolleyLog.v("Error occured when calling InputStream.close", new Object[0]);
            }
            try {
                EntityUtils.consume(entity);
            }
            catch (Exception e) {
                VolleyLog.v("Error occured when calling consumingContent", new Object[0]);
            }
        }
        return new byte[0];
    }

    @Override
    protected void deliverResponse(String response) {
        if (this.mListener != null) {
            this.mListener.onResponse(response);
        }
    }

    private String getHeader(HttpResponse response, String key) {
        Header header = response.getFirstHeader(key);
        return header == null ? null : header.getValue();
    }

    private boolean isSupportRange(HttpResponse response) {
        if (TextUtils.equals((CharSequence)this.getHeader(response, "Accept-Ranges"), (CharSequence)"bytes")) {
            return true;
        }
        String value = this.getHeader(response, "Content-Range");
        return value != null && value.startsWith("bytes");
    }

    private boolean isGzipContent(HttpResponse response) {
        return TextUtils.equals((CharSequence)this.getHeader(response, "Content-Encoding"), (CharSequence)"gzip");
    }

    @Override
    public Request.Priority getPriority() {
        return Request.Priority.LOW;
    }
}

