/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley.stack;

import android.os.SystemClock;
import com.xdja.http.HttpEntity;
import com.xdja.http.HttpResponse;
import com.xdja.http.NameValuePair;
import com.xdja.http.client.config.RequestConfig;
import com.xdja.http.client.methods.CloseableHttpResponse;
import com.xdja.http.client.methods.HttpDelete;
import com.xdja.http.client.methods.HttpEntityEnclosingRequestBase;
import com.xdja.http.client.methods.HttpGet;
import com.xdja.http.client.methods.HttpHead;
import com.xdja.http.client.methods.HttpOptions;
import com.xdja.http.client.methods.HttpPost;
import com.xdja.http.client.methods.HttpPut;
import com.xdja.http.client.methods.HttpTrace;
import com.xdja.http.client.methods.HttpUriRequest;
import com.xdja.http.entity.ByteArrayEntity;
import com.xdja.http.impl.client.CloseableHttpClient;
import com.xdja.http.impl.client.HttpClients;
import com.xdja.http.message.BasicNameValuePair;
import com.xdja.http.util.EntityUtils;
import com.xdja.imsdk.volley.Request;
import com.xdja.imsdk.volley.RetryPolicy;
import com.xdja.imsdk.volley.VolleyLog;
import com.xdja.imsdk.volley.error.AuthFailureError;
import com.xdja.imsdk.volley.error.CancelError;
import com.xdja.imsdk.volley.error.VolleyError;
import com.xdja.imsdk.volley.stack.HttpStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HttpClientStack
implements HttpStack {
    private static CloseableHttpClient mHttpClient = null;
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final int BUFFER_SIZE = 65536;

    public HttpClientStack() {
    }

    public HttpClientStack(CloseableHttpClient client) {
        mHttpClient = client;
    }

    public static void release() {
        try {
            if (mHttpClient != null) {
                mHttpClient.close();
                mHttpClient = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static List<NameValuePair> getPostParameterPairs(Map<String, String> postParams) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>(postParams.size());
        for (String key : postParams.keySet()) {
            result.add(new BasicNameValuePair(key, postParams.get(key)));
        }
        return result;
    }

    private void assertCanceled(Request<?> request) throws VolleyError {
        if (request != null && request.isCanceled()) {
            VolleyLog.d("HttpClientStack performRequest canceled.", new Object[0]);
            request.finish("perform-discard-cancelled");
            throw new CancelError("request is canceled.");
        }
    }

    private void closeResponse(CloseableHttpResponse response) throws IOException {
        if (response != null) {
            if (this.hasError(response)) {
                throw new IOException();
            }
            response.close();
        }
    }

    private void attemptRetryOnException(Request<?> request, long connectExpendTime) throws VolleyError {
        RetryPolicy retryPolicy = request.getRetryPolicy();
        long elapsedRealTime = (long)retryPolicy.getElapsedTimeTimeoutMs() + (SystemClock.elapsedRealtime() - connectExpendTime);
        if (elapsedRealTime > (long)retryPolicy.getInitialTimeoutMs()) {
            VolleyLog.e("upload file timeout, which currently consumes " + elapsedRealTime + " ms", new Object[0]);
            request.addMarker("request_discard_timeout");
            throw new VolleyError("perform request timeout, " + request.toString());
        }
    }

    @Override
    public CloseableHttpResponse performRequest(Request<?> request, Map<String, String> additionalHeaders) throws IOException, VolleyError {
        CloseableHttpResponse response = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(request.getRetryPolicy().getCurrentTimeout()).setConnectTimeout(request.getRetryPolicy().getCurrentTimeout()).setSocketTimeout(request.getRetryPolicy().getCurrentTimeout()).build();
        HttpPost post = new HttpPost(request.getUrl());
        post.setConfig(requestConfig);
        HttpEntity entity = request.getHttpEntity();
        long connectStartTime = SystemClock.elapsedRealtime();
        if (entity != null) {
            this.setHeader(post, request.getHeaders());
            post.setEntity(entity);
            response = this.getHttpClient().execute(post);
            this.closeResponse(response);
            this.assertCanceled(request);
            this.attemptRetryOnException(request, connectStartTime);
        } else {
            FileInputStream fileInputStream = null;
            try {
                int length;
                File uploadFile = request.getPostFile();
                long fileSize = uploadFile.length();
                byte[] buffer = new byte[65536];
                ByteArrayEntity byteArrayEntity = null;
                fileInputStream = new FileInputStream(request.getPostFile());
                post.setHeader(HEADER_CONTENT_TYPE, APPLICATION_OCTET_STREAM);
                fileInputStream.skip(request.getTransLateSize());
                long transferredSize = request.getTransLateSize();
                while ((length = fileInputStream.read(buffer)) != -1) {
                    byteArrayEntity = new ByteArrayEntity(buffer, 0, length);
                    post.setEntity(byteArrayEntity);
                    response = this.getHttpClient().execute(post);
                    this.closeResponse(response);
                    if (response != null) {
                        request.setTransLateSize(transferredSize += (long)length);
                        request.deliverLoading(fileSize, transferredSize);
                    }
                    this.assertCanceled(request);
                    this.attemptRetryOnException(request, connectStartTime);
                }
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                EntityUtils.consume(entity);
            }
        }
        return response;
    }

    private synchronized CloseableHttpClient getHttpClient() {
        if (mHttpClient == null) {
            mHttpClient = HttpClients.createDefault();
        }
        return mHttpClient;
    }

    private boolean hasError(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200 || statusCode == 206) {
            return false;
        }
        VolleyLog.e("handle response, but has error, code is " + statusCode, new Object[0]);
        return true;
    }

    private void setHeader(HttpPost post, Map<String, String> headers) {
        for (String key : headers.keySet()) {
            post.setHeader(key, headers.get(key));
        }
    }

    static HttpUriRequest createHttpRequest(Request<?> request, Map<String, String> additionalHeaders) throws AuthFailureError {
        switch (request.getMethod()) {
            case -1: {
                byte[] postBody = request.getPostBody();
                if (postBody != null) {
                    HttpPost postRequest = new HttpPost(request.getUrl());
                    postRequest.addHeader(HEADER_CONTENT_TYPE, request.getPostBodyContentType());
                    ByteArrayEntity entity = new ByteArrayEntity(postBody);
                    postRequest.setEntity(entity);
                    return postRequest;
                }
                return new HttpGet(request.getUrl());
            }
            case 0: {
                return new HttpGet(request.getUrl());
            }
            case 3: {
                return new HttpDelete(request.getUrl());
            }
            case 1: {
                HttpPost postRequest = new HttpPost(request.getUrl());
                postRequest.addHeader(HEADER_CONTENT_TYPE, request.getBodyContentType());
                HttpClientStack.setEntityIfNonEmptyBody(postRequest, request);
                return postRequest;
            }
            case 2: {
                HttpPut putRequest = new HttpPut(request.getUrl());
                putRequest.addHeader(HEADER_CONTENT_TYPE, request.getBodyContentType());
                HttpClientStack.setEntityIfNonEmptyBody(putRequest, request);
                return putRequest;
            }
            case 4: {
                return new HttpHead(request.getUrl());
            }
            case 5: {
                return new HttpOptions(request.getUrl());
            }
            case 6: {
                return new HttpTrace(request.getUrl());
            }
            case 7: {
                HttpPatch patchRequest = new HttpPatch(request.getUrl());
                patchRequest.addHeader(HEADER_CONTENT_TYPE, request.getBodyContentType());
                HttpClientStack.setEntityIfNonEmptyBody(patchRequest, request);
                return patchRequest;
            }
        }
        throw new IllegalStateException("Unknown request method.");
    }

    private static void setEntityIfNonEmptyBody(HttpEntityEnclosingRequestBase httpRequest, Request<?> request) throws AuthFailureError {
        byte[] body = request.getBody();
        if (body != null) {
            ByteArrayEntity entity = new ByteArrayEntity(body);
            httpRequest.setEntity(entity);
        }
    }

    protected void onPrepareRequest(HttpUriRequest request) throws IOException {
    }

    public static final class HttpPatch
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "PATCH";

        public HttpPatch() {
        }

        public HttpPatch(URI uri) {
            this.setURI(uri);
        }

        public HttpPatch(String uri) {
            this.setURI(URI.create(uri));
        }

        @Override
        public String getMethod() {
            return METHOD_NAME;
        }
    }
}

