/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.base.frame.presenter;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.view.AdapterBaseView;
import java.util.List;

public abstract class BaseItemAdapterPresenter<P extends Presenter, D>
extends BaseAdapter {
    public View getView(int position, View convertView, ViewGroup parent) {
        AdapterBaseView<P, D> adapterVu = null;
        if (convertView == null) {
            try {
                int itemViewType = this.getItemViewType(position);
                Class<AdapterBaseView<P, D>> aClass = this.getVuClassByViewType(itemViewType);
                if (aClass == null) {
                    throw new NullPointerException("item view type error!");
                }
                adapterVu = aClass.newInstance();
                adapterVu.setPresenter(this.getPresenter());
                adapterVu.setActivity(this.getActivity());
                adapterVu.init(LayoutInflater.from((Context)parent.getContext()), parent);
                convertView = adapterVu.getView();
                convertView.setTag(adapterVu);
                adapterVu.onViewCreated();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            adapterVu = (AdapterBaseView<P, D>)convertView.getTag();
            adapterVu.onViewReused();
        }
        adapterVu.bindDataSource(position, this.getDataSource(position));
        return convertView;
    }

    protected abstract List<Class<? extends AdapterBaseView<P, D>>> getVuClasses();

    protected abstract P getPresenter();

    protected abstract D getDataSource(int var1);

    @NonNull
    protected Class<? extends AdapterBaseView<P, D>> getVuClassByViewType(int itemViewType) {
        if (this.getVuClasses() != null && itemViewType < this.getVuClasses().size()) {
            return this.getVuClasses().get(itemViewType);
        }
        return null;
    }

    protected Activity getActivity() {
        return null;
    }
}

