/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.imagecompresser;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.xdja.im.common.imagecompresser.Engine;
import com.xdja.im.common.imagecompresser.OnCompressListener;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.File;
import java.io.IOException;

public class ImageCompressor
implements Handler.Callback {
    private static final String TAG = "ImageCompressor";
    private static final String DEFAULT_DISK_CACHE_DIR = "image_disk_cache";
    private static final int MSG_COMPRESS_SUCCESS = 0;
    private static final int MSG_COMPRESS_START = 1;
    private static final int MSG_COMPRESS_ERROR = 2;
    private File file;
    private File cacheDir;
    private OnCompressListener onCompressListener;
    private Handler mHandler;

    public ImageCompressor(Builder builder) {
        this.file = builder.file;
        this.cacheDir = builder.cacheDir;
        this.onCompressListener = builder.onCompressListener;
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public static Builder with(Context context) {
        return new Builder(context);
    }

    private File getImageCacheFile(Context context) {
        if (this.getImageCacheDir(context) != null) {
            return new File(this.getImageCacheDir(context) + "/" + System.currentTimeMillis() + (int)(Math.random() * 1000.0) + ".jpg");
        }
        return null;
    }

    @Nullable
    private File getImageCacheDir(Context context) {
        return this.getImageCacheDir(context, DEFAULT_DISK_CACHE_DIR);
    }

    @Nullable
    private File getImageCacheDir(Context context, String cacheName) {
        if (this.cacheDir == null) {
            this.cacheDir = context.getExternalCacheDir();
        }
        if (this.cacheDir != null) {
            File result = new File(this.cacheDir, cacheName);
            if (!(result.mkdirs() || result.exists() && result.isDirectory())) {
                return null;
            }
            return result;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            LogUtil.e(TAG, "default disk cache dir is null");
        }
        return null;
    }

    @WorkerThread
    private File get(Context context) throws IOException {
        return new Engine(this.file, this.getImageCacheFile(context)).compress();
    }

    @UiThread
    private void start(final Context context) {
        if (this.file == null && this.onCompressListener != null) {
            this.onCompressListener.onError(new NullPointerException("image file cannot be null"));
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ImageCompressor.this.mHandler.sendMessage(ImageCompressor.this.mHandler.obtainMessage(1));
                    File result = new Engine(ImageCompressor.this.file, ImageCompressor.this.getImageCacheFile(context)).compress();
                    ImageCompressor.this.mHandler.sendMessage(ImageCompressor.this.mHandler.obtainMessage(0, (Object)result));
                }
                catch (IOException e) {
                    ImageCompressor.this.mHandler.sendMessage(ImageCompressor.this.mHandler.obtainMessage(2, (Object)e));
                }
            }
        }).start();
    }

    public boolean handleMessage(Message msg) {
        if (this.onCompressListener == null) {
            return false;
        }
        switch (msg.what) {
            case 1: {
                this.onCompressListener.onStart();
                break;
            }
            case 0: {
                this.onCompressListener.onSuccess((File)msg.obj);
                break;
            }
            case 2: {
                this.onCompressListener.onError((Throwable)msg.obj);
            }
        }
        return false;
    }

    public static class Builder {
        private Context context;
        private File file;
        private File cacheDir;
        private OnCompressListener onCompressListener;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder load(File file) {
            this.file = file;
            return this;
        }

        public File get() throws IOException {
            return this.build().get(this.context);
        }

        public Builder setCompressListener(OnCompressListener listener) {
            this.onCompressListener = listener;
            return this;
        }

        public Builder setCacheDir(File dir) {
            this.cacheDir = dir;
            return this;
        }

        public ImageCompressor build() {
            return new ImageCompressor(this);
        }

        public void start() {
            this.build().start(this.context);
        }
    }
}

