/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.utils;

import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.text.DecimalFormat;

public class FileSizeUtils {
    public static final int SIZETYPE_B = 1;
    public static final int SIZETYPE_KB = 2;
    public static final int SIZETYPE_MB = 3;
    public static final int SIZETYPE_GB = 4;
    private static DecimalFormat format_W1 = new DecimalFormat("#.0");
    private static DecimalFormat format_W2 = new DecimalFormat("#.00");

    public static double getFileOrFilesSize(String filePath, int sizeType) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? FileSizeUtils.getFileSizes(file) : FileSizeUtils.getFileSize(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Double.valueOf(FileSizeUtils.formatFileSize(blockSize, sizeType, format_W2));
    }

    public static String getAutoFileOrFilesSize(String filePath) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? FileSizeUtils.getFileSizes(file) : FileSizeUtils.getFileSize(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FileSizeUtils.formatFileSize(blockSize);
    }

    public static long getFileSize(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return 0L;
        }
        File file = new File(filePath);
        try {
            if (file.exists()) {
                return FileSizeUtils.getFileSize(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static long getFileSize(File file) throws Exception {
        long size = 0L;
        if (file.exists()) {
            FileInputStream fis = null;
            fis = new FileInputStream(file);
            size = fis.available();
        } else {
            file.createNewFile();
        }
        return size;
    }

    public static long getFileSizes(File f) throws Exception {
        long size = 0L;
        File[] flist = f.listFiles();
        for (int i = 0; i < flist.length; ++i) {
            if (flist[i].isDirectory()) {
                size += FileSizeUtils.getFileSizes(flist[i]);
                continue;
            }
            size += FileSizeUtils.getFileSize(flist[i]);
        }
        return size;
    }

    public static String formatAutoFileSize(long fileS) {
        String wrongSize = "0B";
        if (fileS == 0L) {
            return wrongSize;
        }
        String fileSizeString = fileS < 1024L ? FileSizeUtils.formatFileSize(fileS, 1, format_W1) : (fileS < 0x100000L ? FileSizeUtils.formatFileSize(fileS, 2, format_W1) : (fileS < 0x40000000L ? FileSizeUtils.formatFileSize(fileS, 3, format_W2) : FileSizeUtils.formatFileSize(fileS, 4, format_W2)));
        return fileSizeString;
    }

    public static String formatFileSize(long fileS) {
        String wrongSize = "0B";
        if (fileS == 0L) {
            return wrongSize;
        }
        String fileSizeString = fileS < 1024L ? FileSizeUtils.formatFileSize(fileS, 1, format_W2) : (fileS < 0x100000L ? FileSizeUtils.formatFileSize(fileS, 2, format_W2) : (fileS < 0x40000000L ? FileSizeUtils.formatFileSize(fileS, 3, format_W2) : FileSizeUtils.formatFileSize(fileS, 4, format_W2)));
        return fileSizeString;
    }

    public static String formatFileSize(long fileS, int sizeType) {
        return FileSizeUtils.formatFileSize(fileS, sizeType, format_W2);
    }

    public static String formatFileSize(long fileS, int sizeType, DecimalFormat format) {
        String fileSizeString = "";
        switch (sizeType) {
            case 1: {
                fileSizeString = format.format((double)fileS) + "B";
                break;
            }
            case 2: {
                fileSizeString = format.format((double)fileS / 1024.0) + "KB";
                break;
            }
            case 3: {
                fileSizeString = format.format((double)fileS / 1048576.0) + "MB";
                break;
            }
            case 4: {
                fileSizeString = format.format((double)fileS / 1.073741824E9) + "GB";
                break;
            }
        }
        return fileSizeString;
    }

    public static String FormetFileSize(long fileS) {
        String fileSizeString;
        DecimalFormat df = new DecimalFormat("#.00");
        String wrongSize = "0B";
        if (fileS == 0L) {
            return wrongSize;
        }
        if (fileS < 1024L) {
            fileSizeString = df.format((double)fileS) + "B";
            if (fileSizeString.contains(".")) {
                String[] s = fileSizeString.split("\\.");
                fileSizeString = s[0] + "B";
            }
        } else if (fileS < 0x100000L) {
            fileSizeString = df.format((double)fileS / 1024.0) + "KB";
            if (fileSizeString.contains(".")) {
                String[] s = fileSizeString.split("\\.");
                fileSizeString = s[0] + "KB";
            }
        } else {
            fileSizeString = fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "MB" : df.format((double)fileS / 1.073741824E9) + "GB";
        }
        return fileSizeString;
    }
}

