/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.repository.impl.datasource;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xdja.im.common.database.helper.IMSettingHelper;
import com.xdja.im.common.database.helper.MXSettingHelper;
import com.xdja.im.common.persistent.PreferencesUtil;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.model.param.SettingParam;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.entity.KeyValuePair;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class DiskDataStoreImpl
implements DiskDataStore {
    private PreferencesUtil preferencesUtil;

    @Inject
    public DiskDataStoreImpl(PreferencesUtil preferencesUtil) {
        this.preferencesUtil = preferencesUtil;
    }

    @Override
    public void setSessionTop(String sessionFlag, final boolean isTop, Subscriber<Boolean> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String sessionFlag) {
                boolean ret = MXSettingHelper.setSessionTop(sessionFlag, isTop);
                if (!ret) {
                    return Observable.error((Throwable)new Exception("Save session error."));
                }
                return Observable.just((Object)ret);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void setSessionDisturb(String sessionFlag, final boolean isDisturb, Subscriber<Boolean> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String sessionFlag) {
                boolean ret = MXSettingHelper.setSessionDisturb(sessionFlag, isDisturb);
                if (!ret) {
                    return Observable.error((Throwable)new Exception("Save session error."));
                }
                return Observable.just((Object)ret);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void setReceiveMode(String sessionFlag, final boolean isOpen, Subscriber<Boolean> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String sessionFlag) {
                boolean ret = MXSettingHelper.setReceiveMode(sessionFlag, isOpen);
                if (!ret) {
                    return Observable.error((Throwable)new Exception("Save session error."));
                }
                return Observable.just((Object)ret);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void saveDraftContent(String sessionFlag, final String content, final long draftTime, Subscriber<Boolean> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String sessionFlag) {
                boolean ret = MXSettingHelper.insertDraft(sessionFlag, content, draftTime);
                if (!ret) {
                    return Observable.error((Throwable)new Exception("Save draft error."));
                }
                return Observable.just((Object)ret);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void clearDraftContent(String sessionFlag, final long draftTime, Subscriber<Boolean> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String sessionFlag) {
                boolean ret = MXSettingHelper.clearDraft(sessionFlag, draftTime);
                if (!ret) {
                    return Observable.error((Throwable)new Exception("Clear draft error."));
                }
                return Observable.just((Object)ret);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void getDraftContent(String sessionFlag, Subscriber<String> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<String>>(){

            public Observable<String> call(String sessionFlag) {
                String content = MXSettingHelper.getDraftContent(sessionFlag);
                return Observable.just((Object)content);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void loadSessionParam(String sessionFlag, Subscriber<SessionParam> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<SessionParam>>(){

            public Observable<SessionParam> call(String sessionFlag) {
                SessionParam param = MXSettingHelper.getSessionParam(sessionFlag);
                if (param == null) {
                    return Observable.error((Throwable)new Exception("Load session param is null."));
                }
                return Observable.just((Object)param);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void loadAllSessionParams(Subscriber<List<SessionParam>> subscriber) {
        Observable.just((Object)"").subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<List<SessionParam>>>(){

            public Observable<List<SessionParam>> call(String s) {
                List<SessionParam> params = MXSettingHelper.getAllSessionParams();
                return Observable.just(params);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public Observable<List<SessionParam>> saveSettingTopAndNodisturb2Local(final List<SessionParam> configs) {
        return this.querySessionSettingsAtLocal().map((Func1)new Func1<List<SessionParam>, List<SessionParam>>(){

            public List<SessionParam> call(List<SessionParam> localSConfigs) {
                if (configs.size() == 0) {
                    for (SessionParam config : localSConfigs) {
                        config.setDisturb(false);
                        config.setTop(false);
                    }
                    return localSConfigs;
                }
                if (localSConfigs.size() > 0) {
                    boolean isMatch = false;
                    SessionParam config = null;
                    ArrayList<SessionParam> addChange = new ArrayList<SessionParam>();
                    ArrayList<SessionParam> addClodChange = new ArrayList<SessionParam>();
                    if (configs != null) {
                        for (int i = 0; i < configs.size(); ++i) {
                            SessionParam itemConfig = (SessionParam)configs.get(i);
                            for (int j = 0; j < localSConfigs.size(); ++j) {
                                config = localSConfigs.get(j);
                                if (!config.equals(itemConfig)) continue;
                                isMatch = true;
                                break;
                            }
                            if (isMatch) {
                                config.setTop(itemConfig.isTop());
                                config.setDisturb(itemConfig.isDisturb());
                                addChange.add(config);
                                localSConfigs.remove(config);
                                addClodChange.add(itemConfig);
                            }
                            isMatch = false;
                        }
                    }
                    configs.removeAll(addClodChange);
                    if (configs.size() > 0) {
                        for (SessionParam clodConfig : configs) {
                            SessionParam sessionConfig = new SessionParam();
                            sessionConfig.setDisturb(clodConfig.isDisturb());
                            sessionConfig.setTop(clodConfig.isTop());
                            sessionConfig.setSessionFlag(clodConfig.getSessionFlag());
                            addChange.add(sessionConfig);
                        }
                    }
                    if (localSConfigs != null) {
                        for (SessionParam localConfig : localSConfigs) {
                            localConfig.setDisturb(false);
                            localConfig.setTop(false);
                        }
                    }
                    localSConfigs.addAll(addChange);
                    return localSConfigs;
                }
                return configs;
            }
        }).flatMap((Func1)new Func1<List<SessionParam>, Observable<List<SessionParam>>>(){

            public Observable<List<SessionParam>> call(List<SessionParam> configs) {
                return Observable.from(configs).flatMap((Func1)new Func1<SessionParam, Observable<SessionParam>>(){

                    public Observable<SessionParam> call(SessionParam sessionConfig) {
                        MXSettingHelper.updateSessionParam(sessionConfig);
                        return Observable.just((Object)sessionConfig);
                    }
                }).toList();
            }
        });
    }

    public Observable<List<SessionParam>> querySessionSettingsAtLocal() {
        return Observable.just((Object)"").subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<List<SessionParam>>>(){

            public Observable<List<SessionParam>> call(String s) {
                List<SessionParam> params = MXSettingHelper.getAllSessionParams();
                return Observable.just(params);
            }
        });
    }

    @Override
    public void deleteSessionParam(final String sessionFlag, Subscriber<Boolean> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String s) {
                MXSettingHelper.deleteOnlyDraft(sessionFlag);
                return Observable.just((Object)true);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void deleteAllSessionParams(Subscriber<Boolean> subscriber) {
        Observable.just((Object)"").subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String s) {
                boolean ret = MXSettingHelper.deleteAllSessionParams();
                if (!ret) {
                    return Observable.error((Throwable)new Exception("Save session error."));
                }
                return Observable.just((Object)ret);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public Observable<Boolean> saveIntKeyValuePairs(@NonNull KeyValuePair<String, Integer> keyValuePair) {
        if (keyValuePair == null || TextUtils.isEmpty((CharSequence)keyValuePair.getKey())) {
            return Observable.error((Throwable)new Throwable(ImUiKit.getInstance().getContext().getString(R.string.im_uikit_cache_data_null)));
        }
        return Observable.just(keyValuePair).map((Func1)new Func1<KeyValuePair<String, Integer>, Boolean>(){

            public Boolean call(@NonNull KeyValuePair<String, Integer> keyValuePair) {
                LogUtil.i("", "\u5b58\u50a8\u6570\u636e\u5230\u672c\u5730 --- Key : " + keyValuePair.getKey());
                LogUtil.i("", "\t\t\tValue : " + keyValuePair.getValue());
                return DiskDataStoreImpl.this.preferencesUtil.setPreferenceIntValue(keyValuePair.getKey(), keyValuePair.getValue());
            }
        });
    }

    @Override
    public Observable<Boolean> queryIntegerSharePref(@Nullable String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return Observable.error((Throwable)new Throwable(ImUiKit.getInstance().getContext().getString(R.string.im_uikit_query_key_null)));
        }
        return Observable.just((Object)key).map((Func1)new Func1<String, Boolean>(){

            public Boolean call(String s) {
                int value = DiskDataStoreImpl.this.preferencesUtil.gPrefIntValue(s);
                LogUtil.i("", "\u4eceSharePreference\u4e2d\u67e5\u8be2\u5230\u7f13\u5b58\u6570\u636e\uff0cKey : " + s + " ,Value : " + value);
                return value > 0;
            }
        }).flatMap((Func1)new Func1<Boolean, Observable<Boolean>>(){

            public Observable<Boolean> call(Boolean aBoolean) {
                return Observable.just((Object)aBoolean);
            }
        });
    }

    @Override
    public void loadSettingParams(Subscriber<SettingParam> subscriber) {
        Observable.just((Object)"").subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<SettingParam>>(){

            public Observable<SettingParam> call(String s) {
                SettingParam settingParam = IMSettingHelper.getSettingParam();
                if (settingParam == null) {
                    return Observable.error((Throwable)new Exception("Save session error."));
                }
                return Observable.just((Object)settingParam);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }
}

