/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.repository.impl.im;

import android.content.Context;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.event.IMProxyFileEvent;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.event.IMProxySessionEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.repository.interf.im.IMProxyCallBack;
import com.xdja.im.uikit.utils.NetworkHelper;
import java.util.List;
import javax.inject.Inject;

public class IMProxyCallBackImpl
implements IMProxyCallBack {
    private Context context;
    private UserCache userCache;

    @Inject
    public IMProxyCallBackImpl(@Scoped(value="application") Context context, UserCache userCache) {
        this.context = context;
        this.userCache = userCache;
    }

    @Override
    public int onInitFinished() {
        try {
            IMProxyEvent.OnInitFinishedEvent onInitFinishedEvent = new IMProxyEvent.OnInitFinishedEvent();
            BusProvider.getInstance().post(onInitFinishedEvent);
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int onInitFailed() {
        try {
            IMProxyEvent.OnInitFailedEvent onInitFailedEvent = new IMProxyEvent.OnInitFailedEvent();
            BusProvider.getInstance().post(onInitFailedEvent);
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int onCreateNewSession(TalkSessionBean talkSessionBean) {
        try {
            IMProxySessionEvent.CreateNewSessionEvent talkEvent = new IMProxySessionEvent.CreateNewSessionEvent();
            talkEvent.setTalkId(talkSessionBean.getTalkerAccount());
            talkEvent.setSessionBean(talkSessionBean);
            BusProvider.getInstance().post(talkEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int onDeleteSession(TalkSessionBean talkSessionBean) {
        try {
            IMProxySessionEvent.DeleteSessionEvent talkEvent = new IMProxySessionEvent.DeleteSessionEvent();
            talkEvent.setTalkId(talkSessionBean.getTalkerAccount());
            talkEvent.setSessionBean(talkSessionBean);
            BusProvider.getInstance().post(talkEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int onRefreshSession(TalkSessionBean talkSessionBean) {
        try {
            IMProxySessionEvent.RefreshSessionEvent talkEvent = new IMProxySessionEvent.RefreshSessionEvent();
            talkEvent.setTalkId(talkSessionBean.getTalkerAccount());
            talkEvent.setSessionBean(talkSessionBean);
            BusProvider.getInstance().post(talkEvent);
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int onReceiveNewMessage(String account, List<TalkMessageBean> talkMessageBean) {
        try {
            IMProxyMessageEvent.ReceiveNewMessageEvent messageEvent = new IMProxyMessageEvent.ReceiveNewMessageEvent();
            messageEvent.setMsgAccount(account);
            messageEvent.setTalkMessageList(talkMessageBean);
            BusProvider.getInstance().post(messageEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int onRemainNewMessage(TalkSessionBean session, List<TalkMessageBean> talkMessageBean) {
        try {
            IMProxyMessageEvent.NewMsgComeEvent event = new IMProxyMessageEvent.NewMsgComeEvent();
            event.setListBean(session);
            event.setBeans(talkMessageBean);
            BusProvider.getInstance().post(event);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int onDeleteMessage(String account, TalkMessageBean talkMessageBean) {
        try {
            IMProxyMessageEvent.DeleteMessageEvent messageEvent = new IMProxyMessageEvent.DeleteMessageEvent();
            messageEvent.setMsgAccount(account);
            messageEvent.setTalkMessageBean(talkMessageBean);
            BusProvider.getInstance().post(messageEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int onRefreshMessage(String account, TalkMessageBean talkMessageBean) {
        try {
            IMProxyMessageEvent.RefreshMessageEvent messageEvent = new IMProxyMessageEvent.RefreshMessageEvent();
            messageEvent.setMsgAccount(account);
            messageEvent.setTalkMessageBean(talkMessageBean);
            BusProvider.getInstance().post(messageEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int refreshMessageList() {
        try {
            IMProxyMessageEvent.RefreshMessageListEvent messageEvent = new IMProxyMessageEvent.RefreshMessageListEvent();
            BusProvider.getInstance().post(messageEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int onSendFileProgressUpdate(String talkId, long msgId, FileInfo fileInfo, int progress) {
        try {
            IMProxyFileEvent.SendFileProgressUpdateEvent fileEvent = new IMProxyFileEvent.SendFileProgressUpdateEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            fileEvent.setPercent(progress);
            fileEvent.setFileProperty(fileInfo.getFileProperty());
            BusProvider.getInstance().post(fileEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int onSendFileFinished(String talkId, long msgId, FileInfo fileInfo) {
        try {
            IMProxyFileEvent.SendFileFinishedEvent fileEvent = new IMProxyFileEvent.SendFileFinishedEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            BusProvider.getInstance().post(fileEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int onSendFileFailed(String talkId, long msgId, FileInfo fileInfo, int code) {
        try {
            IMProxyFileEvent.SendFileFailedEvent fileEvent = new IMProxyFileEvent.SendFileFailedEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            BusProvider.getInstance().post(fileEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int onReceiveFileProgressUpdate(String talkId, long msgId, FileInfo fileInfo, int progress) {
        try {
            IMProxyFileEvent.ReceiveFileProgressUpdateEvent fileEvent = new IMProxyFileEvent.ReceiveFileProgressUpdateEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            fileEvent.setPercent(progress);
            BusProvider.getInstance().post(fileEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int onReceiveFileFinished(String talkId, long msgId, FileInfo fileInfo) {
        try {
            IMProxyFileEvent.ReceiveFileFinishedEvent fileEvent = new IMProxyFileEvent.ReceiveFileFinishedEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            BusProvider.getInstance().post(fileEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int onReceiveFileFailed(String talkId, long msgId, FileInfo fileInfo, int code) {
        try {
            IMProxyFileEvent.ReceiveFileFailedEvent fileEvent = new IMProxyFileEvent.ReceiveFileFailedEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            BusProvider.getInstance().post(fileEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int onReceiveFilePaused(String talkId, long msgId, FileInfo fileInfo) {
        try {
            IMProxyFileEvent.ReceiveFilePausedEvent fileEvent = new IMProxyFileEvent.ReceiveFilePausedEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            BusProvider.getInstance().post(fileEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int onRecallSuccess(TalkSessionBean talkSessionBean, TalkMessageBean talkMessageBean) {
        try {
            IMProxyEvent.RecallMessageEvent recallMessageEvent = new IMProxyEvent.RecallMessageEvent();
            recallMessageEvent.setTalkSessionBean(talkSessionBean);
            recallMessageEvent.setTalkMessageBeans(talkMessageBean);
            BusProvider.getInstance().post(recallMessageEvent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    @Override
    public int onRecallFail(TalkSessionBean talkSessionBean, TalkMessageBean talkMessageBean, int failCode) {
        try {
            IMProxyEvent.RecallFailEvent recallFailEvent = new IMProxyEvent.RecallFailEvent();
            recallFailEvent.setTalkSessionBean(talkSessionBean);
            recallFailEvent.setTalkMessageBean(talkMessageBean);
            BusProvider.getInstance().post(recallFailEvent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    @Override
    public int onReceiveNetState(int netState) {
        try {
            NetworkHelper.getHelper().receiveNetState(netState);
            if (NetworkHelper.getHelper().networkChanged()) {
                IMProxyEvent.NetworkStateEvent networkStateEvent = new IMProxyEvent.NetworkStateEvent();
                networkStateEvent.setState(netState);
                BusProvider.getInstance().post(networkStateEvent);
                return 1;
            }
            return 0;
        }
        catch (Exception ex) {
            return 0;
        }
    }
}

