/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.album.ui.adapter;

import android.app.Activity;
import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import com.xdja.im.common.imageloader.CustomImageLoader;
import com.xdja.im.lib.album.bean.ImageItem;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.view.PhotoView;
import java.util.ArrayList;
import java.util.List;

public class ImagePreviewAdapter
extends PagerAdapter {
    private Activity mActivity;
    private List<ImageItem> images = new ArrayList<ImageItem>();
    private int screenWidth;
    private int screenHeight;

    public ImagePreviewAdapter(Activity mActivity, List<ImageItem> images) {
        this.mActivity = mActivity;
        this.images = images;
        DisplayMetrics displaysMetrics = new DisplayMetrics();
        mActivity.getWindowManager().getDefaultDisplay().getMetrics(displaysMetrics);
        this.screenWidth = displaysMetrics.widthPixels;
        this.screenHeight = displaysMetrics.heightPixels;
    }

    public void setData(ArrayList<ImageItem> images) {
        this.images = images;
    }

    public int getCount() {
        return this.images == null ? 0 : this.images.size();
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        PhotoView photoView = new PhotoView((Context)this.mActivity);
        photoView.enable();
        ImageItem imageItem = this.images.get(position);
        try {
            CustomImageLoader.getInstance().crateBuilder().load(imageItem.getPath()).preLoad(this.screenWidth, this.screenHeight).error(R.mipmap.im_uikit_pic_default).into(photoView).build();
        }
        catch (Exception e) {
            photoView.setImageResource(R.mipmap.im_uikit_pic_default);
        }
        catch (OutOfMemoryError e) {
            photoView.setImageResource(R.mipmap.im_uikit_pic_default);
        }
        container.addView((View)photoView);
        return photoView;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }
}

