/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.support.v4.app.Fragment;
import com.xdja.im.common.imageloader.DefaultImageLoader;
import com.xdja.im.common.imageloader.ImageLoader;
import com.xdja.im.lib.camera.CameraConfig;
import com.xdja.im.lib.camera.ui.activity.TakePhotoActivity;

public class CameraManager {
    private ImageLoader mImageLoader;
    private CameraConfig cameraConfig;
    private static final String CACHE_PATH = "camera";

    private CameraManager() {
    }

    public static CameraManager getInstance() {
        return CameraManagerInstance.mInstance;
    }

    public void startTakePhoto(Fragment fragment, int requestCode) {
        Intent intent = new Intent();
        intent.setClass(fragment.getContext(), TakePhotoActivity.class);
        fragment.startActivityForResult(intent, requestCode);
    }

    public void startTakePhoto(Activity activity, int requestCode) {
        Intent intent = new Intent();
        intent.setClass((Context)activity, TakePhotoActivity.class);
        activity.startActivityForResult(intent, requestCode);
    }

    public ImageLoader getImageLoader() {
        if (this.mImageLoader == null) {
            this.mImageLoader = new DefaultImageLoader();
        }
        return this.mImageLoader;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.mImageLoader = imageLoader;
    }

    public CameraConfig getConfig() {
        if (this.cameraConfig == null) {
            this.cameraConfig = new CameraConfig();
            this.cameraConfig.setCachePath(Environment.getExternalStorageDirectory() + "/" + CACHE_PATH);
        }
        return this.cameraConfig;
    }

    private static class CameraManagerInstance {
        private static final CameraManager mInstance = new CameraManager();

        private CameraManagerInstance() {
        }
    }
}

