/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.file.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xdja.im.uikit.R;

public class ViewPagerIndicator
extends HorizontalScrollView {
    private static final int[] ATTRS = new int[]{16842901, 16842904};
    private PagerListener pagerListener = new PagerListener();
    private ViewPager.OnPageChangeListener delegateListener;
    private LinearLayout.LayoutParams expandLayoutParams;
    private Paint indicatorPaint;
    private LinearLayout tabLayout;
    private ViewPager viewPager;
    private int tabCount;
    private int currentPosition;
    private float currentPositionOffset;
    private int indicatorColor = -10066330;
    private int underlineColor = 0x1A000000;
    private int scrollOffset = 52;
    private int indicatorHeight = 8;
    private int underlineHeight = 2;
    private int tabPadding = 12;
    private int tabTextSize = 12;
    private int tabTextColor = -10066330;
    private int tabTextSelectColor = -218103808;
    private int lastScrollX = 0;
    private int tabBackgroundResId = R.drawable.im_uikit_bg_viewapager_bg_tab;

    public ViewPagerIndicator(Context context) {
        this(context, null);
    }

    public ViewPagerIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ViewPagerIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setFillViewport(true);
        this.setWillNotDraw(false);
        this.tabLayout = new LinearLayout(context);
        this.tabLayout.setOrientation(0);
        this.tabLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.addView((View)this.tabLayout);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.scrollOffset = (int)TypedValue.applyDimension((int)1, (float)this.scrollOffset, (DisplayMetrics)dm);
        this.indicatorHeight = (int)TypedValue.applyDimension((int)1, (float)this.indicatorHeight, (DisplayMetrics)dm);
        this.underlineHeight = (int)TypedValue.applyDimension((int)1, (float)this.underlineHeight, (DisplayMetrics)dm);
        this.tabPadding = (int)TypedValue.applyDimension((int)1, (float)this.tabPadding, (DisplayMetrics)dm);
        this.tabTextSize = (int)TypedValue.applyDimension((int)2, (float)this.tabTextSize, (DisplayMetrics)dm);
        TypedArray ta = context.obtainStyledAttributes(attrs, ATTRS);
        this.tabTextSize = ta.getDimensionPixelSize(0, this.tabTextSize);
        this.tabTextColor = ta.getColor(1, this.tabTextColor);
        ta.recycle();
        ta = context.obtainStyledAttributes(attrs, R.styleable.VpIndicator);
        this.indicatorColor = ta.getColor(R.styleable.VpIndicator_vpIndicatorColor, this.indicatorColor);
        this.underlineColor = ta.getColor(R.styleable.VpIndicator_vpUnderLineColor, this.underlineColor);
        this.indicatorHeight = ta.getDimensionPixelOffset(R.styleable.VpIndicator_vpIndicatorHeight, this.indicatorHeight);
        this.underlineHeight = ta.getDimensionPixelOffset(R.styleable.VpIndicator_vpUnderlineHeight, this.underlineHeight);
        this.tabPadding = ta.getDimensionPixelOffset(R.styleable.VpIndicator_vpTabPaddingLeftRight, this.tabPadding);
        this.tabBackgroundResId = ta.getResourceId(R.styleable.VpIndicator_vpTabBackground, this.tabBackgroundResId);
        this.tabTextSelectColor = ta.getColor(R.styleable.VpIndicator_vpTabTextSelectColor, this.tabTextSelectColor);
        ta.recycle();
        this.initPaintAndLayoutParams();
    }

    private void initPaintAndLayoutParams() {
        this.indicatorPaint = new Paint();
        this.indicatorPaint.setAntiAlias(true);
        this.indicatorPaint.setStyle(Paint.Style.FILL);
        this.expandLayoutParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
    }

    public void setViewPager(ViewPager vPager) {
        this.viewPager = vPager;
        this.viewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this.pagerListener);
        this.notifyDataSetChanged();
    }

    public void setDelegateListener(ViewPager.OnPageChangeListener listener) {
        this.delegateListener = listener;
    }

    public void notifyDataSetChanged() {
        this.tabLayout.removeAllViews();
        PagerAdapter pAdapter = this.viewPager.getAdapter();
        this.tabCount = pAdapter.getCount();
        for (int i = 0; i < this.tabCount; ++i) {
            this.addTextTab(i, pAdapter.getPageTitle(i));
        }
        this.updateTabStyle();
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    ViewPagerIndicator.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    ViewPagerIndicator.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                ViewPagerIndicator.this.currentPosition = ViewPagerIndicator.this.viewPager.getCurrentItem();
                ViewPagerIndicator.this.scrollToChild(ViewPagerIndicator.this.currentPosition, 0);
            }
        });
    }

    private void scrollToChild(int position, int offset) {
        if (this.tabCount == 0) {
            return;
        }
        int newScrollX = this.tabLayout.getChildAt(position).getLeft() + offset;
        if (position > 0 || offset > 0) {
            newScrollX -= this.scrollOffset;
        }
        if (newScrollX != this.lastScrollX) {
            this.lastScrollX = newScrollX;
            this.scrollTo(newScrollX, 0);
        }
    }

    private void addTextTab(int position, CharSequence title) {
        TextView tv = new TextView(this.getContext());
        tv.setGravity(17);
        tv.setText(title);
        tv.setSingleLine();
        this.addTab(position, (View)tv);
    }

    private void addTab(final int position, View tab) {
        tab.setFocusable(true);
        tab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewPagerIndicator.this.viewPager.setCurrentItem(position, false);
            }
        });
        tab.setPadding(this.tabPadding, 0, this.tabPadding, 0);
        this.tabLayout.addView(tab, position, (ViewGroup.LayoutParams)this.expandLayoutParams);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode() || this.tabCount == 0) {
            return;
        }
        int height = this.getHeight();
        this.indicatorPaint.setColor(this.indicatorColor);
        View currentTab = this.tabLayout.getChildAt(this.currentPosition);
        int lineLeft = currentTab.getLeft();
        int lineRight = currentTab.getRight();
        if (this.currentPositionOffset > 0.0f && this.currentPosition < this.tabCount - 1) {
            View nextTab = this.tabLayout.getChildAt(this.currentPosition + 1);
            int nextLeft = nextTab.getLeft();
            int nextRight = nextTab.getRight();
            lineLeft = (int)((float)lineLeft + (float)(nextLeft - lineLeft) * this.currentPositionOffset);
            lineRight = (int)((float)lineRight + (float)(nextRight - lineRight) * this.currentPositionOffset);
        }
        canvas.drawRect((float)lineLeft, (float)(height - this.indicatorHeight), (float)lineRight, (float)height, this.indicatorPaint);
        this.indicatorPaint.setColor(this.underlineColor);
        canvas.drawRect(0.0f, (float)(height - this.underlineHeight), (float)this.tabLayout.getWidth(), (float)height, this.indicatorPaint);
    }

    private void updateTabStyle() {
        for (int i = 0; i < this.tabCount; ++i) {
            View v = this.tabLayout.getChildAt(i);
            v.setBackgroundResource(this.tabBackgroundResId);
            if (!(v instanceof TextView)) continue;
            TextView tab = (TextView)v;
            tab.setTextSize(0, (float)this.tabTextSize);
            tab.setTextColor(this.tabTextColor);
            if (i != this.currentPosition) continue;
            tab.setTextColor(this.tabTextSelectColor);
        }
    }

    private final class PagerListener
    implements ViewPager.OnPageChangeListener {
        private PagerListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            ViewPagerIndicator.this.currentPosition = position;
            ViewPagerIndicator.this.currentPositionOffset = positionOffset;
            ViewPagerIndicator.this.scrollToChild(ViewPagerIndicator.this.currentPosition, (int)(positionOffset * (float)ViewPagerIndicator.this.tabLayout.getChildAt(position).getWidth()));
            ViewPagerIndicator.this.invalidate();
            if (ViewPagerIndicator.this.delegateListener != null) {
                ViewPagerIndicator.this.delegateListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageSelected(int position) {
            ViewPagerIndicator.this.currentPosition = position;
            ViewPagerIndicator.this.updateTabStyle();
            if (ViewPagerIndicator.this.delegateListener != null) {
                ViewPagerIndicator.this.delegateListener.onPageSelected(position);
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (state == 0) {
                ViewPagerIndicator.this.scrollToChild(ViewPagerIndicator.this.currentPosition, 0);
            }
            if (ViewPagerIndicator.this.delegateListener != null) {
                ViewPagerIndicator.this.delegateListener.onPageScrollStateChanged(state);
            }
        }
    }
}

