/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.adapter;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.ExpandableListView;
import android.widget.ProgressBar;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.adapter.BaseFileItemAdapterPresenter;
import com.xdja.im.lib.filemanage.commend.IHistoryFileListAdapterCommand;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.util.FileInfoCollection;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.filemanage.view.AdapterVu;
import com.xdja.im.lib.filemanage.view.ViewHistoryFileTitle;
import com.xdja.im.lib.filemanage.view.ViewLastFileContent;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LastFileListAdapterPresenter
extends BaseFileItemAdapterPresenter<IHistoryFileListAdapterCommand, TalkMessageBean>
implements IHistoryFileListAdapterCommand {
    private ExpandableListView listView;
    BusProvider busProvider;
    private Activity mActivity;
    private final UserCache userCache;
    private List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, String>>> mGroupVuClass = null;
    private List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, TalkMessageBean>>> mVuClass = null;
    private ItemLongClickListener mItemLongClickListener;

    public LastFileListAdapterPresenter(Context context, BusProvider busProvider, UserCache userCache, Map<HistoryFileCategory, List<TalkMessageBean>> datas) {
        this.mContext = context;
        this.busProvider = busProvider;
        this.userCache = userCache;
        this.busProvider.register(this);
        this.mDatas = datas;
    }

    public void setDataSource(Map<HistoryFileCategory, List<TalkMessageBean>> datas) {
        this.mDatas = datas;
    }

    @Override
    public void sendReadReceipt(TalkMessageBean talkMessageBean) {
    }

    @Override
    public List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, TalkMessageBean>>> getVuClasses() {
        if (this.mVuClass == null) {
            this.mVuClass = new ArrayList<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, TalkMessageBean>>>();
            this.mVuClass.add(ViewLastFileContent.class);
        }
        return this.mVuClass;
    }

    @Override
    public List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, String>>> getGroupVuClasses() {
        if (this.mGroupVuClass == null) {
            this.mGroupVuClass = new ArrayList<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, String>>>();
            this.mGroupVuClass.add(ViewHistoryFileTitle.class);
        }
        return this.mGroupVuClass;
    }

    @Override
    public IHistoryFileListAdapterCommand getCommand() {
        return this;
    }

    public void notifyDataSetChanged() {
        this.mTitles = new ArrayList(this.mDatas.keySet());
        Collections.sort(this.mTitles);
        super.notifyDataSetChanged();
    }

    @Override
    public void updateItem(int position, long msgId) {
        if (position < 0) {
            return;
        }
        HistoryFileCategory cate = (HistoryFileCategory)this.mTitles.get(position);
        List beans = (List)this.mDatas.get(cate);
        TalkMessageBean tBean = new TalkMessageBean();
        tBean.setId(msgId);
        int childPosition = beans.indexOf(tBean);
        if (childPosition > -1) {
            int childCount = this.listView.getChildCount();
            if (position == 0 && this.listView.isGroupExpanded(0)) {
                int firstVisiblePos = this.listView.getFirstVisiblePosition();
                if (childPosition + 1 < firstVisiblePos) {
                    return;
                }
                int aPos = childPosition - firstVisiblePos + 1;
                Log.d((String)"lvchao", (String)("zhu->childPos:" + childPosition + ",firstPos:" + firstVisiblePos + ",aPos:" + aPos));
                View childView = this.listView.getChildAt(aPos);
                if (childView != null) {
                    ProgressBar pb = (ProgressBar)childView.findViewById(R.id.pb_file_download);
                    pb.setProgress(((TalkMessageBean)beans.get(childPosition)).getFileInfo().getTranslatePercent());
                }
            }
        }
    }

    @Override
    public void toRefreshSelectHint() {
    }

    @Override
    public void toRefreshSelectHint(FileItem localFileInfo) {
        IMProxyEvent.FileSelectedEvent event = new IMProxyEvent.FileSelectedEvent(localFileInfo);
        this.busProvider.post(event);
    }

    @Override
    public void onClickItem(View v, int groupPosition, TalkMessageBean bean) {
        CheckBox checkBox = (CheckBox)v.getTag(R.id.history_file_select);
        if (checkBox == null) {
            return;
        }
        if (FileInfoCollection.getInstance().getSelectedFileCount() >= 9 && !checkBox.isChecked()) {
            new XToast(ImUiKit.getInstance().getContext()).display(String.format(ImUiKit.getInstance().getContext().getString(R.string.im_uikit_select_file_hint), 9));
            return;
        }
        checkBox.setChecked(!checkBox.isChecked());
    }

    @Override
    public void longClickOnItem(int groupPosition, TalkMessageBean bean) {
        if (this.mItemLongClickListener != null) {
            this.mItemLongClickListener.itemLongClick(groupPosition, bean);
        }
    }

    @Override
    public AccountBean getAccountBean(String account) {
        return IMUiKitProxyImpl.getInstance().getAccount(account, 1);
    }

    @Override
    public AccountBean getGroupMemberInfo(String groupId, String account) {
        return IMUiKitProxyImpl.getInstance().getAccount(account, 2);
    }

    public void setListView(ExpandableListView listView) {
        this.listView = listView;
    }

    public void setActivity(Activity activity) {
        this.mActivity = activity;
    }

    @Override
    public Activity getActivity() {
        return this.mActivity;
    }

    public void setItemLongClickListener(ItemLongClickListener listener) {
        this.mItemLongClickListener = listener;
    }

    public void onDestroy() {
        if (null != this.busProvider) {
            this.busProvider.unregister(this);
        }
    }

    @Override
    public void clickToDownloadOfOpen(TalkMessageBean bean) {
    }

    public static interface ItemLongClickListener {
        public void itemLongClick(int var1, TalkMessageBean var2);
    }
}

