/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.presenter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import com.xdja.im.lib.filemanage.annotation.ActivityStack;
import com.xdja.im.lib.filemanage.annotation.StackInto;
import com.xdja.im.lib.filemanage.commend.Command;
import com.xdja.im.lib.filemanage.view.ActivityVu;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.dialog.CustomDialog;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.NetworkUtil;
import java.util.ArrayList;

public abstract class BasePresenterActivity<P extends Command, V extends ActivityVu>
extends AppCompatActivity {
    private static final String TAG = "BasePresenterActivity";
    public static final int REQ_WIRTE_READ_CODE = 1;
    public static final int POST_GlOBAL_NOTIFI_ID = 17;
    public static final String HAI_XIN = "Hisense";
    public static String ACTION_ACTOMA_SET_LANGUAGE = "languageToFinish";
    protected boolean mIsOnkeyDown = false;
    private V vu;
    public static final int THEME_DARK = 0;
    public static final int THEME_LIGHT = 1;
    private SharedPreferences mSharedPreferences;
    public static final String SCREEN_SHORTS = "screenshots";
    BroadcastReceiver configChangeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            LogUtil.d(BasePresenterActivity.TAG, "BasePresenterActivity onReceive configChangeReceiver");
            BasePresenterActivity.this.finish();
        }
    };
    private BroadcastReceiver chipReceiver = new BroadcastReceiver(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.PACKAGE_ADDED") || action.equals("android.intent.action.PACKAGE_REMOVED")) {
                String packageName = intent.getData().getSchemeSpecificPart();
                if (!packageName.equals("com.xdja.safekeyservice") && !packageName.equals("com.xdja.safekeyservice.zjtel")) return;
            }
            if (!intent.getAction().equals("android.intent.action.MEDIA_EJECT")) return;
        }
    };
    public static final String ACTION_APPLICATION_EXIT = "com.xdja.application.exit";
    public static final String EXIT_TF_OUT_KEY = "exitForSafeTFOut";

    public V getVu() {
        return this.vu;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mSharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this);
        try {
            StackInto annotation = ((Object)((Object)this)).getClass().getAnnotation(StackInto.class);
            if (annotation == null || annotation.value()) {
                ActivityStack.getInstanse().pushActivity((Activity)this);
            }
            this.preBindView(savedInstanceState);
            IntentFilter filter = new IntentFilter();
            filter.addAction(ACTION_ACTOMA_SET_LANGUAGE);
            filter.addAction("android.intent.action.LOCALE_CHANGED");
            this.registerReceiver(this.configChangeReceiver, filter);
            if (this.getVuClass() != null) {
                this.vu = (ActivityVu)this.getVuClass().newInstance();
                this.vu.setCommand(this.getCommand());
                this.vu.setActivity((BasePresenterActivity)this);
                this.vu.init(this.getLayoutInflater(), null);
                this.setContentView(this.vu.getView());
                this.vu.onCreated();
            }
            this.onBindView(savedInstanceState);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected int getPrimaryColor() {
        return this.getResources().getColor(R.color.im_uikit_blade_toolbar_light_bg);
    }

    protected boolean isLightStatusBar() {
        return true;
    }

    protected void onDestroy() {
        this.unregisterReceiver(this.configChangeReceiver);
        ActivityStack.getInstanse().popActivity((Activity)this, false);
        if (this.vu != null) {
            this.vu.onDestroy();
        }
        super.onDestroy();
    }

    protected void onPause() {
        super.onPause();
        if (this.vu != null) {
            this.vu.onPause();
        }
    }

    protected boolean isMoveTaskToBack() {
        return false;
    }

    @RequiresApi(api=17)
    public boolean onKeyShortcut(int keyCode, KeyEvent event) {
        if (!(this.mIsOnkeyDown || keyCode != 4 || this.isDestroyed() || this.isFinishing())) {
            if (this.isMoveTaskToBack()) {
                this.moveTaskToBack(true);
            } else {
                this.finish();
            }
        }
        return super.onKeyShortcut(keyCode, event);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        LogUtil.v(TAG, "BasePresenterActivity -> onKeyDown keyCode : " + keyCode);
        if (keyCode == 4) {
            this.mIsOnkeyDown = true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected boolean isNeedCheckPermission() {
        return true;
    }

    public static boolean isMNC() {
        return Build.VERSION.SDK_INT >= 23;
    }

    protected void onResume() {
        ArrayList<String> permission2;
        super.onResume();
        this.mIsOnkeyDown = false;
        ((NotificationManager)this.getSystemService("notification")).cancel(17);
        if (this.vu != null) {
            this.vu.onResume();
        }
        if (BasePresenterActivity.isMNC() && this.isNeedCheckPermission() && (permission2 = this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE")) != null && permission2.size() > 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])permission2.toArray(new String[0]), (int)1);
            return;
        }
    }

    public ArrayList<String> checkSelfPermission(String ... permiss) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (int i = 0; i < permiss.length; ++i) {
            if (TextUtils.isEmpty((CharSequence)permiss[i]) || ContextCompat.checkSelfPermission((Context)this, (String)permiss[i]) == 0) continue;
            permissionList.add(permiss[i]);
        }
        return permissionList;
    }

    @SuppressLint(value={"NewApi"})
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (BasePresenterActivity.isMNC() && requestCode == 1 && (grantResults == null || grantResults.length == 0 || grantResults[0] != 0)) {
            ActivityStack.getInstanse().exitApp();
        }
    }

    public void onBackPressed() {
        LogUtil.v(TAG, "BasePresenterActivity -> onBackPressed");
        try {
            super.onBackPressed();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onStart() {
        super.onStart();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        intentFilter.addAction("android.intent.action.MEDIA_EJECT");
        intentFilter.addAction("android.intent.action.MEDIA_MOUNTED");
        intentFilter.addDataScheme("file");
        this.registerReceiver(this.chipReceiver, intentFilter);
        if (this.vu != null) {
            this.vu.onStart();
        }
    }

    protected void onRestart() {
        super.onRestart();
        if (this.vu != null) {
            this.vu.onRestart();
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.vu != null) {
            this.vu.onStop();
        }
        this.unregisterReceiver(this.chipReceiver);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.vu != null) {
            this.vu.onAttachedToWindow();
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.vu != null) {
            this.vu.onDetachedFromWindow();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        if (this.vu != null) {
            this.vu.onCreateOptionsMenu(menu);
        }
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (this.vu != null) {
            this.vu.onOptionsItemSelected(item);
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        if (this.vu != null) {
            this.vu.onPrepareOptionsMenu(menu);
        }
        return super.onPrepareOptionsMenu(menu);
    }

    @NonNull
    protected abstract Class<? extends V> getVuClass();

    @NonNull
    protected abstract P getCommand();

    protected void preBindView(Bundle savedInstanceState) {
    }

    protected void onBindView(Bundle savedInstanceState) {
    }

    public Resources getResources() {
        Resources res = super.getResources();
        Configuration config = res.getConfiguration();
        config.fontScale = 1.0f;
        res.updateConfiguration(config, res.getDisplayMetrics());
        return res;
    }

    public void detectSafeKey(boolean needCheckPin, boolean safeKeyInstall) {
        DetectSafeKeyTask detectSafeKeyTask = new DetectSafeKeyTask(needCheckPin, safeKeyInstall);
        detectSafeKeyTask.execute(new Void[0]);
    }

    protected void checkNetType(final OnNetCheckCallback result) {
        boolean isMobileConnected = NetworkUtil.isConnectByMobile(this.getApplicationContext());
        if (isMobileConnected) {
            new CustomDialog((Context)this, new CustomDialog.OnCloseListener(){

                @Override
                public void onClick(Dialog dialog, boolean confirm) {
                    result.onResult(!confirm);
                }
            }).setDialogTitle(result.getTitle()).setDialogContent(result.getContent()).setPositiveButton(result.getPositiveButton()).setNegativeButton(result.getNegativeButton()).show();
        } else {
            result.onResult(false);
        }
    }

    public abstract class OnNetCheckCallback {
        public abstract void onResult(boolean var1);

        protected String getContent() {
            return "";
        }

        protected String getTitle() {
            return BasePresenterActivity.this.getString(R.string.im_uikit_hint);
        }

        protected String getPositiveButton() {
            return BasePresenterActivity.this.getString(R.string.im_uikit_btn_continue);
        }

        protected String getNegativeButton() {
            return BasePresenterActivity.this.getString(R.string.im_uikit_btn_cancel);
        }
    }

    private class DetectSafeKeyTask
    extends AsyncTask<Void, Void, Boolean> {
        private boolean safekeyInstall;
        private boolean needCheckPin;

        DetectSafeKeyTask(boolean checkPin, boolean install) {
            this.needCheckPin = checkPin;
            this.safekeyInstall = install;
        }

        protected Boolean doInBackground(Void ... voids) {
            return true;
        }

        protected void onPostExecute(Boolean aBoolean) {
            super.onPostExecute((Object)aBoolean);
            if (!this.needCheckPin || this.safekeyInstall) {
                // empty if block
            }
        }
    }
}

