/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.view.View;
import com.bumptech.glide.Glide;
import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.adapter.LocalFileListAdapter;
import com.xdja.im.lib.filemanage.commend.IFileExplorerCommand;
import com.xdja.im.lib.filemanage.commend.IFileExplorerVu;
import com.xdja.im.lib.filemanage.fragment.LastFilePagePresenter;
import com.xdja.im.lib.filemanage.fragment.LocalFileListPresenter;
import com.xdja.im.lib.filemanage.presenter.BasePresenterActivity;
import com.xdja.im.lib.filemanage.presenter.IMActivityPresenter;
import com.xdja.im.lib.filemanage.util.FileInfoCollection;
import com.xdja.im.lib.filemanage.util.NetworkUtils;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.filemanage.view.ViewFileExplorer;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class FileExplorerPresenter
extends IMActivityPresenter<IFileExplorerCommand, IFileExplorerVu>
implements IFileExplorerCommand {
    private static final long MAX_FILE_SIZE = 0x1E00000L;
    BusProvider busProvider;
    private LocalFileListAdapter mAdapter;

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (null == this.userComponent) {
            LogUtil.e("FileExplorerPresenter", "useCaseComponent is null");
            return;
        }
        this.userComponent.inject(this);
        this.busProvider = BusProvider.getInstance();
        this.busProvider.register(this);
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        fragments.add(new LastFilePagePresenter());
        fragments.add(new LocalFileListPresenter());
        this.mAdapter = this.buildAdapter(fragments);
        ((IFileExplorerVu)this.getVu()).setFragmentAdapter(this.mAdapter);
        ((IFileExplorerVu)this.getVu()).setCurrentSelectedFileSize(0L);
    }

    @Override
    @NonNull
    protected Class<? extends IFileExplorerVu> getVuClass() {
        return ViewFileExplorer.class;
    }

    @Override
    @NonNull
    protected IFileExplorerCommand getCommand() {
        return this;
    }

    private LocalFileListAdapter buildAdapter(final List<Fragment> fragments) {
        return new LocalFileListAdapter(this.getSupportFragmentManager()){

            public int getCount() {
                return fragments.size();
            }

            @Override
            public Fragment getItem(int position) {
                return (Fragment)fragments.get(position);
            }
        };
    }

    @Override
    public void onLastFileTabClick(View view) {
        ((IFileExplorerVu)this.getVu()).setViewPagerCurrentItem(0);
    }

    @Override
    public void onLocalFileTabClick(View view) {
        ((IFileExplorerVu)this.getVu()).setViewPagerCurrentItem(1);
    }

    @Override
    public void onSendBtnClick(View view) {
        if (NetworkUtils.obtainCurrentNetworkState((Context)this) == NetworkUtils.MOBILE_NETWORK) {
            this.checkNetStatue();
        } else {
            this.sendSelectedFiles();
        }
    }

    private void checkNetStatue() {
        this.checkNetType(new BasePresenterActivity.OnNetCheckCallback(){

            @Override
            public void onResult(boolean isCanceled) {
                if (isCanceled) {
                    LogUtil.d("Has canceled send files.");
                    return;
                }
                FileExplorerPresenter.this.sendSelectedFiles();
            }

            @Override
            protected String getContent() {
                return String.format(FileExplorerPresenter.this.getString(R.string.im_uikit_mobile_data_hint_contnet), FileExplorerPresenter.this.getString(R.string.im_uikit_send));
            }
        });
    }

    private void sendSelectedFiles() {
        ((IFileExplorerVu)this.getVu()).setProgressBarVisibility(0);
        Observable.from(FileInfoCollection.getInstance().getAllSelectFiles()).flatMap((Func1)new Func1<FileItem, Observable<FileItem>>(){

            public Observable<FileItem> call(FileItem localFileInfo) {
                long fileSize = localFileInfo.getFileSize();
                if (fileSize > 0x1E00000L || fileSize < 0L) {
                    return Observable.error((Throwable)new IllegalArgumentException("file is too larger!"));
                }
                return Observable.just((Object)localFileInfo);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<FileItem>(){

            public void onCompleted() {
                ((IFileExplorerVu)FileExplorerPresenter.this.getVu()).setProgressBarVisibility(8);
            }

            public void onError(Throwable e) {
                ((IFileExplorerVu)FileExplorerPresenter.this.getVu()).setProgressBarVisibility(8);
                new XToast((Context)FileExplorerPresenter.this).display(R.string.im_uikit_file_is_too_larger);
            }

            public void onNext(FileItem localFileInfo) {
                ((IFileExplorerVu)FileExplorerPresenter.this.getVu()).setProgressBarVisibility(8);
                FileExplorerPresenter.this.setResult();
            }
        });
    }

    private void setResult() {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        ArrayList<FileItem> bundleList = new ArrayList<FileItem>();
        bundleList.addAll(FileInfoCollection.getInstance().getAllSelectFiles());
        bundle.putParcelableArrayList("file_select", bundleList);
        intent.putExtras(bundle);
        this.setResult(6, intent);
        this.finish();
    }

    @Subscribe
    public void onRefreashFileSelectStatus(IMProxyEvent.FileSelectedEvent event) {
        ((IFileExplorerVu)this.getVu()).setCurrentSelectedFileSize(FileInfoCollection.getInstance().getSelectedFileSize());
        ((IFileExplorerVu)this.getVu()).setCurrentSelectedFileCount(FileInfoCollection.getInstance().getSelectedFileCount());
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.busProvider != null) {
            this.busProvider.unregister(this);
        }
        Glide.get((Context)this).clearMemory();
        FileInfoCollection.getInstance().clearCache();
    }
}

