/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xdja.im.lib.filemanage.annotation.ContextSpe;
import javax.inject.Inject;

@SuppressLint(value={"CommitPrefEdits"})
public class PreferencesUtil {
    private SharedPreferences sp;
    private SharedPreferences.Editor sharedEditor;

    @Inject
    public PreferencesUtil(@ContextSpe(value="application") @NonNull Context aContext) {
        this.sp = PreferenceManager.getDefaultSharedPreferences((Context)aContext);
        this.sharedEditor = this.sp.edit();
    }

    public PreferencesUtil(Context context, String prefName) {
        this.sp = context.getSharedPreferences(prefName, 0);
        this.sharedEditor = this.sp.edit();
    }

    public boolean setPreferenceStringValue(String key, String value) {
        if (this.sharedEditor == null) {
            SharedPreferences.Editor editor = this.sp.edit();
            editor.putString(key, value);
            return editor.commit();
        }
        this.sharedEditor.putString(key, value);
        return this.sharedEditor.commit();
    }

    public boolean setPreferenceBooleanValue(String key, boolean value) {
        if (this.sharedEditor == null) {
            SharedPreferences.Editor editor = this.sp.edit();
            editor.putBoolean(key, value);
            return editor.commit();
        }
        this.sharedEditor.putBoolean(key, value);
        return this.sharedEditor.commit();
    }

    public boolean setPreferenceFloatValue(String key, float value) {
        if (this.sharedEditor == null) {
            SharedPreferences.Editor editor = this.sp.edit();
            editor.putFloat(key, value);
            return editor.commit();
        }
        this.sharedEditor.putFloat(key, value);
        return this.sharedEditor.commit();
    }

    public boolean setPreferenceIntValue(String key, int value) {
        if (this.sharedEditor == null) {
            SharedPreferences.Editor editor = this.sp.edit();
            editor.putInt(key, value);
            return editor.commit();
        }
        this.sharedEditor.putInt(key, value);
        return this.sharedEditor.commit();
    }

    public boolean setPreferenceLongValue(String key, long value) {
        if (this.sharedEditor == null) {
            SharedPreferences.Editor editor = this.sp.edit();
            editor.putLong(key, value);
            return editor.commit();
        }
        this.sharedEditor.putLong(key, value);
        return this.sharedEditor.commit();
    }

    @Nullable
    public String gPrefStringValue(String key) {
        return this.sp.getString(key, "");
    }

    public Boolean gPrefBooleanValue(String key, boolean defaultValue) {
        return this.sp.getBoolean(key, defaultValue);
    }

    public int gPrefIntValue(String key) {
        return this.sp.getInt(key, 0);
    }

    public long gPrefLongValue(String key) {
        return this.sp.getLong(key, 0L);
    }

    public float gPrefFloatValue(String key) {
        return this.sp.getFloat(key, 0.0f);
    }

    public boolean containsKey(String key) {
        return this.sp.contains(key);
    }

    public void removeKey(String key) {
        if (this.sharedEditor == null) {
            this.sharedEditor = this.sp.edit();
        }
        this.sharedEditor.remove(key);
        this.sharedEditor.apply();
    }

    public void clear() {
        if (this.sharedEditor == null) {
            this.sharedEditor = this.sp.edit();
        }
        this.sharedEditor.clear();
        this.sharedEditor.apply();
    }
}

