/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.widget.AbsListView;
import android.widget.ExpandableListView;
import com.xdja.im.lib.filemanage.widget.LazyLoadGridView;
import java.util.ArrayList;
import java.util.List;

public class LazyLoadExpandableListView
extends ExpandableListView
implements AbsListView.OnScrollListener {
    private SparseBooleanArray itemsNow;
    private LazyLoadGridView.OnLazyLoadListener onLazyLoadListener;
    private AbsListView.OnScrollListener onScrollListener;
    private int oldVisibleItemCount = 0;

    public LazyLoadExpandableListView(Context context) {
        super(context);
        this.init();
    }

    public LazyLoadExpandableListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LazyLoadExpandableListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.itemsNow = new SparseBooleanArray();
    }

    public void setOnScrollListener(AbsListView.OnScrollListener onScrollListener) {
        this.onScrollListener = onScrollListener;
    }

    public void setOnLazyLoadListener(LazyLoadGridView.OnLazyLoadListener onLazyLoadListener) {
        this.onLazyLoadListener = onLazyLoadListener;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        this.updateShowLoadPosition();
        if (scrollState == 0) {
            this.calculateWhichShouldLoad(this.getFirstVisiblePosition(), this.getLastVisiblePosition());
        }
        if (this.onScrollListener != null) {
            this.onScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (visibleItemCount != this.oldVisibleItemCount && this.oldVisibleItemCount != -1) {
            this.updateShowLoadPosition();
            this.calculateWhichShouldLoad(firstVisibleItem, firstVisibleItem + visibleItemCount - 1);
            this.oldVisibleItemCount = -1;
        }
        if (this.oldVisibleItemCount == -1) {
            this.oldVisibleItemCount = visibleItemCount;
        }
        if (this.onScrollListener != null) {
            this.onScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    private void calculateWhichShouldLoad(int firstPosition, int lastPosition) {
        ArrayList<Integer> itemsPos = new ArrayList<Integer>();
        for (int i = firstPosition; i < lastPosition; ++i) {
            if (this.itemsNow.get(i, false)) continue;
            itemsPos.add(i);
            this.itemsNow.put(i, true);
        }
        if (this.onLazyLoadListener != null) {
            this.onLazyLoadListener.shouldLoad(itemsPos);
        }
    }

    private void updateShowLoadPosition() {
        int firstVisibleItem = this.getFirstVisiblePosition();
        int lastVisibleItem = this.getLastVisiblePosition();
        for (int i = 0; i < firstVisibleItem; ++i) {
            this.itemsNow.put(i, false);
        }
        int itemCount = this.getCount();
        for (int i = lastVisibleItem; i < itemCount; ++i) {
            this.itemsNow.put(i, false);
        }
    }

    public static interface OnLazyLoadListener {
        public void shouldLoad(List<Integer> var1);
    }
}

