/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.video.widget;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.TimePicker;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.Date;

public class CustomTimePicker
extends AlertDialog {
    private static final String TAG = CustomTimePicker.class.getSimpleName();
    private final View view;
    private final TimePicker timePicker;
    private final TextView positiveButton;
    private AlertDialog dialog;
    private final AlertDialog.Builder builder;
    private final TimerPickerCallBack callBack;
    private int t_hourOfDay;
    private int t_minute;

    @SuppressLint(value={"InflateParams"})
    public CustomTimePicker(Context context, final TimerPickerCallBack callBack) {
        super(context);
        this.callBack = callBack;
        this.builder = new AlertDialog.Builder(context);
        this.view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.im_uikit_view_timepicker, null);
        this.timePicker = (TimePicker)this.view.findViewById(R.id.timepicker);
        this.positiveButton = (TextView)this.view.findViewById(R.id.dialog_ok);
        this.positiveButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomTimePicker.this.dismiss();
                if (callBack != null) {
                    callBack.onTimeSelected(CustomTimePicker.this.t_hourOfDay, CustomTimePicker.this.t_minute);
                }
            }
        });
    }

    public AlertDialog createView(int currentHour, int currentMin) {
        if (this.dialog == null) {
            this.builder.setView(this.view);
            this.builder.setCancelable(true);
            this.dialog = this.builder.create();
        }
        if (currentHour < 0 || currentMin < 0) {
            Date dNow = new Date(System.currentTimeMillis());
            this.t_hourOfDay = dNow.getHours();
            this.t_minute = dNow.getMinutes();
        } else {
            this.t_hourOfDay = currentHour;
            this.t_minute = currentMin;
            LogUtil.i("\u4f20\u5165\u7684\u65f6\u95f4 \uff1a " + currentHour + "=======" + currentMin);
            this.timePicker.setCurrentHour(Integer.valueOf(this.t_hourOfDay));
            this.timePicker.setCurrentMinute(Integer.valueOf(this.t_minute));
            LogUtil.i("\u8bbe\u7f6e\u7684\u65f6\u95f4 \uff1a " + this.t_hourOfDay + "=======" + this.t_minute);
        }
        Log.i((String)TAG, (String)("\u521d\u59cb\u5316\u65f6\u95f4------HourOfDay : " + this.t_hourOfDay));
        Log.i((String)TAG, (String)("\u521d\u59cb\u5316\u65f6\u95f4------Minute : " + this.t_minute));
        this.timePicker.setOnTimeChangedListener(new TimePicker.OnTimeChangedListener(){

            public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
                Log.i((String)TAG, (String)("hourOfDay : " + hourOfDay));
                Log.i((String)TAG, (String)("minute:" + minute));
                CustomTimePicker.this.t_hourOfDay = hourOfDay;
                CustomTimePicker.this.t_minute = minute;
            }
        });
        return this.dialog;
    }

    public void show() {
        if (this.dialog != null) {
            this.dialog.show();
        }
    }

    public void dismiss() {
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
    }

    public static interface TimerPickerCallBack {
        public void onTimeSelected(int var1, int var2);
    }
}

