/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.video.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import com.xdja.im.lib.video.utils.DisplayUtils;
import com.xdja.im.lib.video.widget.CircularProgressDrawable;
import com.xdja.im.uikit.R;

public class CustomView
extends View {
    private static final int BG_STROKE_WIDTH = 51;
    private static final int CIR_STROKE_WIDTH = 12;
    private final CircularProgressDrawable mDrawable;
    private final Paint mBgPaint;

    public CustomView(Context context) {
        this(context, null);
    }

    public CustomView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CustomView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mDrawable = new CircularProgressDrawable(this.getResources().getColor(R.color.im_uikit_circular_up_color), DisplayUtils.dp2px(context, 12.0f));
        this.mDrawable.setCallback((Drawable.Callback)this);
        this.mBgPaint = new Paint();
        this.mBgPaint.setAntiAlias(true);
        this.mBgPaint.setStrokeWidth(51.0f);
        this.mBgPaint.setStyle(Paint.Style.FILL);
        this.mBgPaint.setColor(this.getResources().getColor(R.color.im_uikit_circular_down_color));
    }

    public void startProgressBar() {
        this.mDrawable.start();
    }

    public void stopProgressBar() {
        this.mDrawable.stop();
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.mDrawable.setBounds(0, 0, w, h);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        if (width != height) {
            width = Math.min(width, height);
        }
        canvas.drawCircle((float)(width / 2), (float)(width / 2), (float)(width / 2) - 1.5f, this.mBgPaint);
        this.mDrawable.draw(canvas);
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return who == this.mDrawable || super.verifyDrawable(who);
    }

    public void startAnim() {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleX", (float[])new float[]{1.0f, 1.6f}), ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleY", (float[])new float[]{1.0f, 1.6f})});
        set.setDuration(250L).start();
    }

    public void stopAnim() {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleX", (float[])new float[]{1.6f, 1.0f}), ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleY", (float[])new float[]{1.6f, 1.0f})});
        set.setDuration(250L).start();
    }
}

