/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.action.media;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.PowerManager;
import com.xdja.im.uikit.ImUiKit;

public class MediaManger {
    public static final int MODE_SPEAKER = 0;
    public static final int MODE_HEADSET = 1;
    public static final int MODE_EARPIECE = 2;
    private Context context = ImUiKit.getInstance().getContext();
    private AudioManager mAudioManager = (AudioManager)this.context.getSystemService("audio");
    private PowerManager pManager;
    private boolean isWakeAcquire = false;
    private int mCurrentMode = 0;
    private PowerManager.WakeLock mWakeLock;

    public static MediaManger getInstance() {
        return SingletonInstance.mInstance;
    }

    private MediaManger() {
    }

    public void initAudioManager() {
        this.pManager = (PowerManager)this.context.getSystemService("power");
        this.mWakeLock = this.pManager.newWakeLock(32, "");
    }

    public void resetAudioManager() {
        this.mAudioManager.setSpeakerphoneOn(true);
    }

    public int getCurrentMode() {
        return this.mCurrentMode;
    }

    public void changeToEarpieceMode() {
        this.mCurrentMode = 2;
        this.mAudioManager.setMode(3);
        this.mAudioManager.setSpeakerphoneOn(false);
    }

    public void changeToHeadsetMode() {
        this.mCurrentMode = 1;
        this.mAudioManager.setSpeakerphoneOn(false);
    }

    public void changeToSpeakerMode() {
        this.mCurrentMode = 0;
        this.mAudioManager.setSpeakerphoneOn(true);
    }

    public void wakeLockBrightAcquire() {
        if (this.mWakeLock != null && !this.mWakeLock.isHeld()) {
            this.isWakeAcquire = true;
            this.mWakeLock.setReferenceCounted(false);
            this.mWakeLock.acquire();
        }
    }

    public boolean isWakeAcquire() {
        return !this.pManager.isScreenOn();
    }

    public void wakeLockBrightRelease() {
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            this.isWakeAcquire = false;
            this.mWakeLock.release();
        }
    }

    public void raiseVolume() {
        int currentVolume = this.mAudioManager.getStreamVolume(3);
        if (currentVolume < this.mAudioManager.getStreamMaxVolume(3)) {
            this.mAudioManager.adjustStreamVolume(3, 1, 1);
        }
    }

    public void lowerVolume() {
        int currentVolume = this.mAudioManager.getStreamVolume(3);
        if (currentVolume > 0) {
            this.mAudioManager.adjustStreamVolume(3, -1, 1);
        }
    }

    public void raiseVolume(Context context) {
        this.setVolume(context, true);
    }

    public void lowerVolume(Context context) {
        this.setVolume(context, false);
    }

    private void setVolume(Context context, boolean upVolume) {
        int volume = this.mAudioManager.getStreamVolume(3);
        volume = upVolume ? ++volume : --volume;
        int maxVolume = this.mAudioManager.getStreamMaxVolume(3);
        if (volume >= 0 && volume <= maxVolume) {
            this.mAudioManager.setStreamVolume(3, volume, 1);
        }
    }

    public void restoreAudioMode() {
        this.mAudioManager.setMode(0);
    }

    public void setAudioMode() {
        if (Build.VERSION.SDK_INT >= 11) {
            this.mAudioManager.setMode(3);
        } else {
            this.mAudioManager.setMode(2);
        }
    }

    public void releaseSpeakerphone() {
        this.mAudioManager.setSpeakerphoneOn(false);
    }

    private static class SingletonInstance {
        private static final MediaManger mInstance = new MediaManger();

        private SingletonInstance() {
        }
    }
}

