/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.notification;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.PowerManager;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.List;

public class NotifyUtils {
    public static boolean isAppOnForeground(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List appInfos = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo info : appInfos) {
            if (!info.processName.equals(context.getPackageName()) || info.importance != 100) continue;
            return true;
        }
        return false;
    }

    public static String getCurrentActivityName(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ActivityManager.RunningTaskInfo info = (ActivityManager.RunningTaskInfo)am.getRunningTasks(1).get(0);
        return info.topActivity.getClassName();
    }

    public static boolean isScreenOffOrLock(Context context) {
        KeyguardManager mKeyguardManager;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        boolean isOn = false;
        boolean isLock = true;
        if (pm != null) {
            isOn = pm.isScreenOn();
        }
        if ((mKeyguardManager = (KeyguardManager)context.getSystemService("keyguard")) != null) {
            try {
                isLock = mKeyguardManager.inKeyguardRestrictedInputMode();
            }
            catch (Throwable e) {
                LogUtil.e(e.getMessage());
            }
        }
        return !isOn || isLock;
    }
}

