/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.bumptech.glide.Glide;
import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.account.AccountDesc;
import com.xdja.im.core.model.event.IMContactEvent;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.event.IMProxyFileEvent;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.event.IMProxySessionEvent;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.core.repository.interf.ChatListCallBack;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.audio.player.AudioListener;
import com.xdja.im.lib.audio.player.AudioListenerManager;
import com.xdja.im.lib.camera.CameraManager;
import com.xdja.im.lib.file.FileExplorerManager;
import com.xdja.im.lib.video.VideoRecorderManager;
import com.xdja.im.uikit.IntentParam;
import com.xdja.im.uikit.action.media.MediaManger;
import com.xdja.im.uikit.action.media.ReceiverModeManger;
import com.xdja.im.uikit.base.ImBaseFragment;
import com.xdja.im.uikit.notification.NotificationUtil;
import com.xdja.im.uikit.ui.adapter.ChatListAdapter;
import com.xdja.im.uikit.ui.presenter.ChatListPresenter;
import com.xdja.im.uikit.ui.view.ViewChatList;
import com.xdja.im.uikit.ui.view.vu.ChatListVu;
import com.xdja.im.uikit.utils.ImageCache;
import com.xdja.im.uikit.utils.audio.AudioPlayerManagerProxy;
import com.xdja.im.uikit.utils.file.TranslateInfoUtil;
import com.xdja.im.uikit.utils.log.LogUtil;
import dagger.Lazy;
import java.util.List;
import javax.inject.Inject;
import rx.Subscriber;

public class ChatListFragment
extends ImBaseFragment<ChatListPresenter, ChatListVu>
implements ChatListPresenter,
AudioListener {
    @Inject
    Lazy<ChatListCallBack> chatListCallBack;

    @Override
    protected Class<? extends ChatListVu> getVuClass() {
        return ViewChatList.class;
    }

    @Override
    @NonNull
    protected ChatListPresenter getPresenter() {
        return this;
    }

    @Override
    public String getTalkFlag() {
        return ((ChatListCallBack)this.chatListCallBack.get()).getTalkId() + "_" + ((ChatListCallBack)this.chatListCallBack.get()).getTalkType();
    }

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (this.mComponent == null) {
            this.finish();
            return;
        }
        this.mComponent.inject(this);
        try {
            Bundle arguments = this.getArguments();
            ((ChatListCallBack)this.chatListCallBack.get()).initChatPram(arguments, (ChatListVu)this.getVu(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)((ChatListCallBack)this.chatListCallBack.get()).getTalkId())) {
            this.finish();
            return;
        }
        BusProvider.getInstance().register(this);
        NotificationUtil.getInstance().setCurTalkAccount(((ChatListCallBack)this.chatListCallBack.get()).getTalkId());
        AudioListenerManager.getInstance().addListener(this);
        new ReceiverModeManger().init((Activity)this.getActivity());
        this.initView();
    }

    public void onStart() {
        super.onStart();
        ((ChatListCallBack)this.chatListCallBack.get()).requestPermissions((Activity)this.getActivity());
    }

    private void initView() {
        ((ChatListCallBack)this.chatListCallBack.get()).clearAdapter();
        ((ChatListCallBack)this.chatListCallBack.get()).loadMessageList(0L);
        ((ChatListCallBack)this.chatListCallBack.get()).clearUnReadMsgCount();
        ((ChatListCallBack)this.chatListCallBack.get()).getDraftContent();
        ((ChatListCallBack)this.chatListCallBack.get()).startLoadOptions((Context)this.getActivity());
        this.initToolBar();
    }

    private void initToolBar() {
        ((ChatListVu)this.getVu()).setTalkType(((ChatListCallBack)this.chatListCallBack.get()).getTalkType());
        ((ChatListVu)this.getVu()).setChatMeet(this.getTalkFlag());
        ((ChatListVu)this.getVu()).setToolBarVisibility(8);
    }

    private ChatListAdapter buildAdapter() {
        return ((ChatListCallBack)this.chatListCallBack.get()).buildAdapter();
    }

    private void loadMessageList(long msgId) {
        ((ChatListCallBack)this.chatListCallBack.get()).loadMessageList(msgId);
    }

    @Override
    public void downRefreshList() {
        ((ChatListCallBack)this.chatListCallBack.get()).downRefreshList();
    }

    private void notifyUpdateLastSession() {
        ((ChatListCallBack)this.chatListCallBack.get()).notifyUpdateLastSession();
    }

    private void clearUnReadMsgCount() {
        ((ChatListCallBack)this.chatListCallBack.get()).clearUnReadMsgCount();
    }

    @Override
    public int getMessageSize() {
        return ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().size();
    }

    @Override
    public boolean sendTextMessage(String message) {
        ((ChatListCallBack)this.chatListCallBack.get()).sendTextMessage(message);
        return true;
    }

    @Override
    public void sendFileMessage(List<FileInfo> fileList) {
        ((ChatListCallBack)this.chatListCallBack.get()).sendFileMessage(fileList);
    }

    @Override
    public void sendVoiceMessage(String path, int seconds) {
        ((ChatListCallBack)this.chatListCallBack.get()).sendVoiceMessage(path, seconds);
    }

    @Override
    public void startToOptionView(int position, OptionBean optionBean) {
        LogUtil.d("startToOptionView:" + optionBean.toString());
        Intent intent = ((ChatListCallBack)this.chatListCallBack.get()).buildIntent((Context)this.getActivity(), optionBean);
        try {
            if (optionBean.getRequestCode() > 0) {
                this.startActivityForResult(intent, optionBean.getRequestCode());
            } else {
                this.startActivity(intent);
            }
            ((ChatListVu)this.getVu()).restoreActionState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startToAlbum() {
        ((ChatListVu)this.getVu()).restoreActionState();
        ImagePickerManager.getInstance().openAlbum(this, 2);
    }

    @Override
    public void startToCamera() {
        ((ChatListVu)this.getVu()).restoreActionState();
        CameraManager.getInstance().startTakePhoto(this, 3);
    }

    @Override
    public void startToFileExplorer() {
        ((ChatListVu)this.getVu()).restoreActionState();
        FileExplorerManager.getInstance().openFileExplorer(this, 6);
    }

    @Override
    public void startToVideo() {
        ((ChatListVu)this.getVu()).restoreActionState();
        VideoRecorderManager.getInstance().startVideoRecorder(this, 5);
    }

    @Override
    public void startSetting() {
        ((ChatListVu)this.getVu()).restoreActionState();
        try {
            boolean result = IMUiKitProxyImpl.getInstance().openChatSettingCallback(((ChatListCallBack)this.chatListCallBack.get()).getTalkId(), ((ChatListCallBack)this.chatListCallBack.get()).getTalkType());
            if (!result) {
                IntentParam.startSettingActivity((Context)this.getActivity(), ((ChatListCallBack)this.chatListCallBack.get()).getTalkId(), ((ChatListCallBack)this.chatListCallBack.get()).getTalkType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onLongClickAtUser(String groupId, String account, String name) {
        ((ChatListCallBack)this.chatListCallBack.get()).onLongClickAtUser(0, groupId, account, name);
    }

    @Override
    public void startLocation(int position, OptionBean optionBean) {
        ((ChatListVu)this.getVu()).restoreActionState();
        IMUiKitProxyImpl.getInstance().startLocation(((ChatListCallBack)this.chatListCallBack.get()).getTalkId());
    }

    @Override
    public void startCallback(int position, OptionBean optionBean) {
        ((ChatListVu)this.getVu()).restoreActionState();
        IMUiKitProxyImpl.getInstance().startCallback(((ChatListCallBack)this.chatListCallBack.get()).getTalkId());
    }

    @Override
    public void startVoice(int position, OptionBean optionBean) {
        ((ChatListVu)this.getVu()).restoreActionState();
        IMUiKitProxyImpl.getInstance().startVoice(((ChatListCallBack)this.chatListCallBack.get()).getTalkId(), ((ChatListCallBack)this.chatListCallBack.get()).getTalkType());
    }

    @Override
    public void listScroll(int firstVisibleItem, int endVisibleItem) {
        for (int i = 0; i < ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().size(); ++i) {
            if (((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().get(i).getMessageType() != 3) continue;
            if (i < firstVisibleItem || i > endVisibleItem) {
                ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().get(i).setGifPlayed(true);
            } else {
                ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().get(i).setGifPlayed(false);
            }
            this.buildAdapter().updateItem(i, ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().get(i));
        }
    }

    @Override
    public void addMeeting() {
        IMUiKitProxyImpl.getInstance().addMeetting(((ChatListCallBack)this.chatListCallBack.get()).getAccount(), ((ChatListCallBack)this.chatListCallBack.get()).getTalkId());
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        LogUtil.d("onActivityResult requestCode:" + requestCode);
        if (data == null) {
            LogUtil.w("ERROR: on bad activity result, data is null.");
            return;
        }
        switch (resultCode) {
            case 1: {
                break;
            }
            case 2: {
                this.handleAlbumResult(data);
                break;
            }
            case 3: {
                this.handleCameraResult(data);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.handleVideoRecorderResult(data);
                break;
            }
            case 6: {
                this.handleFileResult(data);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.handleFileLoadResult(data);
            }
        }
    }

    private void handleAlbumResult(Intent data) {
        ((ChatListCallBack)this.chatListCallBack.get()).handleAlbumResult(data);
    }

    private void handleCameraResult(Intent data) {
        ((ChatListCallBack)this.chatListCallBack.get()).handleCameraResult(data);
    }

    private void handleVideoRecorderResult(Intent data) {
        ((ChatListCallBack)this.chatListCallBack.get()).handleVideoRecorderResult(data);
    }

    private void handleFileResult(Intent data) {
        ((ChatListCallBack)this.chatListCallBack.get()).handleFileResult(data);
    }

    private void handleFileLoadResult(Intent data) {
        ((ChatListCallBack)this.chatListCallBack.get()).handleFileLoadResult(data);
    }

    @Override
    public void onActivityFocusChanged(boolean hasFocus) {
        super.onActivityFocusChanged(hasFocus);
        LogUtil.d("Window focus changed " + hasFocus);
        if (!hasFocus) {
            AudioPlayerManagerProxy.stopPlay();
        }
    }

    public void onPause() {
        super.onPause();
        ((ChatListCallBack)this.chatListCallBack.get()).setAtType();
        IMProxySessionEvent.ClearUnReadMsgEvent event = new IMProxySessionEvent.ClearUnReadMsgEvent();
        event.setTalkId(this.getTalkFlag());
        BusProvider.getInstance().post(event);
        MediaManger.getInstance().restoreAudioMode();
        LogUtil.d("onPause.");
        this.notifyUpdateLastSession();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        LogUtil.d("onDestroyView.");
        this.clearUnReadMsgCount();
        ((ChatListCallBack)this.chatListCallBack.get()).updateFileTranslateSize();
        ((ChatListCallBack)this.chatListCallBack.get()).clearAdapter();
        AudioPlayerManagerProxy.stopPlay();
        AudioListenerManager.getInstance().clearAll();
        ImageCache.getInstance().clearAllCache();
        Glide.get((Context)this.getContext()).clearMemory();
        try {
            BusProvider.getInstance().unregister(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe
    public void onReceiveNewMessage(IMProxyMessageEvent.ReceiveNewMessageEvent event) {
        String from;
        LogUtil.d("EVENT: Receive a new message.");
        List<TalkMessageBean> talkMessageList = event.getTalkMessageList();
        if (talkMessageList == null || talkMessageList.isEmpty()) {
            LogUtil.w("receive new message event, but messageBean is null or empty.");
            return;
        }
        if (((ChatListCallBack)this.chatListCallBack.get()).getTalkType() == 2) {
            for (TalkMessageBean bean : talkMessageList) {
                LogUtil.d("ChatListActivity", "bean.MsgType:" + bean.getMessageType());
                if (bean.getMessageType() != 101) continue;
                if (IMUiKitProxyImpl.getInstance().isShowGroupSetting(((ChatListCallBack)this.chatListCallBack.get()).getTalkId())) {
                    ((ChatListVu)this.getVu()).setToolBarAddVisibility(0);
                    continue;
                }
                ((ChatListVu)this.getVu()).setToolBarAddVisibility(4);
            }
        }
        if (TextUtils.isEmpty((CharSequence)(from = event.getMsgAccount())) || !TextUtils.equals((CharSequence)from, (CharSequence)((ChatListCallBack)this.chatListCallBack.get()).getTalkId())) {
            LogUtil.w("receive new message event, but account is empty.");
            return;
        }
        ((ChatListCallBack)this.chatListCallBack.get()).addNewMessageToList(talkMessageList);
    }

    @Subscribe
    public void onDeleteMessage(IMProxyMessageEvent.DeleteMessageEvent event) {
        LogUtil.d("EVENT: Delete a new message.");
        TalkMessageBean talkMessageBean = event.getTalkMessageBean();
        FileInfo fileInfo = talkMessageBean.getFileInfo();
        if (fileInfo != null && fileInfo.getFileType() == 1) {
            AudioPlayerManagerProxy.stopPlay();
        }
        ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().remove(talkMessageBean);
        ((ChatListCallBack)this.chatListCallBack.get()).notifyDataSetChanged();
    }

    @Subscribe
    public void onRefreshMessage(IMProxyMessageEvent.RefreshMessageEvent event) {
        LogUtil.d("EVENT: refresh single message.");
        TalkMessageBean bean = event.getTalkMessageBean();
        if (bean == null) {
            LogUtil.e("refresh single message, but messageBean is null.");
            return;
        }
        ((ChatListCallBack)this.chatListCallBack.get()).changeMsgState(bean);
    }

    @Subscribe
    public void onRefreshMessageList(IMProxyMessageEvent.RefreshMessageListEvent event) {
        LogUtil.d("EVENT: refresh message list.");
        if (event.isNeedClearInput()) {
            ((ChatListVu)this.getVu()).setInputContent("");
        }
        this.loadMessageList(0L);
    }

    @Subscribe
    public void onRecallMessage(IMProxyMessageEvent.RecallMessageEvent event) {
        TalkMessageBean bean = event.getTalkMessageBean();
        if (bean == null) {
            LogUtil.e("refresh single message, but messageBean is null.");
            return;
        }
        int position = ((ChatListCallBack)this.chatListCallBack.get()).mathMessage(bean.getId());
        if (position < 0) {
            LogUtil.w("math message failed." + bean.getId());
            return;
        }
        ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().set(position, bean);
        this.buildAdapter().updateItem(position, bean);
    }

    @Subscribe
    public void onSendFileComplete(IMProxyFileEvent.SendFileFinishedEvent event) {
        LogUtil.d("EVENT: Send file complete.");
        int position = ((ChatListCallBack)this.chatListCallBack.get()).mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.e("ERROR: Send file completed. position:" + position);
            return;
        }
        FileInfo fileInfo = ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Send file completed, but fileInfo is null.");
            return;
        }
        fileInfo.setFileState(2);
        ((ChatListCallBack)this.chatListCallBack.get()).updateFileInfo(position, fileInfo);
        if (fileInfo.getFileType() == 1) {
            LogUtil.d("Voice send finished.");
            return;
        }
        TranslateInfoUtil.remove(fileInfo.getTalkMessageId());
    }

    @Subscribe
    public void onSendFilePause(IMProxyFileEvent.SendFilePausedEvent event) {
        LogUtil.d("EVENT: Send file pause.");
    }

    @Subscribe
    public void onSendFileProgressUpdate(IMProxyFileEvent.SendFileProgressUpdateEvent event) {
        FileInfo eventFileInfo;
        int fileProperty;
        LogUtil.d("EVENT: Send file progress update.");
        int position = ((ChatListCallBack)this.chatListCallBack.get()).mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.w("Error: Send file progress update, position: " + position);
            return;
        }
        FileInfo fileInfo = ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Send file progress update, but post fileInfo is null.");
            return;
        }
        if ((fileInfo.getFileType() == 3 || fileInfo.getFileType() == 2) && (fileProperty = event.getFileProperty()) == 3) {
            int percent = event.getPercent();
            fileInfo.setTranslatePercent(percent);
        }
        if ((eventFileInfo = event.getFileInfo()) != null) {
            fileInfo.setTranslateSize(eventFileInfo.getTranslateSize());
        }
        fileInfo.setFileState(1);
        ((ChatListCallBack)this.chatListCallBack.get()).updateFileInfo(position, fileInfo);
    }

    @Subscribe
    public void onSendFileFailed(IMProxyFileEvent.SendFileFailedEvent event) {
        LogUtil.d("EVENT: Send file failed.");
        int position = ((ChatListCallBack)this.chatListCallBack.get()).mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.e("ERROR: send file failed, position:" + position);
            return;
        }
        FileInfo fileInfo = ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Send file failed , but fileInfo is null.");
            return;
        }
        LogUtil.w("Send failed file info:" + fileInfo.toString());
        fileInfo.setFileState(5);
        ((ChatListCallBack)this.chatListCallBack.get()).updateFileInfo(position, fileInfo);
    }

    @Subscribe
    public void onReceiveFileComplete(IMProxyFileEvent.ReceiveFileFinishedEvent event) {
        LogUtil.d("EVENT: Receive file complete.");
        int position = ((ChatListCallBack)this.chatListCallBack.get()).mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.e("ERROR: Receive file completed, position:" + position);
            return;
        }
        FileInfo fileInfo = ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Receive file completed, but fileInfo is null.");
            return;
        }
        fileInfo.setFileState(2);
        ((ChatListCallBack)this.chatListCallBack.get()).updateFileInfo(position, fileInfo);
        TranslateInfoUtil.remove(fileInfo.getTalkMessageId());
    }

    @Subscribe
    public void onReceiveFilePause(IMProxyFileEvent.ReceiveFilePausedEvent event) {
        LogUtil.d("EVENT: Receive file pause.");
        int position = ((ChatListCallBack)this.chatListCallBack.get()).mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.w("Error: Receive file PAUSE, position: " + position);
            return;
        }
        FileInfo fileInfo = ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Receive file PAUSE, but post fileInfo is null.");
            return;
        }
        if (event.getFileInfo() != null) {
            fileInfo.setTranslateSize(event.getFileInfo().getTranslateSize());
        }
        fileInfo.setFileState(4);
        ((ChatListCallBack)this.chatListCallBack.get()).updateFileInfo(position, fileInfo);
    }

    @Subscribe
    public void onReceiveFileProgressUpdate(IMProxyFileEvent.ReceiveFileProgressUpdateEvent event) {
        LogUtil.d("EVENT: Receive file progress update.");
        int position = ((ChatListCallBack)this.chatListCallBack.get()).mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.w("Error: Send file progress update, position: " + position);
            return;
        }
        FileInfo fileInfo = ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Send file progress update, but post fileInfo is null.");
            return;
        }
        if (fileInfo.getFileType() != 11) {
            LogUtil.d("No need update file progress.");
            return;
        }
        if (event.getFileInfo() != null) {
            fileInfo.setTranslateSize(event.getFileInfo().getTranslateSize());
        }
        fileInfo.setFileState(3);
        ((ChatListCallBack)this.chatListCallBack.get()).updateFileInfo(position, fileInfo);
    }

    @Subscribe
    public void onReceiveFileFailed(IMProxyFileEvent.ReceiveFileFailedEvent event) {
        LogUtil.d("EVENT: Receive file failed.");
        int position = ((ChatListCallBack)this.chatListCallBack.get()).mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.w("Error: Receive file Failed, position: " + position);
            return;
        }
        FileInfo fileInfo = ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Receive file Failed, but post fileInfo is null.");
            return;
        }
        if (event.getFileInfo() != null) {
            fileInfo.setTranslateSize(event.getFileInfo().getTranslateSize());
        }
        fileInfo.setFileState(5);
        ((ChatListCallBack)this.chatListCallBack.get()).updateFileInfo(position, fileInfo);
        TranslateInfoUtil.remove(fileInfo.getTalkMessageId());
    }

    @Subscribe
    public void onRefreshGroupEvent(IMContactEvent.RefreshGroupEvent event) {
        LogUtil.d("EVENT: Receive group refresh event.");
        String groupId = event.getAccount();
        ((ChatListCallBack)this.chatListCallBack.get()).notifyDataSetChanged();
        if (!((ChatListCallBack)this.chatListCallBack.get()).getTalkId().equals(groupId)) {
            return;
        }
        if (((ChatListCallBack)this.chatListCallBack.get()).getTalkId().equals(groupId)) {
            IMUiKitProxyImpl.getInstance().getAccount(groupId, 2, new Subscriber<AccountBean>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    LogUtil.d("\u83b7\u53d6\u7fa4\u4fe1\u606f\u5931\u8d25");
                }

                public void onNext(AccountBean accountBean) {
                    String displayName = accountBean.getDisplayName();
                    AccountDesc accountDesc = accountBean.getAccountDesc();
                    if (accountDesc != null && accountDesc.getMemberNum() > 0) {
                        displayName = displayName + " (" + accountDesc.getMemberNum() + ")";
                    }
                    ((ChatListVu)ChatListFragment.this.getVu()).setTitle(displayName);
                }
            });
        }
    }

    @Subscribe
    public void onDissolutionGroupEvent(IMContactEvent.DissolutionGroupEvent event) {
        LogUtil.d("EVENT: dissolution group event.");
        this.getActivity().finish();
    }

    @Subscribe
    public void onDataTimeChanged(IMProxyEvent.DataTimeChangedEvent event) {
        LogUtil.d("EVENT: Receive date time changed event.");
        ((ChatListCallBack)this.chatListCallBack.get()).notifyDataSetChanged();
    }

    @Subscribe
    public void onRefreshSessionList(IMProxySessionEvent.RefreshSessionListEvent event) {
        LogUtil.d("EVENT: onRefreshSessionList");
        ((ChatListCallBack)this.chatListCallBack.get()).notifyDataSetChanged();
    }

    @Subscribe
    public void onRefreshRecallMessage(IMProxyEvent.RecallMessageEvent event) {
        if (event == null || event.getTalkMessageBean() == null) {
            return;
        }
        TalkMessageBean bean = event.getTalkMessageBean();
        if (((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean() != null) {
            for (int i = ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().size() - 1; i >= 0; --i) {
                TalkMessageBean messageBean = ((ChatListCallBack)this.chatListCallBack.get()).getListTalkMessageBean().get(i);
                if (messageBean == null || messageBean.getId() != bean.getId()) continue;
                messageBean.setMessageState(7);
                messageBean.setContent(bean.getContent());
                messageBean.setMessageType(bean.getMessageType());
                ((ChatListCallBack)this.chatListCallBack.get()).notifyDataSetChanged();
                ((ChatListVu)this.getVu()).setListSelection(((ChatListVu)this.getVu()).getListView().getFirstVisiblePosition());
                break;
            }
            if (AudioPlayerManagerProxy.isPlaying()) {
                AudioPlayerManagerProxy.stopPlay();
            }
        }
    }

    @Subscribe
    public void onRefreshMeetState(IMProxyMessageEvent.ChatMeetRefreshStateHintEvent event) {
        if (event == null || event.getMeetInfo() == null) {
            return;
        }
        MeetInfo meetInfo = event.getMeetInfo();
        if (meetInfo.isShow()) {
            ((ChatListVu)this.getVu()).setMeetState(meetInfo.isShow(), ((ChatListCallBack)this.chatListCallBack.get()).getTalkType());
        } else {
            ((ChatListVu)this.getVu()).setMeetState(meetInfo.isShow(), ((ChatListCallBack)this.chatListCallBack.get()).getTalkType());
        }
    }

    @Override
    public void playingCallback(String filePath, Object ... args) {
        if (TextUtils.isEmpty((CharSequence)filePath) && (args == null || args.length == 0)) {
            return;
        }
        long msgId = (Long)args[0];
        this.buildAdapter().startAnimation(filePath, msgId);
    }

    @Override
    public void playingStopCallback(String filePath, Object ... args) {
        if (TextUtils.isEmpty((CharSequence)filePath) && (args == null || args.length == 0)) {
            return;
        }
        long msgId = (Long)args[0];
        this.buildAdapter().stopAnimation(filePath, msgId);
    }

    @Override
    public void playingErrorCallback(String filePath, Object ... args) {
        if (TextUtils.isEmpty((CharSequence)filePath) && (args == null || args.length == 0)) {
            return;
        }
        long msgId = (Long)args[0];
        this.buildAdapter().stopAnimation(filePath, msgId);
    }

    @Override
    public void playingCompletionCallback(String filePath, Object ... args) {
        if (TextUtils.isEmpty((CharSequence)filePath) && (args == null || args.length == 0)) {
            return;
        }
        long msgId = (Long)args[0];
        boolean isNext = (Boolean)args[1];
        this.buildAdapter().playNextAudio(filePath, msgId, isNext);
    }
}

