/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AbsListView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.lib.action.ChatActionView;
import com.xdja.im.lib.action.ChatInputView;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.lib.action.listener.IChatActionCallback;
import com.xdja.im.lib.action.listener.IChatActionItemClickListener;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImFragmentSuperView;
import com.xdja.im.uikit.ui.adapter.ChatListAdapter;
import com.xdja.im.uikit.ui.presenter.ChatListPresenter;
import com.xdja.im.uikit.ui.view.vu.ChatListVu;
import com.xdja.im.uikit.utils.FunctionUtils;
import com.xdja.im.uikit.utils.NetworkHelper;
import com.xdja.im.uikit.utils.SpUtils;
import com.xdja.im.uikit.view.KeyboardLayout;
import java.util.List;

public class ViewChatList
extends ImFragmentSuperView<ChatListPresenter>
implements ChatListVu {
    private static final String TAG = "ViewChatList";
    private KeyboardLayout mRootLayout;
    private RelativeLayout mContentLayout;
    private ListView mChatListView;
    private ChatInputView mChatInputView;
    private ChatActionView mChatActionView;
    private SwipeRefreshLayout swipeRefreshLayout;
    private InputMethodManager inputMethodManager;
    private LinearLayout networkStateLineaLayout;
    private TextView networkStateTv;
    private RelativeLayout im_uikit_meeting_tips_layout;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_chat_list;
    }

    @Override
    protected int getToolbarType() {
        return 0;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mRootLayout = (KeyboardLayout)this.findViewById(R.id.root_layout);
        this.mContentLayout = (RelativeLayout)this.findViewById(R.id.content_layout);
        this.mChatListView = (ListView)this.findViewById(R.id.lv_message_list);
        this.mChatInputView = (ChatInputView)this.findViewById(R.id.layout_chat_operate);
        this.mChatActionView = (ChatActionView)this.findViewById(R.id.layout_chat_action);
        this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipe_container);
        this.networkStateLineaLayout = (LinearLayout)this.findViewById(R.id.network_state_view);
        this.networkStateTv = (TextView)this.findViewById(R.id.networkstate_tv);
        this.im_uikit_meeting_tips_layout = (RelativeLayout)this.findViewById(R.id.im_uikit_meeting_tips_layout);
        this.im_uikit_meeting_tips_layout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatListPresenter)ViewChatList.this.getPresenter()).addMeeting();
            }
        });
    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        this.inputMethodManager = (InputMethodManager)this.getActivity().getSystemService("input_method");
        this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                ((ChatListPresenter)ViewChatList.this.getPresenter()).downRefreshList();
            }
        });
        this.registerInputCallback();
        this.mRootLayout.setActivity(this.getActivity());
        this.mChatActionView.setAcceptInput(this.mChatInputView.getInputEdt());
        this.initChatListListView();
        this.setNavigateCallback(new ImFragmentSuperView.onNavigateCallback(){

            @Override
            public void onBackClick() {
            }

            @Override
            public void onAddClick() {
                ((ChatListPresenter)ViewChatList.this.getPresenter()).startSetting();
            }
        });
    }

    @Override
    public void setToolBarVisibility(int visibility) {
        this.supportActionBar(visibility == 0);
    }

    @Override
    public void setToolBarAddVisibility(int visibility) {
        this.setToolBarAddVisible(visibility == 0);
    }

    @Override
    public void setTitle(String title) {
        if (this.isSupportActionBar()) {
            this.setToolBarTitle(title);
        }
    }

    @Override
    public void setAdapter(ChatListAdapter adapter) {
        this.mChatListView.setAdapter((ListAdapter)adapter);
        adapter.notifyDataSetChanged();
    }

    @Override
    public void setOptions(List<OptionBean> options) {
        if (this.mChatActionView != null) {
            this.mChatActionView.setOptionsData(options);
        }
    }

    @Override
    public ListView getListView() {
        return this.mChatListView;
    }

    @Override
    public String getInputContent() {
        return this.mChatInputView.getInputText();
    }

    @Override
    public void setInputContent(String content) {
        if (!TextUtils.isEmpty((CharSequence)content)) {
            this.mChatInputView.setIsDraft(true);
        }
        this.mChatInputView.setInputText(content);
    }

    @Override
    public boolean isRefreshing() {
        return this.swipeRefreshLayout.isRefreshing();
    }

    @Override
    public void stopRefresh() {
        this.swipeRefreshLayout.setRefreshing(false);
    }

    @Override
    public void setListSelection(int selection) {
        if (this.mChatListView != null) {
            this.mChatListView.setSelection(selection);
        }
    }

    @Override
    public void scrollTo(int x, int y) {
        if (this.mChatActionView != null) {
            this.mChatListView.scrollTo(x, y);
        }
    }

    private void registerInputCallback() {
        this.mChatInputView.registerActionViewCallBack(new IChatActionCallback(){

            @Override
            public void onVirtualViewCallBack() {
            }

            @Override
            public void onMoreCheckChanged() {
                if (ViewChatList.this.mChatActionView.isActionViewVisible()) {
                    ViewChatList.this.hideActionView(false);
                    ViewChatList.this.restoreActionState();
                } else {
                    ViewChatList.this.showActionView();
                    ViewChatList.this.mChatInputView.setMoreState(true);
                    ViewChatList.this.mChatActionView.setActionViewVisible(true);
                }
            }

            @Override
            public void onShanCheckChanged() {
                if (ViewChatList.this.mChatActionView.isEmojiVisible()) {
                    ViewChatList.this.hideActionView(true);
                    ViewChatList.this.restoreActionState();
                    ViewChatList.this.setEditTextFocus(true);
                } else {
                    ViewChatList.this.showActionView();
                    ViewChatList.this.mChatInputView.setShanState(true);
                    ViewChatList.this.mChatActionView.setEmojiVisible(true);
                }
            }

            @Override
            public void onInputCheckChanged(boolean isChecked) {
                if (isChecked) {
                    if (ViewChatList.this.mChatActionView.isShown()) {
                        ViewChatList.this.hideActionView(true);
                    }
                } else {
                    if (ViewChatList.this.mRootLayout.isSoftInputShown()) {
                        ViewChatList.this.hideSoftInputView();
                    }
                    if (ViewChatList.this.mChatActionView.isShown()) {
                        ViewChatList.this.hideActionView(false);
                    }
                    ViewChatList.this.restoreActionState();
                }
            }

            @Override
            public void onSendTextCallBack() {
                String content = ViewChatList.this.mChatInputView.getInputText();
                if (TextUtils.isEmpty((CharSequence)content.trim())) {
                    CommonTool.showToast(R.string.im_uikit_content_cannot_null);
                    return;
                }
                if (((ChatListPresenter)ViewChatList.this.getPresenter()).sendTextMessage(content)) {
                    ViewChatList.this.mChatInputView.setInputText("");
                }
            }

            @Override
            public void onInputEareTouchCallBack() {
                if (ViewChatList.this.mChatActionView.isShown()) {
                    ViewChatList.this.restoreActionState();
                }
                if (ViewChatList.this.mChatListView.getTranscriptMode() != 2) {
                    ViewChatList.this.mChatListView.setTranscriptMode(2);
                }
            }

            @Override
            public void onRecorderFinish(int seconds, String filePath) {
                ((ChatListPresenter)ViewChatList.this.getPresenter()).sendVoiceMessage(filePath, seconds);
            }
        });
        this.mChatActionView.setChatActionItemClickListener(new IChatActionItemClickListener(){

            @Override
            public void onItemClick(int position, OptionBean optionBean) {
                if (optionBean.getId() == 5 || optionBean.getId() == 6) {
                    ((ChatListPresenter)ViewChatList.this.getPresenter()).startVoice(position, optionBean);
                } else if (optionBean.getId() == 8) {
                    ((ChatListPresenter)ViewChatList.this.getPresenter()).startLocation(position, optionBean);
                } else if (optionBean.getId() == 7) {
                    ((ChatListPresenter)ViewChatList.this.getPresenter()).startCallback(position, optionBean);
                } else {
                    ((ChatListPresenter)ViewChatList.this.getPresenter()).startToOptionView(position, optionBean);
                }
            }
        });
    }

    private void initChatListListView() {
        this.mChatListView.setOnTouchListener(new View.OnTouchListener(){

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View v, MotionEvent event) {
                if (ViewChatList.this.mChatActionView.isShown()) {
                    ViewChatList.this.restoreActionState();
                    return true;
                }
                ViewChatList.this.mChatListView.setFocusable(true);
                ViewChatList.this.displayInputKeyBoard(false);
                return false;
            }
        });
        this.mChatListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (scrollState == 0) {
                    int firstVisibleItem = ViewChatList.this.mChatListView.getFirstVisiblePosition();
                    int endVisibleItem = ViewChatList.this.mChatListView.getLastVisiblePosition();
                    ((ChatListPresenter)ViewChatList.this.getPresenter()).listScroll(firstVisibleItem, endVisibleItem);
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                ViewChatList.this.mChatListView.setFocusable(true);
            }
        });
    }

    public void displayInputKeyBoard(boolean isShow) {
        this.setEditTextFocus(isShow);
        if (!isShow) {
            this.inputMethodManager.hideSoftInputFromWindow(this.mChatInputView.getInputEdt().getWindowToken(), 0);
            if (this.mChatListView.getTranscriptMode() == 2) {
                this.mChatListView.setTranscriptMode(1);
            }
        } else {
            this.inputMethodManager.toggleSoftInput(0, 2);
        }
    }

    private void setEditTextFocus(boolean isShow) {
        if (isShow) {
            this.mChatInputView.getInputEdt().setFocusable(true);
            this.mChatInputView.getInputEdt().setFocusableInTouchMode(true);
            this.mChatInputView.getInputEdt().requestFocus();
        } else {
            this.mChatInputView.getInputEdt().setFocusable(false);
        }
    }

    @Override
    public void restoreActionState() {
        this.mChatActionView.setVisibility(8);
        this.mChatInputView.setShanState(false);
        this.mChatInputView.setMoreState(false);
        if (this.mChatListView.getTranscriptMode() == 2) {
            this.mChatListView.setTranscriptMode(1);
        }
    }

    @Override
    public void setTalkType(int talkType) {
        if (this.mToolbarAdd != null) {
            if (talkType == 1) {
                this.mToolbarAdd.setImageResource(R.mipmap.im_uikit_ic_toolbar_add);
                this.mChatInputView.setChatType(talkType);
            } else if (talkType == 2) {
                this.mToolbarAdd.setImageResource(R.mipmap.im_uikit_ic_toolbar_add_p2g);
                this.mChatInputView.setChatType(talkType);
            }
        }
    }

    @Override
    public void setChatMeet(String talkFlag) {
        if (SpUtils.getInstance().getBoolean(SpUtils.meetChat) && talkFlag.equals(SpUtils.getInstance().getString(SpUtils.meetTalkFlag))) {
            this.im_uikit_meeting_tips_layout.setVisibility(0);
        } else {
            this.im_uikit_meeting_tips_layout.setVisibility(8);
        }
    }

    public void showActionView() {
        if (this.mRootLayout.isSoftInputShown()) {
            this.lockContentViewHeight();
            this.hideSoftInputView();
            this.restoreActionState();
            this.unlockContentViewHeightDelayed();
        }
        if (this.mChatListView.getTranscriptMode() != 2) {
            this.mChatListView.setTranscriptMode(2);
        }
        this.mChatActionView.setVisibility(0);
        this.mChatInputView.switchToInputEdt(true);
    }

    public void hideActionView(boolean isShowSoftInputView) {
        if (this.mChatActionView.isShown()) {
            this.mChatActionView.setVisibility(8);
            if (this.mChatListView.getTranscriptMode() == 2) {
                this.mChatListView.setTranscriptMode(1);
            }
            if (isShowSoftInputView) {
                this.showSoftInputView();
            }
        }
    }

    public void lockContentViewHeight() {
        LinearLayout.LayoutParams params = this.getLayoutParamsForContent();
        params.height = this.mContentLayout.getHeight() + 200;
        params.weight = 0.0f;
    }

    public void unlockContentViewHeightDelayed() {
        this.mChatInputView.getInputEdt().postDelayed(new Runnable(){

            @Override
            public void run() {
                LinearLayout.LayoutParams params = ViewChatList.this.getLayoutParamsForContent();
                params.weight = 1.0f;
                ViewChatList.this.mContentLayout.invalidate();
            }
        }, 200L);
    }

    private LinearLayout.LayoutParams getLayoutParamsForContent() {
        return (LinearLayout.LayoutParams)this.mContentLayout.getLayoutParams();
    }

    private void showSoftInputView() {
        final EditText et = this.mChatInputView.getInputEdt();
        et.requestFocus();
        et.post(new Runnable(){

            @Override
            public void run() {
                ViewChatList.this.inputMethodManager.showSoftInput((View)et, 0);
            }
        });
    }

    private void hideSoftInputView() {
        this.inputMethodManager.hideSoftInputFromWindow(this.mChatInputView.getInputEdt().getWindowToken(), 0);
    }

    @Override
    public void changeViewSate(int state) {
        this.changeNetworkViewState(state);
        if (!NetworkHelper.getHelper().isFirstNotice() && FunctionUtils.isAppOnForeground((Context)this.getActivity())) {
            if (state == 2) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Network unavailable", (int)1).show();
            } else if (state == 1) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Unable to access the server", (int)1).show();
            }
        }
    }

    @Override
    public void setMeetState(boolean isShow, int talkType) {
        if (isShow && talkType == 2) {
            this.im_uikit_meeting_tips_layout.setVisibility(0);
        } else {
            this.im_uikit_meeting_tips_layout.setVisibility(8);
        }
    }

    private void changeNetworkViewState(int flag) {
        switch (flag) {
            case 2: {
                String tips = this.getActivity().getResources().getString(R.string.im_uikit_network_disabled);
                this.networkStateTv.setText((CharSequence)tips);
                this.networkStateLineaLayout.setVisibility(0);
                break;
            }
            case 1: {
                String tips = this.getActivity().getResources().getString(R.string.im_uikit_network_no_server);
                this.networkStateTv.setText((CharSequence)tips);
                this.networkStateLineaLayout.setVisibility(0);
                break;
            }
            case 0: {
                this.networkStateLineaLayout.setVisibility(8);
                break;
            }
        }
    }
}

