/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.screen.ScreenInfo;
import com.xdja.im.core.utils.FilePathUtils;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.ui.presenter.FilePreviewAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseFilePreview;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.ScreenUtil;
import com.xdja.im.uikit.view.PhotoView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ViewPreviewImage
extends BaseFilePreview {
    private PhotoView mPhotoView;
    private Button mOriginalBtn;
    private ProgressBar mLoadingPbar;
    private ScreenInfo mScreenInfo;
    private BaseListDialog mDialog;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_preview_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mPhotoView = (PhotoView)this.findViewById(R.id.view_photo);
        this.mOriginalBtn = (Button)this.findViewById(R.id.btn_original);
        this.mLoadingPbar = (ProgressBar)this.findViewById(R.id.pbar_loading);
        this.mScreenInfo = ScreenUtil.getScreenInfo(this.getActivity());
        this.mDialog = new BaseListDialog(this.getContext()){

            @Override
            public List<ImOption> getOptions() {
                return ViewPreviewImage.this.buildImOption();
            }
        };
        this.mOriginalBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewPreviewImage.this.mOriginalBtn.setVisibility(8);
                ViewPreviewImage.this.mLoadingPbar.setVisibility(0);
                ImageFileInfo imageFileInfo = (ImageFileInfo)ViewPreviewImage.this.dataSource.getFileInfo();
                FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
                if (rawFileInfo == null) {
                    LogUtil.w("ERROR: raw file info is null.");
                }
                imageFileInfo.setType(3);
                imageFileInfo.setFileState(3);
                ViewPreviewImage.this.dataSource.setFileInfo(imageFileInfo);
                ((FilePreviewAdapterPresenter)ViewPreviewImage.this.getPresenter()).download(imageFileInfo);
            }
        });
        this.mPhotoView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ViewPreviewImage.this.mDialog.show();
                return false;
            }
        });
        this.mDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                switch (option.getOptionType()) {
                    case 0: {
                        ViewPreviewImage.this.savePhoto();
                        break;
                    }
                    case 1: {
                        ViewPreviewImage.this.deletePhoto();
                    }
                }
            }
        });
        this.mPhotoView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewPreviewImage.this.getActivity().finish();
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        ImageFileInfo imageFileInfo = (ImageFileInfo)dataSource.getFileInfo();
        if (imageFileInfo == null) {
            this.loadError();
            return;
        }
        FileInfo hdFileInfo = imageFileInfo.getHdFileInfo();
        if (hdFileInfo == null && this.isFileDownload(hdFileInfo.getFilePath())) {
            LogUtil.e("ERROR: image hd file info is null error.");
            this.loadError();
            return;
        }
        FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
        if (dataSource.isMine()) {
            String filePath = imageFileInfo.getFilePath();
            if (imageFileInfo.isOriginal() && rawFileInfo != null && this.isFileDownload(rawFileInfo.getFilePath())) {
                filePath = rawFileInfo.getFilePath();
            } else if (this.isFileDownload(hdFileInfo.getFilePath())) {
                filePath = hdFileInfo.getFilePath();
            }
            this.loadImage(filePath);
        } else {
            if (imageFileInfo.isOriginal() && this.loadOriginalImage(imageFileInfo)) {
                LogUtil.d("Load origin image.");
                return;
            }
            if (this.isFileDownload(hdFileInfo.getFilePath())) {
                this.loadImage(hdFileInfo.getFilePath());
            } else if (hdFileInfo.getFileState() == 5) {
                this.loadError();
            } else if (hdFileInfo.getFileState() == 1) {
                this.mLoadingPbar.setVisibility(0);
                this.loadThumbImage(imageFileInfo.getFilePath());
                imageFileInfo.setType(2);
                ((FilePreviewAdapterPresenter)this.getPresenter()).download(imageFileInfo);
            }
        }
    }

    private List<ImOption> buildImOption() {
        ArrayList<ImOption> data = new ArrayList<ImOption>();
        data.add(new ImOption(0, this.getStringRes(R.string.im_uikit_preview_option_save)));
        data.add(new ImOption(1, this.getStringRes(R.string.im_uikit_preview_option_delete)));
        return data;
    }

    private boolean loadOriginalImage(ImageFileInfo imageFileInfo) {
        FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
        if (rawFileInfo == null) {
            LogUtil.e("ERROR: Has original image, but raw entity is null.");
            return false;
        }
        if (this.isFileDownload(rawFileInfo.getFilePath())) {
            this.loadImage(rawFileInfo.getFilePath());
            return true;
        }
        this.mOriginalBtn.setVisibility(0);
        this.mOriginalBtn.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_download_original), FileSizeUtils.formatFileSize(rawFileInfo.getFileSize())));
        return false;
    }

    private void loadError() {
        this.mPhotoView.disenable();
        ViewGroup.LayoutParams params = this.mPhotoView.getLayoutParams();
        params.width = -2;
        params.width = -2;
        this.mPhotoView.setScaleType(ImageView.ScaleType.CENTER);
        this.mPhotoView.setImageResource(R.mipmap.im_uikit_pic_default);
        this.mLoadingPbar.setVisibility(8);
        this.mOriginalBtn.setVisibility(8);
    }

    private void loadThumbImage(String filePath) {
        this.mPhotoView.disenable();
        this.mPhotoView.setAdjustViewBounds(false);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        ViewGroup.LayoutParams params = this.mPhotoView.getLayoutParams();
        params.width = options.outWidth;
        params.width = options.outHeight;
        ((FilePreviewAdapterPresenter)this.getPresenter()).loadImage(this.mPhotoView, filePath, ImageView.ScaleType.FIT_CENTER, options.outWidth, options.outHeight);
    }

    private void loadImage(String filePath) {
        if (this.isFileDownload(filePath)) {
            this.mLoadingPbar.setVisibility(8);
            this.mPhotoView.enable();
            this.mPhotoView.setAdjustViewBounds(true);
            ViewGroup.LayoutParams params = this.mPhotoView.getLayoutParams();
            params.width = -1;
            params.width = -1;
            ((FilePreviewAdapterPresenter)this.getPresenter()).loadImage(this.mPhotoView, filePath, ImageView.ScaleType.FIT_CENTER, this.mScreenInfo.getWidth(), this.mScreenInfo.getHeight());
        } else {
            this.loadError();
        }
    }

    private void savePhoto() {
        ImageFileInfo imageFileInfo = (ImageFileInfo)this.dataSource.getFileInfo();
        if (imageFileInfo == null) {
            LogUtil.e("ERROR: Save image, but image file info is null.");
            return;
        }
        String suffix = ToolUtil.getLastString(imageFileInfo.getFileName(), ".");
        String fileName = suffix.equals("gif") ? "imageexport" + System.currentTimeMillis() + ".gif" : "imageexport" + System.currentTimeMillis() + ".jpeg";
        File srcFile = null;
        FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
        if (rawFileInfo != null && this.isFileDownload(rawFileInfo.getFilePath())) {
            srcFile = new File(rawFileInfo.getFilePath());
        } else {
            FileInfo hdFileInfo = imageFileInfo.getHdFileInfo();
            if (hdFileInfo != null && this.isFileDownload(hdFileInfo.getFilePath())) {
                srcFile = new File(hdFileInfo.getFilePath());
            }
        }
        if (srcFile != null) {
            ((FilePreviewAdapterPresenter)this.getPresenter()).saveFile(srcFile, FilePathUtils.getImageRecPath(), fileName);
        } else {
            CommonTool.showToast(R.string.im_uikit_hint_save_image_failed);
        }
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    private void deletePhoto() {
        ((FilePreviewAdapterPresenter)this.getPresenter()).deleteMsg(this.dataSource);
        this.mDialog.dismiss();
    }

    public boolean isFileDownload(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        return options.outWidth > 0 && options.outHeight > 0;
    }

    @Override
    public void onFileDownloadFinish() {
        ImageFileInfo imageFileInfo = (ImageFileInfo)this.dataSource.getFileInfo();
        if (imageFileInfo == null) {
            LogUtil.e("onFileDownloadFinish imageFileInfo is null.");
        }
        this.preLoadImage(imageFileInfo);
    }

    private void preLoadImage(ImageFileInfo imageFileInfo) {
        FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
        if (rawFileInfo != null && FileUtils.isFileExists(rawFileInfo.getFilePath())) {
            this.mLoadingPbar.setVisibility(8);
            this.loadImage(rawFileInfo.getFilePath());
            return;
        }
        FileInfo hdFileInfo = imageFileInfo.getHdFileInfo();
        if (hdFileInfo != null && this.isFileDownload(hdFileInfo.getFilePath())) {
            this.mLoadingPbar.setVisibility(8);
            this.loadImage(hdFileInfo.getFilePath());
        } else {
            this.loadError();
        }
    }
}

