/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.widget.TextView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseReceiveItem;

public class ViewRecvTextItem
extends BaseReceiveItem {
    private TextView mContentTv;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_receive_text;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mContentTv = (TextView)this.findViewById(R.id.tv_content);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        if (dataSource != null) {
            if (dataSource.getMessageState() == 5) {
                this.setMessageDestroy(true);
                this.setRecContentTextColor(this.getLimitTextColor());
                this.setRecContentText(R.string.im_uikit_text_bomb);
            } else {
                this.setMessageDestroy(false);
                this.setRecContentTextColor(this.getNormalTextColor());
                if (!TextUtils.isEmpty((CharSequence)dataSource.getContent())) {
                    this.setRecContentText((CharSequence)EmotionUtils.formatNormalSpanContent(dataSource.getContent(), (Context)this.getActivity()));
                }
                if (dataSource.getMessageState() < 4) {
                    ((ChatListAdapterPresenter)this.getPresenter()).sendReadReceipt(dataSource);
                }
                if (dataSource.getMessageState() == 6) {
                    this.startBombAnim();
                    final TalkMessageBean cloneObj = new TalkMessageBean(dataSource);
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ((ChatListAdapterPresenter)ViewRecvTextItem.this.getPresenter()).postDestroyAnimate(cloneObj);
                        }
                    }, 700L);
                }
            }
        }
    }

    private void setRecContentTextColor(int colorId) {
        if (this.mContentTv != null) {
            this.mContentTv.setTextColor(colorId);
        }
    }

    private void setRecContentText(int contentTextId) {
        if (this.mContentTv != null) {
            this.mContentTv.setText(contentTextId);
        }
    }

    private void setRecContentText(CharSequence contentText) {
        if (this.mContentTv != null) {
            this.mContentTv.setText(contentText);
        }
    }
}

