/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils.image;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import java.io.IOException;
import java.io.InputStream;

public class BitmapUtils {
    private static final int itemh = 360;
    private static final int itemw = 360;

    public static Bitmap getBitmapWithName(String fileName, Resources resource) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        InputStream inputStream = null;
        try {
            inputStream = resource.getAssets().open(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return BitmapFactory.decodeStream((InputStream)inputStream);
    }

    public static Bitmap small(Bitmap bitmap, float scale) {
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap resizeBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        if (resizeBmp != bitmap) {
            bitmap.recycle();
        }
        return resizeBmp;
    }

    public static Bitmap getZoomedDrawable(String filePath, int zoom) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int mWidth = options.outWidth;
        int mHeight = options.outHeight;
        int s = 1;
        while (mWidth / s > 720 * zoom || mHeight / s > 720 * zoom) {
            s *= 2;
        }
        options = new BitmapFactory.Options();
        options.inSampleSize = s;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        options.inJustDecodeBounds = false;
        Bitmap bm = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        if (bm != null) {
            float fs;
            int h = bm.getHeight();
            int w = bm.getWidth();
            float ft = (float)w / (float)h;
            int neww = ft >= (fs = 1.0f) ? 360 * zoom : (int)((float)(360 * zoom) * ft);
            int newh = ft >= fs ? (int)((float)(360 * zoom) / ft) : 360 * zoom;
            float scaleWidth = (float)neww / (float)w;
            float scaleHeight = (float)newh / (float)h;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            bm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
            return bm;
        }
        return null;
    }

    public static Bitmap getZoomedBitMap(Bitmap bitmap, int zoom) {
        if (bitmap != null) {
            float fs;
            int h = bitmap.getHeight();
            int w = bitmap.getWidth();
            float ft = (float)w / (float)h;
            int neww = ft >= (fs = 1.0f) ? 360 * zoom : (int)((float)(360 * zoom) * ft);
            int newh = ft >= fs ? (int)((float)(360 * zoom) / ft) : 360 * zoom;
            float scaleWidth = (float)neww / (float)w;
            float scaleHeight = (float)newh / (float)h;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
            return bitmap;
        }
        return null;
    }
}

