/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view;

import android.annotation.SuppressLint;
import android.content.ClipboardManager;
import android.content.Context;
import android.text.Editable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.widget.EditText;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;

@SuppressLint(value={"AppCompatCustomView"})
public class PastEditText
extends EditText {
    public static final int ID_PASTE = 0x1020022;
    public static final int ID_SELECTALL = 16908319;
    public static final int ID_COPY = 0x1020021;
    public static final int ID_CUT = 0x1020020;
    private final int maxLength = 2048;

    public PastEditText(Context context) {
        super(context);
    }

    public PastEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PastEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onCreateContextMenu(ContextMenu menu) {
        super.onCreateContextMenu(menu);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTextContextMenuItem(int id2) {
        switch (id2) {
            case 0x1020022: {
                try {
                    ClipboardManager cmb = (ClipboardManager)this.getContext().getSystemService("clipboard");
                    if (cmb.getPrimaryClip() == null) return super.onTextContextMenuItem(id2);
                    String value = cmb.getText().toString();
                    String preTxtStr = this.getText().toString();
                    if (preTxtStr.length() + value.length() > 2048) {
                        int regionLength = 2048 - preTxtStr.length();
                        if (regionLength < 0 || regionLength > value.length()) {
                            return true;
                        }
                        value = value.substring(0, regionLength);
                        CommonTool.showToast(R.string.im_uikit_input_length_warnning);
                    }
                    if (TextUtils.isEmpty((CharSequence)value)) return true;
                    try {
                        SpannableString ss = EmotionUtils.formatNormalSpanContent(value, this.getContext(), preTxtStr.length() + value.length());
                        if (TextUtils.isEmpty((CharSequence)ss)) return true;
                        Editable edit = this.getEditableText();
                        edit.insert(this.getSelectionStart(), (CharSequence)ss);
                        this.setFocusable(true);
                        return false;
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        return true;
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
        }
        return super.onTextContextMenuItem(id2);
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return new ZanyInputConnection(super.onCreateInputConnection(outAttrs), true);
    }

    private class ZanyInputConnection
    extends InputConnectionWrapper {
        public ZanyInputConnection(InputConnection target, boolean mutable) {
            super(target, mutable);
        }

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            return super.deleteSurroundingText(beforeLength, afterLength);
        }

        public boolean commitText(CharSequence text, int newCursorPosition) {
            int length = PastEditText.this.getText().length();
            if (length >= 2048) {
                CommonTool.showToast(R.string.im_uikit_input_length_warnning);
                return false;
            }
            if (EmotionUtils.mathEmotion(text.toString())) {
                Editable edit = PastEditText.this.getEditableText();
                SpannableString ss = EmotionUtils.formatNormalSpanContent(text, PastEditText.this.getContext());
                edit.insert(PastEditText.this.getSelectionStart(), (CharSequence)ss);
                return false;
            }
            return super.commitText(text, newCursorPosition);
        }
    }
}

