package com.xdja.im.base.eventbus;

import com.squareup.otto.Bus;
import com.squareup.otto.ThreadEnforcer;

import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;

/**
 * @Package: com.xdja.im.base.eventbus
 * @Author: xdjaxa
 * @Creation: 2017-04-17 9:42
 * @Version V1.0
 * @Description:
 */
public class BusProvider {

    private final Bus mainBus;

    private BusProvider() {
        this.mainBus = new Bus(ThreadEnforcer.ANY);
    }

    private static class SingletonInstance{
        private static BusProvider mInstance = new BusProvider();
    }

    public static BusProvider getInstance() {
        return SingletonInstance.mInstance;
    }

    /**
     * {@link Bus#register(Object)}
     *
     * @param object object whose handler methods should be registered
     */
    public void register(Object object) {
        this.mainBus.register(object);
    }

    /**
     * {@link Bus#unregister(Object)}
     *
     * @param object object whose producer and handler methods should be unregistered.
     */
    public void unregister(Object object) {
        this.mainBus.unregister(object);
    }

    /**
     * {@link Bus#post(Object)}
     *
     * @param event event to post.
     */
    public void post(Object event) {
        Observable.just(event)
                //do post on main thread
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<Object>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {

                    }

                    @Override
                    public void onNext(Object event) {
                        mainBus.post(event);
                    }
                });
    }
}
