package com.xdja.im.common.database.helper;

import android.text.TextUtils;

import com.xdja.im.common.database.bean.SessionDb;
import com.xdja.im.common.database.dao.SessionEntityDao;
import com.xdja.im.core.model.param.SessionParam;

import java.util.ArrayList;
import java.util.List;

/**
 * @Package: com.xdja.im.common.database.helper
 * @Author: xdjaxa
 * @Creation: 2017-05-31 9:05
 * @Version V1.0
 * @Description:密信服务设置相关帮助类
 */
public class MXSettingHelper {

    /**
     * 设置聊天置顶功能
     *
     * @param sessionFlag 会话标识
     * @return
     */
    public static boolean setSessionTop(String sessionFlag, boolean isTop) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb == null) {
            sessionDb = new SessionDb();
            sessionDb.setSessionFlag(sessionFlag);
            sessionDb.setSessionMode(isTop ? 1 : 0); //0：未置顶  1：置顶
            sessionDb.setDraftContent("");
            sessionDb.setDraftCreateTime(0);
            SessionEntityDao.getInstance().insert(sessionDb);
        } else {
            sessionDb.setSessionMode(isTop ? 1 : 0); //0：未置顶  1：置顶
            if (TextUtils.isEmpty(sessionDb.getDraftContent())) {
                sessionDb.setDraftContent("");
            }
            SessionEntityDao.getInstance().update(sessionDb);
        }
        return true;
    }

    /**
     * 会话免打扰设置
     *
     * @param sessionFlag
     * @param isDisturb
     * @return
     */
    public static boolean setSessionDisturb(String sessionFlag, boolean isDisturb) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb == null) {
            sessionDb = new SessionDb();
            sessionDb.setSessionFlag(sessionFlag);
            sessionDb.setSessionDisturb(isDisturb ? 1 : 0); //0：关闭  1：开启
            sessionDb.setDraftContent("");
            sessionDb.setDraftCreateTime(0);
            SessionEntityDao.getInstance().insert(sessionDb);
        } else {
            sessionDb.setSessionDisturb(isDisturb ? 1 : 0); //0：关闭  1：开启
            if (TextUtils.isEmpty(sessionDb.getDraftContent())) {
                sessionDb.setDraftContent("");
            }
            SessionEntityDao.getInstance().update(sessionDb);
        }
        return true;
    }

    /**
     * 会话听筒模式设置
     *
     * @param sessionFlag
     * @param isOpen
     * @return
     */
    public static boolean setReceiveMode(String sessionFlag, boolean isOpen) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb == null && isOpen) {
            sessionDb = new SessionDb();
            sessionDb.setSessionFlag(sessionFlag);
            sessionDb.setReceiveMode(isOpen ? 1 : 0); //0：关闭  1：开启
            sessionDb.setDraftContent("");
            sessionDb.setDraftCreateTime(0);
            SessionEntityDao.getInstance().insert(sessionDb);
        } else {
            sessionDb.setReceiveMode(isOpen ? 1 : 0); //0：关闭  1：开启
            if (TextUtils.isEmpty(sessionDb.getDraftContent())) {
                sessionDb.setDraftContent("");
            }
            SessionEntityDao.getInstance().update(sessionDb);
        }
        return true;
    }

    /**
     * 判断会话是否免打扰
     *
     * @param sessionFlag 会话标识
     * @return
     */
    public static boolean isSessionDisturb(String sessionFlag) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb != null) {
            return sessionDb.getSessionDisturb() == 1;
        }
        return false;
    }

    /**
     * 插入一条草稿信息
     *
     * @param sessionFlag  会话标识
     * @param draftContent 草稿内容
     * @param draftTime    草稿创建时间
     * @return
     */
    public static boolean insertDraft(String sessionFlag, String draftContent, long draftTime) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb == null) {
            sessionDb = new SessionDb();
            sessionDb.setSessionFlag(sessionFlag);
            sessionDb.setDraftContent(draftContent);
            sessionDb.setDraftCreateTime(draftTime);
            SessionEntityDao.getInstance().insert(sessionDb);
        } else {
            sessionDb.setDraftContent(draftContent);
            if (draftTime > 0) {
                sessionDb.setDraftCreateTime(draftTime);
            }
            SessionEntityDao.getInstance().update(sessionDb);
        }
        return true;
    }

    /**
     * 清除草稿内容
     *
     * @param sessionFlag 会话标识
     * @param draftTime   草稿创建时间
     * @return
     */
    public static boolean clearDraft(String sessionFlag, long draftTime) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb != null) {
            sessionDb.setDraftContent("");
            if (draftTime > 0) {
                sessionDb.setDraftCreateTime(draftTime);
            }
            SessionEntityDao.getInstance().update(sessionDb);
        }
        return true;
    }

    /**
     * 获取草稿内容
     *
     * @param sessionFlag
     * @return
     */
    public static String getDraftContent(String sessionFlag) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb != null) {
            return sessionDb.getDraftContent();
        }
        return "";
    }

    /**
     * 判断是否有草稿
     *
     * @param sessionFlag 会话标识
     * @return
     */
    public static boolean isHasDraft(String sessionFlag) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb != null) {
            //草稿内容可能为空字符
            return sessionDb.getDraftContent() != null && sessionDb.getDraftCreateTime() > 0;
        }
        return false;
    }

    public static SessionParam getSessionParam(String sessionFlag) {
        SessionParam param = new SessionParam();
        SessionDb db = SessionEntityDao.getInstance().get(sessionFlag);
        if (db != null) {
            param.setSessionFlag(db.getSessionFlag());
            param.setTop(db.getSessionMode() == 1 ? true : false);
            param.setDisturb(db.getSessionDisturb() == 1 ? true : false);
            param.setReceiveMode(db.getReceiveMode() == 1 ? true : false);
            param.setDraftContent(db.getDraftContent());
            param.setDraftTime(db.getDraftCreateTime());
        }
        return param;
    }

    public static void updateSessionParam(SessionParam sessionParam) {
        if (sessionParam == null) {
            return;
        }
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionParam.getSessionFlag());
        if (sessionDb == null) {
            sessionDb = new SessionDb();
            sessionDb.setSessionFlag(sessionParam.getSessionFlag());
            sessionDb.setSessionMode(sessionParam.isTop() ? 1 : 0); //0：未置顶  1：置顶
            if (!TextUtils.isEmpty(sessionParam.getDraftContent()))
                sessionDb.setDraftContent(sessionParam.getDraftContent());
            else sessionDb.setDraftContent("");
            sessionDb.setDraftCreateTime(sessionParam.getDraftTime());
            sessionDb.setSessionDisturb(sessionParam.isDisturb() ? 1 : 0);//0：关闭  1：开启
            sessionDb.setReceiveMode(sessionParam.isReceiveMode() ? 1 : 0);
            SessionEntityDao.getInstance().insert(sessionDb);
        } else {
            sessionDb.setSessionFlag(sessionParam.getSessionFlag());
            sessionDb.setSessionMode(sessionParam.isTop() ? 1 : 0); //0：未置顶  1：置顶
            if (!TextUtils.isEmpty(sessionParam.getDraftContent()))
                sessionDb.setDraftContent(sessionParam.getDraftContent());
            else sessionDb.setDraftContent("");
            sessionDb.setDraftCreateTime(sessionParam.getDraftTime());
            sessionDb.setSessionDisturb(sessionParam.isDisturb() ? 1 : 0);//0：关闭  1：开启
            sessionDb.setReceiveMode(sessionParam.isReceiveMode() ? 1 : 0);
            SessionEntityDao.getInstance().update(sessionDb);
        }
    }

    /**
     * 获取所有的配置信息
     *
     * @return
     */
    public static List<SessionParam> getAllSessionParams() {
        List<SessionParam> sessionParams = new ArrayList<>();
        List<SessionDb> sessionDbs = SessionEntityDao.getInstance().getAll();
        for (SessionDb db : sessionDbs) {
            SessionParam param = new SessionParam();
            param.setSessionFlag(db.getSessionFlag());
            param.setTop(db.getSessionMode() == 1 ? true : false);
            param.setDisturb(db.getSessionDisturb() == 1 ? true : false);
            param.setReceiveMode(db.getReceiveMode() == 1 ? true : false);
            param.setDraftContent(db.getDraftContent());
            param.setDraftTime(db.getDraftCreateTime());
            sessionParams.add(param);
        }
        return sessionParams;
    }

    /**
     * 删除会话配置
     *
     * @param sessionFlag 会话标识
     * @return
     */
    public static boolean deleteSessionParam(String sessionFlag) {
        return SessionEntityDao.getInstance().delete(sessionFlag) >= 0;
    }

    /**
     * 仅清除草稿信息
     *
     * @param sessionFlag
     */
    public static void deleteOnlyDraft(String sessionFlag) {
        SessionEntityDao.getInstance().deleteOnlyDraft(sessionFlag);
    }

    /**
     * 清除会话所有数据
     *
     * @return
     */
    public static boolean deleteAllSessionParams() {
        return SessionEntityDao.getInstance().deleteAll() >= 0;
    }
}
