package com.xdja.im.common.persistent;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;

import com.xdja.im.base.di.DiConfig;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.common.cache.interf.UserCache;

import javax.inject.Inject;

/**
 * @Package: com.xdja.im.common.persistent
 * @Author: xdjaxa
 * @Creation: 2017-04-11 10:55
 * @Version V1.0
 * @Description:缓存数据操作工具类
 */
public class PreferencesUtil {

    private SharedPreferences sp;
    private SharedPreferences.Editor sharedEditor;

    @Inject
    public PreferencesUtil(@Scoped(DiConfig.CONTEXT_SCOPE_APP) Context context,
                           UserCache userCache) {
        String account = userCache.get().getAccount();
        sp = context.getSharedPreferences("configuration_" + account, 0);
        sharedEditor = sp.edit();
    }

    /**
     * Set a preference string value
     *
     * @param key   the preference key to set
     * @param value the value for this key
     */
    public boolean setPreferenceStringValue(String key, String value) {
        if (sharedEditor == null) {
            SharedPreferences.Editor editor = sp.edit();
            editor.putString(key, value);
            return editor.commit();
        } else {
            sharedEditor.putString(key, value);
            return sharedEditor.commit();
        }
    }

    /**
     * Set a preference boolean value
     *
     * @param key   the preference key to set
     * @param value the value for this key
     */
    public boolean setPreferenceBooleanValue(String key, boolean value) {
        if (sharedEditor == null) {
            SharedPreferences.Editor editor = sp.edit();
            editor.putBoolean(key, value);
            return editor.commit();
        } else {
            sharedEditor.putBoolean(key, value);
            return sharedEditor.commit();
        }
    }

    /**
     * Set a preference float value
     *
     * @param key   the preference key to set
     * @param value the value for this key
     */
    public boolean setPreferenceFloatValue(String key, float value) {
        if (sharedEditor == null) {
            SharedPreferences.Editor editor = sp.edit();
            editor.putFloat(key, value);
            return editor.commit();
        } else {
            sharedEditor.putFloat(key, value);
            return sharedEditor.commit();
        }
    }

    /**
     * Set a preference int value
     *
     * @param key   the preference key to set
     * @param value the value for this key
     */
    public boolean setPreferenceIntValue(String key, int value) {
        if (sharedEditor == null) {
            SharedPreferences.Editor editor = sp.edit();
            editor.putInt(key, value);
            return editor.commit();
        } else {
            sharedEditor.putInt(key, value);
            return sharedEditor.commit();
        }
    }

    // For string
    public String gPrefStringValue(@Nullable String key) {
        return sp.getString(key, "");
    }

    // For boolean
    public Boolean gPrefBooleanValue(@Nullable String key, boolean defaultValue) {
        return sp.getBoolean(key, defaultValue);
    }

    // For int
    public int gPrefIntValue(@Nullable String key) {
        return sp.getInt(key, 0);
    }

    // For int
    public long gPrefLongValue(@Nullable String key) {
        return sp.getLong(key, 0);
    }

    // For float
    public float gPrefFloatValue(@Nullable String key) {
        return sp.getFloat(key, 0);
    }

}
