package com.xdja.im.common.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.widget.Toast;

import com.xdja.im.base.di.DiConfig;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.UiKitOptions;

import javax.inject.Inject;

/**
 * @Package: com.xdja.im.common.utils
 * @Author: xdjaxa
 * @Creation: 2017-04-12 16:44
 * @Version V1.0
 * @Description: Android通用工具类相关
 */
public class CommonTool {

    private static Resources resources;

    private static Toast toast;

    @Inject
    public CommonTool(@Scoped(DiConfig.CONTEXT_SCOPE_APP) Context context) {
        this.resources = context.getResources();
        this.toast = Toast.makeText(context, "", Toast.LENGTH_LONG);
    }

    public static void showToast(String content) {
        try {
            if (toast == null) {
                toast = Toast.makeText(ImUiKit.getInstance().getContext(),
                        "", Toast.LENGTH_LONG);
            }
            toast.setText(content);
            toast.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showToast(int resId) {
        try {
            if (toast == null) {
                toast = Toast.makeText(ImUiKit.getInstance().getContext(),
                        "", Toast.LENGTH_LONG);
            }
            toast.setText(resId);
            toast.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getString(int resId) {
        try {
            if (resources == null) {
                resources = ImUiKit.getInstance().getContext().getResources();
            }
            return resources.getString(resId);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static Drawable getDrawable(int resId) {
        if (resources == null) {
            resources = ImUiKit.getInstance().getContext().getResources();
        }
        return resources.getDrawable(resId);
    }

    public static int dp2px(Context context, int dp) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dp,
                context.getResources().getDisplayMetrics());
    }

    /**
     * 是否跟随系统字体变化
     *
     * @return
     */
    public static boolean isChangeFontScale() {
        UiKitOptions options = ImUiKit.getInstance().getOptions();
        if (options != null) {
            return options.isChangeFontScale();
        }
        return false;
    }

    /**
     * 获取平台类型
     *
     * @return
     */
    public static int getPlatformType() {
        return ImUiKit.getInstance().getComponent().configCache().getDevice().getPlatformType();
    }

    /**
     * 获取设备类型
     *
     * @return
     */
    public static int getDeviceType() {
        return ImUiKit.getInstance().getComponent().configCache().getDevice().getDeviceType();
    }

    /**
     * 区分IM使用方
     *
     * @return
     */
    public static int getExtType() {
        return ImUiKit.getInstance().getComponent().configCache().getDevice().getExtType();
    }
}
