package com.xdja.im.core.model.message;

import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.param.SessionParam;

/**
 * @Package: com.xdja.im.core.model
 * @Author: xdjaxa
 * @Creation: 2017-04-11 14:46
 * @Version V1.0
 * @Description: 会话消息类型定义
 */
public class TalkSessionBean implements Comparable<TalkSessionBean> {

    /**
     * 会话标识，用于唯一标识一个会话
     */
    private String talkFlag;

    /**
     * 会话对象ID 单聊：聊天对象账号   群组：群号
     */
    private String talkerAccount;

    /**
     * ImSdk返回的会话时间
     * 1、有消息时，为最后一条消息时间，
     * 2、新会话时，会话创建时间，
     * 3、消息被清空时，为最后一条消息时间
     */
    private long lastTime;

    /**
     * 会话中最后一条聊天消息
     */
    private TalkMessageBean lastMsg;

    /**
     * 会话中最后一条消息的发送方账号
     */
    private String lastMsgAccount;

    /**
     * 最后一条消息类型
     */
    @ConstDef.MsgType
    private int lastMsgType;

    /**
     * 最后一条消息的显示内容
     */
    private CharSequence content;

    /**
     * 未读消息数量
     */
    private int notReadCount;

    /**
     * 会话类型（群聊/单人聊天）
     */
    private int talkType = ConstDef.CHAT_TYPE_DEFAULT;

    /**
     * 会话设置信息
     */
    private SessionParam param;

    public String getTalkFlag() {
        return talkFlag;
    }

    public void setTalkFlag(String talkFlag) {
        this.talkFlag = talkFlag;
        if (TextUtils.isEmpty(talkerAccount)) {
            decompose(talkFlag);
        }
    }

    public String getTalkerAccount() {
        return talkerAccount;
    }

    public void setTalkerAccount(String talkerAccount) {
        this.talkerAccount = talkerAccount;
    }

    public long getLastTime() {
        return lastTime;
    }

    public void setLastTime(long lastTime) {
        this.lastTime = lastTime;
    }

    public TalkMessageBean getLastMsg() {
        return lastMsg;
    }

    public void setLastMsg(TalkMessageBean lastMsg) {
        this.lastMsg = lastMsg;
    }

    public String getLastMsgAccount() {
        return lastMsgAccount;
    }

    public void setLastMsgAccount(String lastMsgAccount) {
        this.lastMsgAccount = lastMsgAccount;
    }

    public int getLastMsgType() {
        return lastMsgType;
    }

    public void setLastMsgType(int lastMsgType) {
        this.lastMsgType = lastMsgType;
    }

    public int getNotReadCount() {
        return notReadCount;
    }

    public void setNotReadCount(int notReadCount) {
        this.notReadCount = notReadCount;
    }

    public int getTalkType() {
        return talkType;
    }

    public void setTalkType(int talkType) {
        this.talkType = talkType;
    }

    public CharSequence getContent() {
        return content;
    }

    public void setContent(CharSequence content) {
        this.content = content;
    }

    public SessionParam getParam() {
        return param;
    }

    public void setParam(SessionParam param) {
        this.param = param;
    }

    @Override
    public String toString() {
        return "TalkSessionBean{" +
                "talkFlag='" + talkFlag + '\'' +
                ", talkerAccount='" + talkerAccount + '\'' +
                ", lastTime=" + lastTime +
                ", lastMsg=" + lastMsg +
                ", lastMsgAccount='" + lastMsgAccount + '\'' +
                ", lastMsgType=" + lastMsgType +
                ", content=" + content +
                ", notReadCount=" + notReadCount +
                ", talkType=" + talkType +
                ", param=" + param +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TalkSessionBean that = (TalkSessionBean) o;

        return talkFlag != null ? talkFlag.equals(that.talkFlag) : that.talkFlag == null;
    }

    @Override
    public int hashCode() {
        return talkFlag != null ? talkFlag.hashCode() : 0;
    }

    @Override
    public int compareTo(@NonNull TalkSessionBean o) {
        if (this.param != null && o.param != null) {

            if (this.param.isTop() && !o.param.isTop()) {
                return -1;
            }

            if (!this.param.isTop() && o.param.isTop()) {
                return 1;
            }

            if (this.param.isTop() && o.param.isTop()) {
                if (this.param.getShowOnTopTime() == o.param.getShowOnTopTime()) {
                    return 0;
                }
                return this.param.getShowOnTopTime() > o.param.getShowOnTopTime() ? -1 : 1;
            }
        } else  if (this.param == null && o.param != null && o.param.isTop()) {
            return 1;
        } else if (this.param != null && o.param == null && this.param.isTop()) {
            return -1;
        }
        //return o.getLastTime() > this.getLastTime() ? 1 : -1;
        return o.getDisplayTime() > this.getDisplayTime() ? 1 : -1;
    }

    /**
     * sessionFlag拆分成账号和聊天类型
     *
     * @param sessionFlag
     */
    public void decompose(String sessionFlag) {
        if (TextUtils.isEmpty(sessionFlag)) {
            return;
        }
        String[] data = sessionFlag.split("_");
        this.talkerAccount = data[0];
        this.talkType = Integer.parseInt(data[1]);
    }
    /**
     * 获取会话显示时间：ImSdk返回的会话时间和草稿时间中取其中的较大值
     * @return long
     */
    public long getDisplayTime() {
        if (null == this.param) {
            return this.lastTime;
        }
        if (this.lastTime >= this.param.getDraftTime()) {
            return this.lastTime;
        }
        return this.param.getDraftTime();
    }
}
