package com.xdja.im.core.repository.impl;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.view.View;

import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.common.utils.PermissionUtils;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.account.AccountDesc;
import com.xdja.im.core.model.event.IMProxySessionEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.core.model.message.file.VoiceFileInfo;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.core.repository.interf.ChatListCallBack;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.lib.action.uitls.OptionParser;
import com.xdja.im.lib.album.bean.ImageThumbBean;
import com.xdja.im.lib.camera.bean.PhotoThumbBean;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.video.bean.VideoItem;
import com.xdja.im.uikit.IntentParam;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.constans.Constant;
import com.xdja.im.uikit.notification.NotificationUtil;
import com.xdja.im.uikit.ui.adapter.ChatListAdapter;
import com.xdja.im.uikit.ui.presenter.ChatListPresenter;
import com.xdja.im.uikit.ui.view.vu.ChatListVu;
import com.xdja.im.uikit.utils.AtAccountNickMap;
import com.xdja.im.uikit.utils.AtPreferencesUtils;
import com.xdja.im.uikit.utils.DataConvertUtils;
import com.xdja.im.uikit.utils.ObjectUtil;
import com.xdja.im.uikit.utils.file.TranslateInfoUtil;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.inject.Inject;

import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

import static com.xdja.im.uikit.ui.activity.ChatListActivity.EXTRA_KEY_CANCEL_BOTTOM_POP_MENU_ID_ARRAY;

/**
 * Created by Administrator on 2017/12/28.
 */

public class ChatListCallBackImpl implements ChatListCallBack {


    /**
     * 聊天对象账号id
     */
    private String mTalkId;
    /**
     * 会话类型
     */
    private int mTalkType;
    /**
     * 每页消息展示数量
     */
    private static final int PAGE_SIZE = 15;
    /**
     * 是否选中闪信
     */
    private boolean isLimit = false;

    /**
     * 进入聊天界面时，是否存在草稿信息
     */
    private boolean isHasDraft;

    /**
     * 消息列表
     */
    private List<TalkMessageBean> mMessageList = new ArrayList<>();

    /**
     * 适配器
     */
    private ChatListAdapter mAdapter;

    private int[] mCancelBottomPopMenuIdArray;

    private ChatListVu vu;

    private ChatListPresenter presenter;

    ProxyRepository proxyRepository;

    DiskDataStore diskDataStore;

    UserCache userCache;

    @Inject
    public ChatListCallBackImpl(ProxyRepository proxyRepository
            , DiskDataStore diskDataStore
            , UserCache userCache) {
        this.proxyRepository = proxyRepository;
        this.diskDataStore = diskDataStore;
        this.userCache = userCache;
    }

    @Override
    public String getTalkId() {
        return mTalkId;
    }

    @Override
    public int getTalkType() {
        return mTalkType;
    }

    @Override
    public List<TalkMessageBean> getListTalkMessageBean() {
        return mMessageList;
    }

    @Override
    public int[] getCancelBottomPopMenuIdArray() {
        return mCancelBottomPopMenuIdArray;
    }

    @Override
    public void initChatPram(Bundle arguments, ChatListVu vu, ChatListPresenter presenter) {
        this.vu = vu;
        this.presenter = presenter;
        if (arguments != null) {
            try {
                mCancelBottomPopMenuIdArray = arguments.getIntArray(EXTRA_KEY_CANCEL_BOTTOM_POP_MENU_ID_ARRAY);
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                mTalkId = arguments.getString(Constant.TAG_TALKERID);
                mTalkType = arguments.getInt(Constant.TAG_TALKTYPE, ConstDef.CHAT_TYPE_P2P);
            }
        }
    }

    @Override
    public void setTitle() {
        vu.setToolBarAddVisibility(View.VISIBLE);
        vu.setToolBarVisibility(View.VISIBLE);
        if (mTalkType == ConstDef.CHAT_TYPE_P2P) {
            IMUiKitProxyImpl.getInstance().getAccount(mTalkId, ConstDef.CHAT_TYPE_P2P, new Subscriber<AccountBean>() {
                @Override
                public void onCompleted() {
                }

                @Override
                public void onError(Throwable e) {
                }

                @Override
                public void onNext(AccountBean accountBean) {
                    vu.setTitle(accountBean.getDisplayName());
                    vu.setToolBarAddVisibility(View.VISIBLE);
                }
            });
        } else {
            IMUiKitProxyImpl.getInstance().getAccount(mTalkId, ConstDef.CHAT_TYPE_P2G, new Subscriber<AccountBean>() {
                @Override
                public void onCompleted() {

                }

                @Override
                public void onError(Throwable e) {

                }

                @Override
                public void onNext(AccountBean accountBean) {
                    String displayName = accountBean.getDisplayName();
                    AccountDesc accountDesc = accountBean.getAccountDesc();
                    if (accountDesc != null && accountDesc.getMemberNum() > 0) {
                        displayName += " (" + accountDesc.getMemberNum() + ")";
                        vu.setToolBarAddVisibility(View.VISIBLE);
                    } else {
                        vu.setToolBarAddVisibility(View.INVISIBLE);
                    }
                    vu.setTitle(displayName);
                }
            });
        }
    }

    @Override
    public void requestPermissions(Activity context) {
        if (!PermissionUtils.hasSelfPermissions(context,
                Manifest.permission.READ_EXTERNAL_STORAGE,
                Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
            //请求权限
            PermissionUtils.requestPermissions(context,
                    new String[]{Manifest.permission.READ_EXTERNAL_STORAGE,
                            Manifest.permission.WRITE_EXTERNAL_STORAGE},
                    Constant.REQUEST_PERMISSION_STORAGE);
        }
    }

    @Override
    public ChatListAdapter buildAdapter() {
        if (mAdapter == null) {
            mAdapter = new ChatListAdapter(presenter, mMessageList,
                    vu.getListView(), proxyRepository);
            vu.getListView().setAdapter(mAdapter);
        }
        return mAdapter;
    }

    @Override
    public void notifyDataSetChanged() {
        try {
            if (mAdapter == null) {
                buildAdapter();
            }
            mAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getAccount() {
        return userCache.get().getAccount();
    }

    @Override
    public void clearAdapter() {
        if (mAdapter != null) {
            mAdapter = null;
        }
    }

    @Override
    public void loadMessageList(final long msgId) {
        LogUtil.d("Start load message msgId " + msgId);
        proxyRepository.getMessageList(mTalkId, mTalkType, msgId, PAGE_SIZE, new Subscriber<List<TalkMessageBean>>() {
            @Override
            public void onCompleted() {
                if (vu.isRefreshing()) {
                    vu.stopRefresh();
                }
            }

            @Override
            public void onError(Throwable e) {
                LogUtil.e("load message error:" + e.getMessage());
                if (vu.isRefreshing()) {
                    vu.stopRefresh();
                }
            }

            @Override
            public void onNext(List<TalkMessageBean> talkMessageList) {
                LogUtil.d(talkMessageList.toString());

                if (talkMessageList == null /*|| talkMessageList.isEmpty()*/) {
                    return;
                }
                if (msgId == 0) {
                    //传入0，拉取最新消息
                    mMessageList.clear();
                }

                if (talkMessageList.size() > 0) {
                    mMessageList.addAll(0, talkMessageList);
                }
                buildAdapter().notifyDataSetChanged();

                LogUtil.d("Load message is refreshing " + vu.isRefreshing());
                if (vu.isRefreshing()) {
                    if (talkMessageList.size() > 0) {
                        vu.setListSelection(talkMessageList.size() - 1);
                    }
                } else {
                    if (mMessageList.size() > 0) {
                        vu.setListSelection(mMessageList.size() - 1);
                    }
                    vu.restoreActionState();
                }
            }
        });
    }

    @Override
    public void downRefreshList() {
        long msgId = 0;
        if (!mMessageList.isEmpty()) {
            msgId = mMessageList.get(0).getId();
        }
        LogUtil.d("do refresh, msgId :" + msgId);
        loadMessageList(msgId);
    }

    @Override
    public void startLoadOptions(final Context context) {
        Observable.just("")
                .subscribeOn(Schedulers.newThread())
                .flatMap(new Func1<String, Observable<OptionBean>>() {
                    @Override
                    public Observable<OptionBean> call(String s) {
                        try {
                            List<OptionBean> options = OptionParser.getOptions(context);
                            return Observable.from(options);
                        } catch (Exception e) {
                            e.printStackTrace();
                            return Observable.error(e);
                        }
                    }
                })
                .filter(new Func1<OptionBean, Boolean>() {
                    @Override
                    public Boolean call(OptionBean optionBean) {
                        if (inCancelArray(optionBean.getId())) {
                            return false;
                        }
                        if (mTalkType == ConstDef.CHAT_TYPE_P2G) {
                            return optionBean.getType() != 1;
                        } else if (mTalkType == ConstDef.CHAT_TYPE_P2P) {
                            return optionBean.getType() != 2;
                        }
                        return true;
                    }
                })
                .toList()
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<List<OptionBean>>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        LogUtil.e("ERROR: Load options data error." + e.getMessage());
                    }

                    @Override
                    public void onNext(List<OptionBean> optionBeen) {
                        LogUtil.d("ChatOptions:" + optionBeen.toString());
                        vu.setOptions(optionBeen);
                    }
                });
    }

    private boolean inCancelArray(int srcId) {
        if (mCancelBottomPopMenuIdArray == null) {
            return false;
        }
        for (int id : mCancelBottomPopMenuIdArray) {
            if (id == srcId) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void notifyUpdateLastSession() {
        String draftContent = vu.getInputContent();
        LogUtil.d("Draft input content:" + draftContent);
        if (draftContent != null && !TextUtils.isEmpty(draftContent.trim())) {
            //退出时有草稿信息，更新草稿信息
            updateDraftContent(draftContent);
        } else {
            //通知更新消息
            if (!mMessageList.isEmpty()) {
                TalkSessionBean updateSessionBean = new TalkSessionBean();
                TalkMessageBean lastMessageBean = mMessageList.get(mMessageList.size() - 1);
                updateSessionBean.setContent(lastMessageBean.getContent());
                updateSessionBean.setLastTime(lastMessageBean.getShowTime());
                updateSessionBean.setLastMsg(lastMessageBean);
                sendNotifyUpdateEvent(updateSessionBean);
            }
            //进入时有草稿，退出时清除草稿
            LogUtil.d("Has draft:" + isHasDraft);
            if (isHasDraft) {
                updateDraftContent(draftContent);
            }
        }
    }

    @Override
    public void sendNotifyUpdateEvent(TalkSessionBean bean) {
        bean.setTalkFlag(getTalkFlag());
        IMProxySessionEvent.RefreshSessionEvent event = new IMProxySessionEvent.RefreshSessionEvent();
        event.setSessionBean(bean);
        event.setUpdateData(true);
        BusProvider.getInstance().post(event);
    }

    private String getTalkFlag() {
        return mTalkId + "_" + mTalkType;
    }

    @Override
    public void getDraftContent() {
        diskDataStore.getDraftContent(getTalkFlag(), new Subscriber<String>() {
            @Override
            public void onCompleted() {

            }

            @Override
            public void onError(Throwable e) {
                LogUtil.e("ERROR: Get draft content failed.");
            }

            @Override
            public void onNext(String s) {
                isHasDraft = !TextUtils.isEmpty(s);
                vu.setInputContent(s);
            }
        });
    }

    @Override
    public void updateDraftContent(final String draftContent) {
        //先同步时间差
        proxyRepository.getProxyConfig(Constant.KEY_TIME_DIFFERENT)
                .subscribe(new Subscriber<String>() {
                    @Override
                    public void onCompleted() {
                    }

                    @Override
                    public void onError(Throwable e) {
                        LogUtil.e("ERROR: Sync time difference failed." + e.getMessage());
                        long draftTime = System.currentTimeMillis();
                        if (draftContent != null && !TextUtils.isEmpty(draftContent.trim())) {
                            saveDraft(draftContent, draftTime);
                        } else {
                            clearDraft(draftTime);
                        }
                    }

                    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR1)
                    @Override
                    public void onNext(String s) {
                        long draftTime = 0;
                        if (!TextUtils.isEmpty(s) && !s.equals("0")) {
                            try {
                                draftTime = (SystemClock.elapsedRealtimeNanos() + Long.parseLong(s))
                                        / 1000000;
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        draftTime = draftTime > 0 ? draftTime : System.currentTimeMillis();
                        LogUtil.d("Draft: content:" + draftContent + ", time:" + draftTime);
                        if (draftContent != null && !TextUtils.isEmpty(draftContent.trim())) {
                            saveDraft(draftContent, draftTime);
                        } else {
                            clearDraft(draftTime);
                        }
                    }
                });
    }

    @Override
    public void saveDraft(final String draftContent, final long draftTime) {
        diskDataStore.getDraftContent(getTalkFlag(), new Subscriber<String>() {
            @Override
            public void onCompleted() {

            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onNext(String s) {
                if (!TextUtils.isEmpty(draftContent)) {
                    diskDataStore.saveDraftContent(getTalkFlag(), draftContent, draftTime, new Subscriber<Boolean>() {
                        @Override
                        public void onCompleted() {

                        }

                        @Override
                        public void onError(Throwable e) {
                            LogUtil.e("ERROR: save draft failed.");
                        }

                        @Override
                        public void onNext(Boolean aBoolean) {
                            LogUtil.d("Save draft successfully.");

                            //保存草稿失败与否，都退出时，都需要更新会话内容和时间
                            TalkSessionBean updateSessionBean = new TalkSessionBean();
                            SessionParam param = new SessionParam();
                            param.setDraftContent(draftContent);
                            param.setDraftTime(draftTime);
                            updateSessionBean.setParam(param);
                            sendNotifyUpdateEvent(updateSessionBean);
                        }
                    });
                }
            }
        });
    }

    @Override
    public void clearDraft(long draftTime) {
        diskDataStore.clearDraftContent(getTalkFlag(), draftTime, new Subscriber<Boolean>() {
            @Override
            public void onCompleted() {

            }

            @Override
            public void onError(Throwable e) {
                LogUtil.e("ERROR: Clear draft failed. " + e.getMessage());
            }

            @Override
            public void onNext(Boolean aBoolean) {
                LogUtil.d("Clear draft successfully.");
            }
        });

        //如果消息列表不为空，则显示最后一条消息
        TalkSessionBean updateSessionBean = new TalkSessionBean();
        if (!mMessageList.isEmpty()) {
            //清除草稿后，消息不为空
            TalkMessageBean lastMessageBean = mMessageList.get(mMessageList.size() - 1);
            updateSessionBean.setContent(lastMessageBean.getContent());
            updateSessionBean.setLastTime(lastMessageBean.getShowTime());
            updateSessionBean.setLastMsg(lastMessageBean);
        } else {
            //消息为空，则显示草稿时间
            SessionParam param = new SessionParam();
            param.setDraftContent("");
            param.setDraftTime(0L); //无草稿，草稿时间归零
            updateSessionBean.setParam(param);
        }
        sendNotifyUpdateEvent(updateSessionBean);
    }

    @Override
    public void clearUnReadMsgCount() {
        //清除默认的通知栏消息数
        NotificationUtil.getInstance().clearPNNotification();
        //2017-10-30 wangzhen start modify: Fix the bug 22118 of NullPointException
        if (proxyRepository != null) {
            proxyRepository.clearUnReadMsgCount(getTalkFlag(), new Subscriber<Integer>() {
                @Override
                public void onCompleted() {

                }

                @Override
                public void onError(Throwable e) {
                    LogUtil.d("Error:clear unRead msg flag failed.");
                }

                @Override
                public void onNext(Integer integer) {
                    LogUtil.d("clear unRead msg flag successfully.");
                }
            });
        }
    }

    @Override
    public void onLongClickAtUser(int type, String groupId, String account, String userName) {
        if (TextUtils.isEmpty(account) || TextUtils.isEmpty(userName))
            return;
        if (type == ConstDef.CLICK_IMAGE && !userCache.isMine(account)) {
            vu.setInputContent("@" + userName + " ");
        } else {
            LogUtil.d("SetAtTextName account: " + account);
            return;
        }
        AtAccountNickMap.putAccountNick(groupId, account, userName);
    }

    @Override
    public void sendTextMessage(String message) {

        List<String> atAccount = AtAccountNickMap.getAtAccount(message, userCache.get().getAccount());
        if (mTalkType == ConstDef.CHAT_TYPE_P2G && !ObjectUtil.collectionIsEmpty(atAccount)) {
            sendAtTextMessage(message, atAccount);
            return;
        }
        LogUtil.d("send text message:" + message);
        proxyRepository.sendTextMessage(message, mTalkId, isLimit,
                mTalkType == ConstDef.CHAT_TYPE_P2G,
                new Subscriber<TalkMessageBean>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        LogUtil.e("send text error, ERROR:" + e.getMessage());
                    }

                    @Override
                    public void onNext(TalkMessageBean talkMessageBean) {
                        int index = mMessageList.indexOf(talkMessageBean);
                        if (index >= 0) {
                            return;
                        }
                        mMessageList.add(talkMessageBean);
                        buildAdapter().notifyDataSetChanged();
                        //跳转
                        vu.setListSelection(mMessageList.size() - 1);
                    }
                });
    }


    @Override
    public void sendAtTextMessage(String message, List<String> atAccount) {
        proxyRepository.sendAtTextMessage(message, mTalkId, isLimit,
                mTalkType == ConstDef.CHAT_TYPE_P2G,
                atAccount,
                new Subscriber<TalkMessageBean>() {
                    @Override
                    public void onCompleted() {
                    }

                    @Override
                    public void onError(Throwable e) {
                        clearAtAccount();
                        e.printStackTrace();
                    }

                    @Override
                    public void onNext(TalkMessageBean talkMessageBean) {
                        clearAtAccount();
                        int index = mMessageList.indexOf(talkMessageBean);
                        if (index >= 0) {
                            return;
                        }
                        mMessageList.add(talkMessageBean);
                        buildAdapter().notifyDataSetChanged();
                        //跳转
                        vu.setListSelection(mMessageList.size() - 1);
                    }
                });
    }

    public void clearAtAccount() {

        AtAccountNickMap.clearAccountNick();
        AtAccountNickMap.clearAccount(userCache.get().getAccount());
    }

    @Override
    public void sendFileMessage(List<FileInfo> fileList) {
        LogUtil.d("send file message:" + fileList.toString());
        proxyRepository.sendFileMessage(mTalkId, isLimit,
                mTalkType == ConstDef.CHAT_TYPE_P2G, fileList,
                new Subscriber<TalkMessageBean>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        LogUtil.e("send file ERROR:" + e.getMessage());
                    }

                    @Override
                    public void onNext(TalkMessageBean bean) {
                        int index = mMessageList.indexOf(bean);
                        if (index >= 0) {
                            return;
                        }
                        //更新状态
                        mMessageList.add(bean);
                        buildAdapter().notifyDataSetChanged();
                        //跳转
                        vu.setListSelection(mMessageList.size() - 1);
                    }
                });
    }

    @Override
    public void sendVoiceMessage(String path, int seconds) {
        VoiceFileInfo voiceFileInfo = new VoiceFileInfo();
        voiceFileInfo.setAmountOfTime(seconds);
        voiceFileInfo.setFilePath(path);
        voiceFileInfo.setFileName(path.substring(path.lastIndexOf("/") + 1, path.length()));
        voiceFileInfo.setFileSize(FileSizeUtils.getFileSize(path));
        voiceFileInfo.setSuffix("amr");
        voiceFileInfo.setFileType(ConstDef.FILE_TYPE_VOICE);
        //发送文件
        List<FileInfo> fileInfoList = new ArrayList<>();
        fileInfoList.add(voiceFileInfo);
        sendFileMessage(fileInfoList);
    }

    @Override
    public Intent buildIntent(Context context, OptionBean optionBean) {
        Intent intent = new Intent();
        if (!TextUtils.isEmpty(optionBean.getPkgName())) {
            intent.setClassName(optionBean.getPkgName(), optionBean.getClsName());
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        } else {
            intent.setClassName(context.getPackageName(), optionBean.getClsName());
        }

        //params
        Map<String, String> params = optionBean.getParam();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> entity : params.entrySet()) {
                intent.putExtra(entity.getKey(), entity.getValue());
            }
        }
        intent.putExtra(IntentParam.PARAM_SESSION_ID, mTalkId);
        intent.putExtra(IntentParam.PARAM_SESSION_TYPE, mTalkType);
        return intent;
    }

    @Override
    public void startToOptionView(Activity context, int position, OptionBean optionBean) {
        LogUtil.d("startToOptionView:" + optionBean.toString());
        Intent intent = buildIntent(context, optionBean);
        try {
            //捕获异常，防止
            if (optionBean.getRequestCode() > 0) {
                context.startActivityForResult(intent, optionBean.getRequestCode());
            } else {
                context.startActivity(intent);
            }
            //恢复面板状态
            vu.restoreActionState();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleAlbumResult(Intent data) {
        List<ImageThumbBean> thumbBeen = data.getParcelableArrayListExtra(Constant.TAG_PIC_SELECT);
        if (thumbBeen == null || thumbBeen.isEmpty()) {
            LogUtil.e("ERROR: thumb list is null or empty.");
            return;
        }
        List<FileInfo> imageFileInfoList = new ArrayList<>();
        for (ImageThumbBean bean : thumbBeen) {
            FileInfo fileInfo = DataConvertUtils.mapImageFileInfo(bean);
            if (fileInfo != null) {
                imageFileInfoList.add(fileInfo);
            }
        }
        sendFileMessage(imageFileInfoList);
    }

    @Override
    public void handleCameraResult(Intent data) {
        PhotoThumbBean thumbBean = data.getParcelableExtra(Constant.TAG_PHOTO);
        if (thumbBean == null) {
            LogUtil.e("ERROR: thumb list is null or empty.");
            return;
        }
        List<FileInfo> photoFileInfos = new ArrayList<>();
        FileInfo photoFileInfo = DataConvertUtils.mapPhotoFileInfo(thumbBean);
        if (photoFileInfo != null) {
            photoFileInfos.add(photoFileInfo);
        }
        sendFileMessage(photoFileInfos);
    }

    @Override
    public void handleVideoRecorderResult(Intent data) {
        VideoItem videoItem = data.getParcelableExtra(Constant.TAG_VIDEO_RECORDER);
        if (videoItem == null) {
            LogUtil.e("ERROR: videoItem is null.");
            return;
        }
        FileInfo videoFileInfo = DataConvertUtils.mapVideoFileInfo(videoItem);
        List<FileInfo> videoFileInfoList = new ArrayList<>();
        videoFileInfoList.add(videoFileInfo);
        sendFileMessage(videoFileInfoList);
    }

    @Override
    public void handleFileResult(Intent data) {
        List<FileItem> fileItemList = data.getParcelableArrayListExtra(Constant.TAG_FILE_SELECT);
        if (fileItemList == null || fileItemList.isEmpty()) {
            LogUtil.e("ERROR: file list is null or empty.");
            return;
        }
        List<FileInfo> fileInfoList = new ArrayList<>();


        List<FileInfo> videoFileInfoList = new ArrayList<>();

        List<FileInfo> imageFileInfoList = new ArrayList<>();

        FileInfo fileInfo;
        for (FileItem info : fileItemList) {
            fileInfo = new FileInfo();
            fileInfo.setFilePath(info.getFilePath());
            fileInfo.setFileName(info.getFileName());
            fileInfo.setFileSize(info.getFileSize());
            String name = info.getFileName();
            String suffix = ToolUtil.getLastString(name, ".");
            if (!TextUtils.isEmpty(suffix)) {
                fileInfo.setSuffix(suffix);
            }
            fileInfo.setFileType(info.getFileType());
            boolean isImage = IMFileUtils.isImageFileType(name);
            boolean isVideo = IMFileUtils.isVideoFileType(name);

            if (isImage) {
                ImageFileInfo imageFileInfo = DataConvertUtils.mapImagePicFileInfo(fileInfo);
                if (imageFileInfo != null) {
                    imageFileInfoList.add(imageFileInfo);
                }
                continue;
            }

            if (isVideo) {
                FileInfo videoFileInfo = DataConvertUtils.mapVideoFileInfo(fileInfo);
                if (videoFileInfo != null) {
                    videoFileInfo.setFileType(ConstDef.FILE_TYPE_VIDEO);
                    videoFileInfoList.add(videoFileInfo);
                }
                continue;
            }
            fileInfoList.add(fileInfo);
        }

        if (imageFileInfoList.size() != 0) {
//            sendPicFileMessage(imageFileInfoList);
            sendFileMessage(imageFileInfoList);
        }

        if (videoFileInfoList.size() != 0) {
            sendFileMessage(videoFileInfoList);
        }

        if (fileInfoList.size() != 0) {
            sendFileMessage(fileInfoList);
        }
    }

    private void sendPicFileMessage(List<ImageFileInfo> imageFileInfoList) {
        proxyRepository.getImageFileList(imageFileInfoList, ConstDef.FILE_PICTURE).subscribe(new Subscriber<List<FileInfo>>() {
            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                LogUtil.d("create thumbnail failed.");
            }

            @Override
            public void onNext(List<FileInfo> imageFileInfoList) {
                if (imageFileInfoList != null && imageFileInfoList.size() > 0) {
//                    getVu().setListSelection2Last();
                    //获取待发送图片列表，并发送消息
                    sendFileMessage(imageFileInfoList);
                } else {
                    LogUtil.d("create thumbnail failed.");
                }
            }
        });
    }

    @Override
    public void handleFileLoadResult(Intent data) {
        Bundle bundle = data.getExtras();
        if (bundle == null) {
            LogUtil.e("ERROR: hand file load result, bundle is null.");
            return;
        }

        long msgId = bundle.getLong(Constant.TAG_MSGID, -1);
        int state = bundle.getInt(Constant.TAG_FILE_STATE, ConstDef.INACTIVE);
        long translateSize = bundle.getLong(Constant.TAG_FILE_TRANS_SIZE, 0);

        int position = mathMessage(msgId);
        if (position < 0) {
            LogUtil.w("Result file downloadFile code, position:" + position);
            return;
        }

        TalkMessageBean bean = mMessageList.get(position);
        NormalFileInfo fileInfo = (NormalFileInfo) bean.getFileInfo();
        if (fileInfo != null) {
            fileInfo.setTranslateSize(translateSize);
            fileInfo.setFileState(state);
            buildAdapter().updateItem(position, bean);
        }
    }

    /**
     * 事件和消息匹配
     *
     * @param messageId 事件ID
     * @return
     */
    @Override
    public int mathMessage(long messageId) {
        int size = mMessageList.size();
        for (int i = size - 1; i >= 0; i--) {
            if (messageId == mMessageList.get(i).getId()) {
                return i;
            }
        }
        return -1;
    }

    @Override
    public void updateFileInfo(int position, FileInfo fileInfo) {
        if (position < 0 || position > mMessageList.size()) {
            return;
        }
        mMessageList.get(position).setFileInfo(fileInfo);
        buildAdapter().updateItem(position, mMessageList.get(position));
    }

    @Override
    public void updateFileTranslateSize() {
        FileInfo fileInfo;
        for (TalkMessageBean bean : mMessageList) {
            fileInfo = bean.getFileInfo();
            if (fileInfo != null
                    && (bean.getMessageType() == ConstDef.MSG_TYPE_FILE
                    || bean.getMessageType() == ConstDef.MSG_TYPE_VIDEO)
                    && bean.getFileInfo() != null
                    && bean.getFileInfo().getTranslateSize() != 0
                    && bean.getFileInfo().getTranslateSize() != bean.getFileInfo().getFileSize()) {
                TranslateInfoUtil.putInfo(bean.getId(), fileInfo.getTranslateSize());
            }
        }
    }

    @Override
    public void changeMsgState(TalkMessageBean bean) {
        int position = mathMessage(bean.getId());
        if (position < 0) {
            LogUtil.e("ERROR: Change Msg State, position:" + position);
            return;
        }

        TalkMessageBean messageBean = mMessageList.get(position);
        if (messageBean != null) {
            messageBean.setMessageState(bean.getMessageState());
            messageBean.setFailCode(bean.getFailCode());
            messageBean.setContent(bean.getContent());
            buildAdapter().updateItem(position, messageBean);
        }
    }

    @Override
    public void addNewMessageToList(List<TalkMessageBean> talkMessageList) {
        int scrolledX = vu.getListView().getScrollX();
        int scrolledY = vu.getListView().getScrollY();

        mMessageList.addAll(talkMessageList);
        buildAdapter().notifyDataSetChanged();
        int firstVisiblePosition = vu.getListView().getFirstVisiblePosition();
        int lastVisiblePosition = vu.getListView().getLastVisiblePosition();
        if (mMessageList.size() > PAGE_SIZE) {

            if (lastVisiblePosition <= mMessageList.size() - 1
                    && lastVisiblePosition > mMessageList.size() - 1 - PAGE_SIZE) {
                //15条消息之内
                vu.setListSelection(mMessageList.size() - 1);
            } else {
                //15条消息之外
                vu.setListSelection(firstVisiblePosition + 1);
                //vu.scrollTo(scrolledX, scrolledY);
            }
        } else {
            vu.setListSelection(mMessageList.size() - 1);
        }
    }


    @Override
    public void setAtType() {
        if (mTalkType == ConstDef.CHAT_TYPE_P2G) {
            AtPreferencesUtils.getWrapper(ActomaController.getAppConfigContext(), "at").setPreferenceBooleanValue(mTalkId, false);
        }
    }
}
