package com.xdja.im.core.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.event.IMProxyEvent;

/**
 * @Package: com.xdja.im.core.service
 * @Author: xdjaxa
 * @Creation: 2017-09-01 10:45
 * @Version V1.0
 * @Description:
 */
public class DateTimeReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (TextUtils.isEmpty(action)) {
            return;
        }

        if (Intent.ACTION_TIMEZONE_CHANGED.equals(action)) {//时区变化
            notifyRefreshSessionList();
        } else if (Intent.ACTION_DATE_CHANGED.equals(action)) { //日期变化
            notifyRefreshSessionList();
        } else if (Intent.ACTION_TIME_CHANGED.equals(action)) {
            notifyRefreshSessionList();
        }
    }

    /**
     * 通知会话界面更新
     */
    private void notifyRefreshSessionList() {
        IMProxyEvent.DataTimeChangedEvent event =
                new IMProxyEvent.DataTimeChangedEvent();
        BusProvider.getInstance().post(event);
    }
}
