package com.xdja.im.core.utils;

import android.content.Context;
import android.os.Environment;

import com.xdja.http.util.TextUtils;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.UiKitOptions;
import com.xdja.imsdk.util.FileUtils;
import com.xdja.imsdk.util.ToolUtils;

import java.io.File;

/**
 * @Package: com.xdja.im.core.utils
 * @Author: xdjaxa
 * @Creation: 2017-04-12 14:55
 * @Version V1.0
 * @Description:文件路径相关操作类工具类
 */
public class FilePathUtils {

    /**
     * XdjaIm+父目录
     */
    public static final String PATENT_PATH = "XdjaIm";

    /**
     * ImageRec
     */
    public static final String PARENT_IMAGE_RECV = "ImageRec";

    /**
     * VideoRec
     */
    public static final String PARENT_VIDEO_RECV = "VideoRec";

    /**
     * FileRec
     */
    public static final String PARENT_FILE_RECV = "FileRec";

    /**
     * 获取会话标识
     *
     * @param id   对方账号
     * @param type 会话类型
     * @return tag
     */
    public static String getSessionTag(String id, int type) {
        return ToolUtils.getSessionTag(id, type);
    }

    /**
     * 获取分隔符后的字符串
     *
     * @param input     input
     * @param separator separator
     * @return String
     */
    public static String getLastString(String input, String separator) {
        return ToolUtils.getLastString(input, separator);
    }

    /**
     * SDK缓存文件路径/sdcard/appName/
     *
     * @return
     */
    public static String getSdkCacheDir() {
        try {
            //使用第三方指定缓存文件路径
            String cacheDir = UiKitOptions.getOptions().getCacheDir();
            if (!TextUtils.isEmpty(cacheDir)) {
                File parentDir = new File(cacheDir);
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                return parentDir.getAbsolutePath() + File.separator;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        Context context = ImUiKit.getInstance().getContext();
        if (context != null) {
            //使用包名
            return Environment.getExternalStorageDirectory().getAbsolutePath() +
                    File.separator +
                    context.getPackageName() +
                    File.separator;
        } else {
            return Environment.getExternalStorageDirectory().getAbsolutePath() +
                    File.separator;
        }
    }

    /**
     * 获取应用T卡缓存根目录(/sdcard/AppName/XdjaIm/)
     *
     * @return String
     */
    public static String getAppParent() {
        try {
            //使用第三方指定缓存文件路径
            String cacheDir = UiKitOptions.getOptions().getCacheDir();
            if (!TextUtils.isEmpty(cacheDir)) {
                File parentDir = new File(cacheDir);
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                File dir = new File(cacheDir, PATENT_PATH);
                return dir.getAbsolutePath() + File.separator;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return Environment.getExternalStorageDirectory().getAbsolutePath() +
                File.separator +
                PATENT_PATH +
                File.separator;
    }

    /**
     * 图片保存路径(/sdcard/AppName/XdjaIm/ImageRec/)
     * uikit
     *
     * @return
     */
    public static String getImageRecPath() {
        return getAppParent() + PARENT_IMAGE_RECV + File.separator;
    }

    /**
     * 图片保存路径(/sdcard/AppName/XdjaIm/ImageRec/)
     *
     * @return
     */
    public static String getVideoRecPath() {
        return getAppParent() + PARENT_VIDEO_RECV + File.separator;
    }

    /**
     * 文件保存路径(/sdcard/AppName/XdjaIm/FileRec/)
     *
     * @return
     */
    public static String getFileRecPath() {
        return getAppParent() + PARENT_FILE_RECV + File.separator;
    }

    /**
     * 图片缓存目录
     *
     * @return /sdcard/AppName/XdjaIm/.MD5(account)/Image/random1/random2/
     */
    public static String getImagePath() {
        return FileUtils.getImagePath();
    }

    /**
     * 语音缓存存储目录
     *
     * @return /sdcard/AppName/XdjaIm/.MD5(account)/Voice/random1/random2/
     */
    public static String getVoicePath() {
        return FileUtils.getVoicePath();
    }

    /**
     * 短视频缓存目录
     *
     * @return /sdcard/AppName/XdjaIm/.MD5(account)/Video/random1/random2/
     */
    public static String getVideoPath() {
        return FileUtils.getVideoPath();
    }
}
