package com.xdja.im.lib.action;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;

import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.lib.action.adapter.ChatActionAdapter;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.lib.action.listener.IChatActionItemClickListener;
import com.xdja.im.lib.action.recycler.HorizontalPageLayoutManager;
import com.xdja.im.lib.action.recycler.PageScrollHelper;
import com.xdja.im.lib.emoji.EmotionConfig;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.lib.emoji.widget.EmotionGridView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * @Package: com.xdja.im.uikit.view
 * @Author: xdjaxa
 * @Creation: 2017-04-20 19:46
 * @Version V1.0
 * @Description:聊天动作面板
 */
public class ChatActionView extends LinearLayout {

    //单个表情占的长度
    public static final int EMOJI_UNIT_LENGTH = 11;
    /**
     * RecyclerView
     */
    private RecyclerView mActionRv;
    /**
     * 适配器
     */
    private ChatActionAdapter mAdapter;
    /**
     * 帮助类
     */
    private PageScrollHelper mPageScrollHelper;

    /**
     * 表情显示九宫格
     */
    private EmotionGridView mEmotionGv;
    /**
     * 文本输入框
     */
    private EditText mInputEdt;
    /**
     * Option数据
     */
    private List<OptionBean> mOptions = new ArrayList<>();
    /**
     * 表情集合
     */
    private List<String> mEmojis = new ArrayList<>();
    /**
     * 监听器
     */
    private IChatActionItemClickListener mListener;

    /**
     * 设置监听器
     *
     * @param listener 监听器
     */
    public void setChatActionItemClickListener(IChatActionItemClickListener listener) {
        this.mListener = listener;
    }

    public ChatActionView(Context context) {
        this(context, null);
    }

    public ChatActionView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ChatActionView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        initView();
    }

    /**
     * 添加数据
     *
     * @param options
     */
    public void setOptionsData(List<OptionBean> options) {
        this.mOptions.clear();
        this.mOptions.addAll(options);
    }

    /**
     * 控件初始化
     */
    private void initView() {
        View.inflate(getContext(), R.layout.im_uikit_layout_chat_action, this);

        mActionRv = (RecyclerView) findViewById(R.id.recycler_view);
        mEmotionGv = (EmotionGridView) findViewById(R.id.layout_emotion);

        mAdapter = new ChatActionAdapter(getContext(), mOptions, mCallback);
        mActionRv.setAdapter(mAdapter);

        mPageScrollHelper = new PageScrollHelper();
        mPageScrollHelper.setUpRecycleView(mActionRv);

        Math.floor(mOptions.size()/4);

        mActionRv.setLayoutManager(new HorizontalPageLayoutManager(2, 4));
        mPageScrollHelper.updateLayoutManger();


        setListener();
    }

    private ChatActionAdapter.Callback mCallback = new ChatActionAdapter.Callback() {
        @Override
        public void onItemClickListener(int position) {
            if (mListener == null) {
                LogUtil.e("You should set listener first!");
                return;
            }
            mListener.onItemClick(position, mOptions.get(position));
        }
    };

    /**
     * 控件操作监听器
     */
    private void setListener() {
        /*mActionGv.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (mListener == null) {
                    LogUtil.e("You should set listener first!");
                    return;
                }
                mListener.onItemClick(position, mOptions.get(position));
            }
        });*/
        mEmotionGv.setOnFaceGridViewItemClick(new EmotionGridView.OnFaceGridViewItemClick() {

            @Override
            public void onItemClick(int facesPos) {
                if (mInputEdt == null) {
                    return;
                }
                if (mInputEdt.getVisibility() == View.VISIBLE) {
                    if (mInputEdt.getText().length() + EMOJI_UNIT_LENGTH > EmotionConfig.MAX_LENGTH) {
                        CommonTool.showToast(R.string.im_uikit_input_length_warnning);
                        return;
                    }
                    Editable editable = mInputEdt.getEditableText();

                    CharSequence text = EmotionUtils.formatSpanByIndex(getContext(), facesPos,
                            EmotionConfig.FACE_ITEM_NORMAL_VALUE);
                    mEmojis.add(text.toString());
                    editable.insert(mInputEdt.getSelectionStart(), text);//添加至光标处
                }
            }

            @Override
            public void onClear() {
                if (mInputEdt == null) {
                    return;
                }
                deleteSpannableStr();
            }
        });
        this.mEmotionGv.setAdapter();
    }

    public void setAcceptInput(EditText edit) {
        this.mInputEdt = edit;
    }

    /**
     * 操作面板是否可见
     *
     * @param visible
     */
    public void setActionViewVisible(boolean visible) {
        if (visible) {

            //当前操作面板可见
            if (!isShown()) {
                setVisibility(VISIBLE);
            }
            mActionRv.setVisibility(VISIBLE);

            //表情可见时，隐藏表情
            if (mEmotionGv.isShown()) {
                mEmotionGv.setVisibility(GONE);
            }
        } else {
            mActionRv.setVisibility(GONE);
        }
    }

    /**
     * 适合表情是否可见
     *
     * @param visible
     */
    public void setEmojiVisible(boolean visible) {
        if (visible) {
            //当前操作面板可见
            if (!isShown()) {
                setVisibility(VISIBLE);
            }
            mEmotionGv.setVisibility(VISIBLE);

            //表情可见时，隐藏表情
            if (mActionRv.isShown()) {
                mActionRv.setVisibility(GONE);
            }
        } else {
            mEmotionGv.setVisibility(GONE);
        }
    }

    /**
     * 操作面板是否可见
     *
     * @return
     */
    public boolean isActionViewVisible() {
        return mActionRv.isShown();
    }

    /**
     * 表情面板是否可见
     *
     * @return
     */
    public boolean isEmojiVisible() {
        return mEmotionGv.isShown();
    }


    /**
     * 删除光标所有位置的字符，可以是文字或者表情
     */
    private void deleteSpannableStr() {
        // 获取光标的位置
        int cursorIndex = mInputEdt.getSelectionStart();
        if (cursorIndex <= 0) {
            return;
        }
        String content = mInputEdt.getText().toString();
        if (TextUtils.isEmpty(content)) {
            return;
        }

        content = content.substring(0, cursorIndex);
        int leftIndex;
        int rightIndex = content.lastIndexOf("]");
        if (rightIndex != -1 && rightIndex == content.length() - 1) {
            leftIndex = content.lastIndexOf("[");
            if (leftIndex != -1) {
                String temp = content.substring(leftIndex, rightIndex + 1);
                if (mEmojis.contains(temp) && EmotionUtils.mathEmotion(temp)) {
                    mInputEdt.getEditableText().delete(leftIndex, cursorIndex);
                    mEmojis.remove(temp);
                    return;
                }
            }
        }
        leftIndex = cursorIndex - 1;
        mInputEdt.getEditableText().delete(leftIndex, cursorIndex);
    }
}
