package com.xdja.im.lib.filemanage.presenter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

import com.xdja.im.base.di.component.DaggerUserComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.component.UserComponent;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.lib.filemanage.commend.Command;
import com.xdja.im.lib.filemanage.commend.RemindNewMessage;
import com.xdja.im.lib.filemanage.error.OkException;
import com.xdja.im.lib.filemanage.error.OkHandler;
import com.xdja.im.lib.filemanage.util.ActomaContextWrapper;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.view.ActivityVu;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.notification.NotificationUtil;


/**
 * <p>Summary:IMPresenter</p>
 * <p>Description:</p>
 * <p>Package:com.xdja.imp.frame.imp</p>
 * <p>Author:fanjiandong</p>
 * <p>Date:2015/11/3</p>
 * <p>Time:19:08</p>
 */
public abstract class IMActivityPresenter<P extends Command, V extends ActivityVu>
        extends BasePresenterActivity<P, V> {

    protected UserComponent userComponent;

//    protected UseCaseComponent useCaseComponent;

    protected RemindNewMessage remindNewMessage;

    protected UserCache userCache;

    protected OkHandler<OkException> okHandler;

    @SuppressLint("InlinedApi")
    @Override
    protected void preBindView(Bundle savedInstanceState) {
        super.preBindView(savedInstanceState);
        Window window = getWindow();
        window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
        if (getCurrentThemeStyle() == THEME_DARK) {
            window.setStatusBarColor(Color.BLACK);
            setTheme(R.style.im_uikit_ImAppTheme);
            //setTheme(R.style.AppThemeDark);
        } else if (getCurrentThemeStyle() == THEME_LIGHT) {
            View decor = window.getDecorView();
            int ui = decor.getSystemUiVisibility();
            if (Build.VERSION.SDK_INT >= 23) {
                if (isLightStatusBar()) {
                    ui |= View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;
                } else {
                    ui &= ~View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;
                }
                window.setStatusBarColor(getPrimaryColor());
            } else {
                ui &= ~View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;
                window.setStatusBarColor(Color.BLACK);
            }
            decor.setSystemUiVisibility(ui);
            setTheme(R.style.im_uikit_ImAppTheme);
//            setTheme(R.style.AppThemeLight);
        }
    }

    public int getCurrentThemeStyle() {
        return UniversalUtil.getThemeStyle(this);
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(ActomaContextWrapper.wrap(newBase));
    }

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        RepositoryComponent repositoryComponent = ImUiKit.getInstance().getComponent();
        if (repositoryComponent != null) {
            userComponent = DaggerUserComponent.builder()
                    .repositoryComponent(repositoryComponent)
                    .build();
        }
        userCache = repositoryComponent.accountCache();
    }

    @Override
    public void onResume() {
        super.onResume();
        NotificationUtil.getInstance().clearPNNotification();
//        if (userCache != null)
//            userCache.setUserForeground(true);
    }

    @Override
    protected void onPause() {
        super.onPause();
        NotificationUtil.getInstance().clearPNNotification();
//        if (userCache != null)
//            userCache.setUserForeground(false);
    }
}
