package com.xdja.im.lib.filemanage.util;

import android.app.Application;
import android.content.Context;
import android.preference.PreferenceManager;
import android.text.TextUtils;

import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.log.LogUtil;


/**
 * <p>Summary:</p>
 * <p>Description:</p>
 * <p>Package:com.xdja.comm.server</p>
 * <p>Author:fanjiandong</p>
 * <p>Date:2015/7/10</p>
 * <p>Time:9:07</p>
 */
public class ActomaController {
    private static String KEY = "MARK";
    private static String mMark;
    private static int matchResult;

    public static int getMatchResult() {
        return matchResult;
    }

    public static void setMatchResult(int matchResult) {
        ActomaController.matchResult = matchResult;
    }

    public static String getMark() {
        if (TextUtils.isEmpty(mMark) && app != null) {
            mMark = PreferenceManager.getDefaultSharedPreferences(app).getString(KEY, null);
            LogUtil.e("", "getMark -> SharedPreferences : " + mMark);
        }
        return mMark;
    }

    public static void setMark(String mark) {
        if (app != null) {
            LogUtil.e("", "setMark -> SharedPreferences : " + mark);
            PreferenceManager.getDefaultSharedPreferences(app).edit().putString(KEY, mark).commit();
        }
        mMark = mark;
    }
    /**
     * Application单例
     */
    private static Application app;
    private static Context appConfigContext;
    public static void setApp(Application actomaApp) {
        ActomaController.app = actomaApp;
        LogUtil.e("lyq", "setApp"+ActomaController.app);
    }

    public static Context getApp(){
        return ImUiKit.getInstance().getContext();
    }

    public static void setApplicationConfigContext(Context context){
        appConfigContext = ImUiKit.getInstance().getContext();
    }

    public static Context getAppConfigContext(){

       return ImUiKit.getInstance().getContext();
    }

    public static int getFlag() {
        return Flag;
    }

    public static void setFlag(int flag) {
        Flag = flag;
    }

    private static int Flag = 0;

    private static boolean imInitOk = false;

    public static boolean isImInitOk() {
        return imInitOk;
    }

    public static void setImInitOk(boolean imInitOk) {
        ActomaController.imInitOk = imInitOk;
    }
}
