package com.xdja.im.lib.historyfile.adapter;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.view.View;
import android.widget.CheckBox;
import android.widget.ExpandableListView;
import android.widget.ProgressBar;

import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.adapter.BaseFileItemAdapterPresenter;
import com.xdja.im.lib.filemanage.commend.IHistoryFileListAdapterCommand;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.NetworkUtils;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.filemanage.view.AdapterVu;
import com.xdja.im.lib.filemanage.view.ViewHistoryFileTitle;
import com.xdja.im.lib.historyfile.command.ChatDetailAdapterCommand;
import com.xdja.im.lib.historyfile.util.HistoryModeUtils;
import com.xdja.im.lib.historyfile.vu.ViewHistoryFileContent;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.dialog.CustomDialog;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.inject.Inject;

import dagger.Lazy;
import rx.Subscriber;

/**
 * 项目名称：ActomaV2
 * 类描述：
 * 创建人：xdjaxa
 * 创建时间：2016/12/14 21:01
 * 修改人：xdjaxa
 * 修改时间：2016/12/14 21:01
 * 修改备注：
 */
public class HistoryFileAdapterPresenter extends BaseFileItemAdapterPresenter<IHistoryFileListAdapterCommand,TalkMessageBean>
        implements IHistoryFileListAdapterCommand{

    private ExpandableListView listView;

//    @Inject
//    Lazy<DownloadFile> downloadFile;

    @Inject
    Lazy<ProxyRepository> proxyRepository;

//    @Inject
//    Lazy<PauseReceiveFile> pauseReceiveFile;
//
//    @Inject
//    Lazy<ResumeReceiveFile> resumeReceiveFile;

    BusProvider busProvider;

//    @Inject
//    Lazy<ChangeMsgState> changeMsgState;

    private Activity mActivity;

    private final UserCache userCache;

    private int mCurrentOperate;

    public HistoryFileAdapterPresenter(Context context, BusProvider busProvider,
                                       Map<HistoryFileCategory,List<TalkMessageBean>> datas,
                                       UserCache userCache){
        mContext = context;
        mDatas = datas;
        this.busProvider = busProvider;
        this.userCache = userCache;
        this.busProvider.register(this);

    }

    @Override
    public List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, TalkMessageBean>>> getVuClasses() {
        if(mVuClass == null){
            mVuClass = new ArrayList<>();
            mVuClass.add(ViewHistoryFileContent.class);
        }

        return mVuClass;
    }

    @Override
    public List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, String>>> getGroupVuClasses() {
        if(mGroupVuClass == null) {
            mGroupVuClass = new ArrayList<>();
            mGroupVuClass.add(ViewHistoryFileTitle.class);
        }
        return mGroupVuClass;
    }

    @Override
    public IHistoryFileListAdapterCommand getCommand() {
        return this;
    }

    @Override
    public void notifyDataSetChanged() {
        mTitles = new ArrayList<>(mDatas.keySet());
        super.notifyDataSetChanged();
    }

    @Override
    public void sendReadReceipt(final TalkMessageBean talkMessageBean) {
        proxyRepository.get().changeMessageState(talkMessageBean, ConstDef.STATE_READED, new Subscriber<Integer>() {
            @Override
            public void onCompleted() {

            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onNext(Integer integer) {
                if (integer == 0) {
                    LogUtil.d("", "消息已读状态更改成功");
                    for (Map.Entry<HistoryFileCategory, List<TalkMessageBean>> entry : mDatas.entrySet()) {
                        for (TalkMessageBean bean : entry.getValue()) {
                            if (bean.getId() == talkMessageBean.getId()) {
                                bean.setMessageState(ConstDef.STATE_READED);
                                notifyDataSetChanged();
                            }
                        }
                    }
                } else {
                    LogUtil.d("", "消息已读状态更改失败");
                }
            }
        });
    }

    public void updateMode(int operateAction) {
        mCurrentOperate = operateAction;
        Iterator iterator = mDatas.keySet().iterator();
        while (iterator.hasNext()) {
            HistoryFileCategory historyFileCategory = (HistoryFileCategory) iterator.next();
            List<TalkMessageBean> talkMessageBeanList = mDatas.get(historyFileCategory);
            Iterator it = talkMessageBeanList.iterator();
            while (it.hasNext()) {
                TalkMessageBean bean = (TalkMessageBean) it.next();
                if (mCurrentOperate == ConstDef.FILE_OPERATE_TRANSMIT) {
                    if (bean.getFileInfo().getFileState() != ConstDef.DONE) {
                        it.remove();
                        continue;
                    }
                } else if (mCurrentOperate == ConstDef.FILE_OPERATE_DOWNLOAD) {
                    if (bean.getFileInfo().getFileState() == ConstDef.DONE ||
                            DateUtils.isOverdue(bean.getShowTime())) {
                        it.remove();
                        continue;
                    }
                }
                bean.setFileOperate(mCurrentOperate);
                if (mCurrentOperate != 0) {
                    bean.setChecked(false);
                }
            }
            if(talkMessageBeanList.isEmpty()) {
                iterator.remove();
            }
        }
        notifyDataSetChanged();
    }

    @Override
    public void clickToDownloadOfOpen(TalkMessageBean bean) {
        FileInfo fileInfo = bean.getFileInfo();

        boolean isExist = HistoryFileUtils.isFileExist(bean);

        if (!isExist && DateUtils.isOverdue(bean.getShowTime())) {
            new XToast(getActivity()).display(getActivity().getString(R.string.im_uikit_history_select_all_overdue));
            return;
        }

        int state = fileInfo.getFileState();
        List<FileInfo> fileInfos = new ArrayList<>();
        fileInfos.add(fileInfo);

        if(state == ConstDef.PAUSE){
            proxyRepository.get().pauseFileReceiving(fileInfo, new Subscriber<Integer>() {
                @Override
                public void onCompleted() {

                }

                @Override
                public void onError(Throwable e) {

                }

                @Override
                public void onNext(Integer integer) {
                    if (integer == 0) {
                        LogUtil.d("","zhu->暂停下载文件");
                    }
                }
            });
        } else if(state == ConstDef.LOADING || state == ConstDef.FAIL){
            showDialog(fileInfos);
        } else {
            if(isExist){
                HistoryFileUtils.intentBuilder(getActivity(),bean.getFileInfo().getFilePath(), bean.getFileInfo().getSuffix());
            } else {
                new XToast(getActivity()).display(getActivity().getString(R.string.im_uikit_history_send_file_not_exist));
            }
        }
    }

    public void showDialog(final List<FileInfo> fileInfos){
        int networkType = NetworkUtils.obtainCurrentNetworkState(mActivity);//getNetworkState(this);
        if (networkType == NetworkUtils.WIFI) {
            resumeOrDownloadFiles(fileInfos);
        } else if(networkType == NetworkUtils.MOBILE_NETWORK){
            //检测是否为2G/3G/4G网络
            final CustomDialog dialog = new CustomDialog(mActivity, new CustomDialog.OnCloseListener() {
                @Override
                public void onClick(Dialog dialog, boolean confirm) {
                    if (confirm){
                        resumeOrDownloadFiles(fileInfos);
                    } else {
                        if(fileInfos.size() == 1){
                            //重新刷新回来
                            FileInfo fileInfo = fileInfos.get(0);
                            long msgId = fileInfo.getTalkMessageId();
                            if(fileInfo.getTranslatePercent() > 0){
                                fileInfo.setFileState(ConstDef.PAUSE);
                            } else {
                                fileInfo.setFileState(ConstDef.INACTIVE);
                            }
                            updateOneItem(msgId);
                        }//end by zya
                    }
                }
            });
            dialog.setDialogTitle(R.string.im_uikit_download_file_title)
                    .setDialogContent(R.string.im_uikit_download_file_net_type)
                    // 设置内容
                    .setPositiveButton(mActivity.getString(R.string.im_uikit_download_file_btn_continue))
                    .setNegativeButton(mActivity.getString(R.string.im_uikit_download_file_btn_cancel))
                    .show();
        }
    }

    private void resumeOrDownloadFiles(List<FileInfo> fileInfos){
        if(fileInfos.get(0).getTranslatePercent() == 0){
            proxyRepository.get().downloadFile(fileInfos, new Subscriber<Integer>() {
                @Override
                public void onCompleted() {

                }

                @Override
                public void onError(Throwable e) {

                }

                @Override
                public void onNext(Integer integer) {
                    if (integer == 0) {
                        LogUtil.d("","zhu->开始下载文件");
                    }
                }
            });
        } else {
            proxyRepository.get().resumeFileReceive(fileInfos.get(0), new Subscriber<Integer>() {
                @Override
                public void onCompleted() {

                }

                @Override
                public void onError(Throwable e) {

                }

                @Override
                public void onNext(Integer integer) {
                    if (integer == 0) {
                        LogUtil.d("","zhu->恢复下载文件");
                    }
                }
            });
        }
    }

    public void refreshItem(long msgId) {
        updateItem(getCategoryPosition(msgId),msgId);
    }

    private int getCategoryPosition(long msgId) {
        TalkMessageBean msgBean = getTalkMessageBean(msgId);

        int groupPosition = -1;
        if(msgBean != null){
            String categoryId = msgBean.getCategoryId();
            HistoryFileCategory category = new HistoryFileCategory();
            category.setCategoryId(categoryId);
            groupPosition = mTitles.indexOf(category);
        }
        return groupPosition;
    }

    private TalkMessageBean getTalkMessageBean(long msgId){
        TalkMessageBean msgBean = null;
        for(Map.Entry<HistoryFileCategory,List<TalkMessageBean>> entry : mDatas.entrySet()){
            for(TalkMessageBean bean : entry.getValue()){
                if(msgId == bean.getId()){
                    msgBean = bean;
                }
            }
        }
        return msgBean;
    }

    public void updateOneItem(long msgId){
        int position = getCategoryPosition(msgId);

        HistoryFileCategory cate = mTitles.get(position);

        List<TalkMessageBean> beans = mDatas.get(cate);
        TalkMessageBean tBean = new TalkMessageBean();
        tBean.setId(msgId);

        int childPosition = beans.indexOf(tBean);
        if(childPosition > -1){
            //匹配到子View
            if(position == 0 && listView.isGroupExpanded(0)){
                int firstVisiblePos = listView.getFirstVisiblePosition();
                if(childPosition + 1 < firstVisiblePos){
                    return ;
                }

                int aPos = childPosition - firstVisiblePos  + 1;
                LogUtil.d("","zhu->childPos:" + childPosition + ",firstPos:" + firstVisiblePos + ",aPos:" + aPos);

                View childView = listView.getChildAt(aPos);
                if(childView != null) {
                    AdapterVu<ChatDetailAdapterCommand, TalkMessageBean> tag = (AdapterVu<ChatDetailAdapterCommand,TalkMessageBean>)childView.getTag();
                    tag.bindDataSource(position,beans.get(childPosition));
                }
            }
        }
    }

    @Override
    public void updateItem(int position,long msgId) {
        if(position < 0){
            return ;
        }
        //fix bug 7809 by zya 20170104
        HistoryFileCategory cate = mTitles.get(position);

        List<TalkMessageBean> beans = mDatas.get(cate);
        TalkMessageBean tBean = new TalkMessageBean();
        tBean.setId(msgId);

        int childPosition = beans.indexOf(tBean);
        if(childPosition > -1){
            int childCount = listView.getChildCount();
            //匹配到子View
            if(position == 0 && listView.isGroupExpanded(0)){
                int firstVisiblePos = listView.getFirstVisiblePosition();
                if(childPosition + 1 < firstVisiblePos){
                    return ;
                }

                int aPos = childPosition - firstVisiblePos  + 1;
                LogUtil.d("","zhu->childPos:" + childPosition + ",firstPos:" + firstVisiblePos + ",aPos:" + aPos);

                View childView = listView.getChildAt(aPos);
                if(childView != null) {
                    ProgressBar pb = (ProgressBar) childView.findViewById(R.id.pb_file_download);
                    View mFileDateLayout = childView.findViewById(R.id.layout_history_date_from);
                    pb.setVisibility(View.VISIBLE);
                    mFileDateLayout.setVisibility(View.GONE);
                    pb.setProgress(beans.get(childPosition).getFileInfo().getTranslatePercent());
                }
            }
        }
        //end by zya
    }

    @Override
    public void toRefreshSelectHint() {
        IMProxyMessageEvent.HistoryRefreshSelectHintEvent event = new IMProxyMessageEvent.HistoryRefreshSelectHintEvent();
        busProvider.post(event);
    }

    @Override
    public void toRefreshSelectHint(FileItem localFileInfo) {

    }

    @Override
    public void onClickItem(View v, int groupPosition, TalkMessageBean bean) {
        if (bean.hasFileOperate()) {
            CheckBox checkBox = (CheckBox) v.getTag(R.id.history_file_select);
            if (checkBox == null) {
                return;
            }
            if (HistoryModeUtils.getInstance().getSelectedFileCount() >= 9 && !checkBox.isChecked() &&
                    mCurrentOperate != ConstDef.FILE_OPERATE_DELETE) {
                new XToast(mContext).display(String.format(mContext.getString(R.string.im_uikit_select_file_hint), 9));
                return;
            }
            checkBox.setChecked(!checkBox.isChecked());
        } else {
            clickToDownloadOfOpen(bean);
        }
    }

    @Override
    public void longClickOnItem(int groupPosition,TalkMessageBean bean) {
        if(mItemLongClickListener != null){
            mItemLongClickListener.itemLongClick(groupPosition,bean);
        }
    }

    @Override
    public AccountBean getAccountBean(String account) {
        return IMUiKitProxyImpl.getInstance().getAccount(account, ConstDef.CHAT_TYPE_P2P);
    }

    @Override
    public AccountBean getGroupMemberInfo(String groupId, String account) {
        return IMUiKitProxyImpl.getInstance().getAccount(account, ConstDef.CHAT_TYPE_P2G);
    }

    public void setListView(ExpandableListView listView){
        this.listView = listView;
    }

    public void setActivity(Activity activity){
        mActivity = activity;
    }

    @Override
    public Activity getActivity() {
        return mActivity;
    }

    private List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand,String>>> mGroupVuClass = null;

    private List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, TalkMessageBean>>> mVuClass = null;

    private ItemLongClickListener mItemLongClickListener;

    public interface ItemLongClickListener{
        void itemLongClick(int groupPosition, TalkMessageBean bean);
    }

    public void setItemLongClickListener(ItemLongClickListener listener){
        mItemLongClickListener = listener;
    }

    public void onDestroy(){
        if (null != busProvider) {
            //注销事件总线回调
            busProvider.unregister(this);
        }
        HistoryModeUtils.getInstance().clearCache();
    }
}

