package com.xdja.im.lib.video.palyer;

/**
 * @Package: com.xdja.im.lib.video.palyer
 * @Author: xdjaxa
 * @Creation: 2017-05-15 17:51
 * @Version V1.0
 * @Description:播放状态
 */
public enum VideoPlayState {
    DEFAULT(0, "Default"),
    //打开播放器
    OPEN(1, "Default"),
    //播放中
    PLAY(2, "Play"),
    //暂停播放
    PAUSE(3, "Pause"),
    //停止播放
    STOP(4, "Stop"),
    //播放完成
    COMPLETION(5, "Completion"),
    //播放错误
    ERROR(6, "Error"),
    //播放异常
    EXCEPTION(7, "Exception");

    private final int key;

    private final String description;

    VideoPlayState(int key, String description) {
        this.key = key;
        this.description = description;
    }

    public int getKey() {
        return key;
    }

    public String getDescription() {
        return description;
    }
}
