package com.xdja.im.uikit.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;

import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.adapter.BaseListAdapter;

import java.util.ArrayList;
import java.util.List;

/**
 * @Package: com.xdja.im.uikit.view.popup
 * @Author: xdjaxa
 * @Creation: 2017-05-07 16:34
 * @Version V1.0
 * @Description: 列表Dialog
 */
public abstract class BaseListDialog extends Dialog {

    private ListView mListView;

    private BaseListAdapter mAdapter;

    private List<ImOption> mOptions = new ArrayList<>();

    private onItemClickListener onItemClickListener;

    private int mItemPosition;

    public void setOnItemClickListener(onItemClickListener listener) {
        this.onItemClickListener = listener;
    }

    public BaseListDialog(@NonNull Context context) {
        super(context, R.style.im_uikit_BaseDialogStyle);
        setContentView(R.layout.im_uikit_dialg_option_list);

        setCancelable(true);

        initView();
    }

    private void initView() {

        mListView = (ListView) findViewById(R.id.lv_options);

        mAdapter = new BaseListAdapter(mOptions);
        mListView.setAdapter(mAdapter);
        mListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (onItemClickListener != null) {
                    ImOption option = mOptions.get(position);
                    onItemClickListener.onItemClick(view, option, mItemPosition);
                }
            }
        });
        addData(getOptions());
    }

    /**
     * 添加Item数据
     *
     * @param options
     */
    public void addData(List<ImOption> options) {
        if (options == null || options.size() == 0) {
            return;
        }
        mOptions.clear();
        mOptions.addAll(options);
    }

    /**
     * 显示Dialog
     *
     * @param position
     */
    public void show(int position) {
        super.show();
        mItemPosition = position;
    }

    public interface onItemClickListener {
        /**
         * item点击事件回调
         *
         * @param view         当前点击view
         * @param option       选项属性
         * @param itemPosition dialog关联item位置
         */
        void onItemClick(View view, ImOption option, int itemPosition);
    }

    public abstract List<ImOption> getOptions();
}
