package com.xdja.im.uikit.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AbsListView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.lib.action.ChatActionView;
import com.xdja.im.lib.action.ChatInputView;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.lib.action.listener.IChatActionCallback;
import com.xdja.im.lib.action.listener.IChatActionItemClickListener;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImFragmentSuperView;
import com.xdja.im.uikit.ui.adapter.ChatListAdapter;
import com.xdja.im.uikit.ui.presenter.ChatListPresenter;
import com.xdja.im.uikit.ui.view.vu.ChatListVu;
import com.xdja.im.uikit.utils.FunctionUtils;
import com.xdja.im.uikit.utils.NetworkHelper;
import com.xdja.im.uikit.utils.SpUtils;
import com.xdja.im.uikit.view.KeyboardLayout;

import java.util.List;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-19 14:58
 * @Version V1.0
 * @Description: 聊天列表界面
 */
public class ViewChatList extends ImFragmentSuperView<ChatListPresenter> implements ChatListVu {

    private final static String TAG = "ViewChatList";

    private KeyboardLayout mRootLayout;

    private RelativeLayout mContentLayout;

    /**
     * 消息列表控件
     */
    private ListView mChatListView;
    /**
     * 操作输入控件
     */
    private ChatInputView mChatInputView;

    /**
     * 消息操作面板
     */
    private ChatActionView mChatActionView;

    /**
     * 下拉刷新组件
     */
    private SwipeRefreshLayout swipeRefreshLayout;

    /**
     * 键盘
     */
    private InputMethodManager inputMethodManager;

    /**
     * 网络状态组件
     *
     * @return
     */
    private LinearLayout networkStateLineaLayout;
    /**
     * 网络状态显示组件
     *
     * @return
     */
    private TextView networkStateTv;


    private RelativeLayout im_uikit_meeting_tips_layout;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_chat_list;
    }

    @Override
    protected int getToolbarType() {
        return ToolbarDef.NAVIGATE_BACK;
    }

    @Override
    protected void injectView() {
        super.injectView();

        mRootLayout = (KeyboardLayout) findViewById(R.id.root_layout);
        mContentLayout = (RelativeLayout) findViewById(R.id.content_layout);

        mChatListView = (ListView) findViewById(R.id.lv_message_list);
        mChatInputView = (ChatInputView) findViewById(R.id.layout_chat_operate);
        mChatActionView = (ChatActionView) findViewById(R.id.layout_chat_action);
        swipeRefreshLayout = (SwipeRefreshLayout) findViewById(R.id.swipe_container);
        networkStateLineaLayout = (LinearLayout) findViewById(R.id.network_state_view);
        networkStateTv = (TextView) findViewById(R.id.networkstate_tv);

        im_uikit_meeting_tips_layout = (RelativeLayout) findViewById(R.id.im_uikit_meeting_tips_layout);
        im_uikit_meeting_tips_layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().addMeeting();
            }
        });
    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        inputMethodManager = ((InputMethodManager) getActivity().getSystemService(Context.INPUT_METHOD_SERVICE));

        swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                getPresenter().downRefreshList();
            }
        });
        registerInputCallback();

        mRootLayout.setActivity(getActivity());
        mChatActionView.setAcceptInput(mChatInputView.getInputEdt());

        initChatListListView();

        setNavigateCallback(new onNavigateCallback() {
            @Override
            public void onBackClick() {
                //getActivity().finish();
            }

            @Override
            public void onAddClick() {
                getPresenter().startSetting();
            }
        });
    }

    @Override
    public void setToolBarVisibility(int visibility) {
        supportActionBar(visibility == View.VISIBLE);
    }

    @Override
    public void setToolBarAddVisibility(int visibility) {
        setToolBarAddVisible(visibility == View.VISIBLE);
    }

    @Override
    public void setTitle(String title) {
        if (isSupportActionBar()) {
            setToolBarTitle(title);
        }
    }

    @Override
    public void setAdapter(ChatListAdapter adapter) {
        mChatListView.setAdapter(adapter);
        adapter.notifyDataSetChanged();
    }

    @Override
    public void setOptions(List<OptionBean> options) {
        if (mChatActionView != null) {
            mChatActionView.setOptionsData(options);
        }
    }

    @Override
    public ListView getListView() {
        return mChatListView;
    }

    @Override
    public String getInputContent() {
        return mChatInputView.getInputText();
    }

    @Override
    public void setInputContent(String content) {
        if (!TextUtils.isEmpty(content)) {
            mChatInputView.setIsDraft(true);
        }
        mChatInputView.setInputText(content);
    }

    @Override
    public boolean isRefreshing() {
        return swipeRefreshLayout.isRefreshing();
    }

    @Override
    public void stopRefresh() {
        swipeRefreshLayout.setRefreshing(false);
    }

    @Override
    public void setListSelection(int selection) {
        if (mChatListView != null) {
            mChatListView.setSelection(selection);
        }
    }

    @Override
    public void scrollTo(int x, int y) {
        if (mChatActionView != null) {
            mChatListView.scrollTo(x, y);
        }
    }

    /**
     * 消息输入回调
     * 尽量的少操作ChatInputView自身的控件，重点进行逻辑处理
     */
    private void registerInputCallback() {
        mChatInputView.registerActionViewCallBack(new IChatActionCallback() {
            @Override
            public void onVirtualViewCallBack() {

            }

            @Override
            public void onMoreCheckChanged() {

                if (mChatActionView.isActionViewVisible()) {
                    hideActionView(false);
                    restoreActionState();
                } else {

                    showActionView();
                    mChatInputView.setMoreState(true);
                    mChatActionView.setActionViewVisible(true);
                }
            }

            @Override
            public void onShanCheckChanged() {

                //闪信
                //getPresenter().setLimitFlagFromView(isChecked);
                //mChatActionView.updateGrid(isChecked);

                //表情
                if (mChatActionView.isEmojiVisible()) {
                    hideActionView(true);
                    restoreActionState();

                    setEditTextFocus(true);
                } else {
                    showActionView();
                    mChatInputView.setShanState(true);
                    mChatActionView.setEmojiVisible(true);
                }
            }

            @Override
            public void onInputCheckChanged(boolean isChecked) {

                //isChecked false 语音  true 文字
                if (isChecked) {
                    if (mChatActionView.isShown()) {
                        hideActionView(true);
                    }
                } else {
                    if (mRootLayout.isSoftInputShown()) {
                        hideSoftInputView();
                    }
                    if (mChatActionView.isShown()) {
                        hideActionView(false);
                    }
                    restoreActionState();
                }
            }

            @Override
            public void onSendTextCallBack() {
                String content = mChatInputView.getInputText();
                if (TextUtils.isEmpty(content.trim())) {
                    CommonTool.showToast(R.string.im_uikit_content_cannot_null);
                    return;
                }

                if (getPresenter().sendTextMessage(content)) {
                    mChatInputView.setInputText("");
                }
            }

            @Override
            public void onInputEareTouchCallBack() {

                if (mChatActionView.isShown()) {
                    restoreActionState();
                }
                if (mChatListView.getTranscriptMode() != AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
                    mChatListView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL);
                }
            }

            @Override
            public void onRecorderFinish(int seconds, String filePath) {
                getPresenter().sendVoiceMessage(filePath, seconds);
            }
        });

        mChatActionView.setChatActionItemClickListener(new IChatActionItemClickListener() {
            @Override
            public void onItemClick(int position, OptionBean optionBean) {
                // TODO: 2017/7/12
                if (optionBean.getId() == 5 || optionBean.getId() == 6) {
                    getPresenter().startVoice(position, optionBean);
                } else if (optionBean.getId() == 8) {
                    getPresenter().startLocation(position, optionBean);
                } else if (optionBean.getId() == 7) {
                    getPresenter().startCallback(position, optionBean);
                } else {
                    getPresenter().startToOptionView(position, optionBean);
                }
            }
            /*@Override
            public void onItemClick(int position, @ActionMode.ACTION int action) {
                switch (action) {
                    case ActionMode.ACTION_EMOTION:
                        mChatActionView.setEmojiVisible(!mChatActionView.isEmojiVisible());
                        break;
                    case ActionMode.ACTION_IMAGE:
                        getPresenter().startToAlbum();
                        break;
                    case ActionMode.ACTION_CAMERA:
                        getPresenter().startToCamera();
                        break;
                    case ActionMode.ACTION_VIDEO:
                        getPresenter().startToVideo();
                        break;
                    case ActionMode.ACTION_FILE:
                        getPresenter().startToFileExplorer();
                        break;
                }
            }*/
        });
    }

    /**
     * 添加显示列表的监听事件
     */
    private void initChatListListView() {
        mChatListView.setOnTouchListener(new View.OnTouchListener() {
            @SuppressLint("ClickableViewAccessibility")
            @Override
            public boolean onTouch(View v, MotionEvent event) {

                if (mChatActionView.isShown()) {
                    restoreActionState();
                    return true;
                }
                mChatListView.setFocusable(true);
                displayInputKeyBoard(false);
                return false;
            }
        });
        mChatListView.setOnScrollListener(new AbsListView.OnScrollListener() {

            @Override
            public void onScrollStateChanged(AbsListView view, int scrollState) {
//                if (scrollState == AbsListView.OnScrollListener.SCROLL_STATE_IDLE) {
//                    int firstVisibleItem = mChatListView.getFirstVisiblePosition();
//                    int endVisibleItem = mChatListView.getLastVisiblePosition();
//                    getPresenter().listScroll(firstVisibleItem, endVisibleItem);
//                }
            }

            @Override
            public void onScroll(AbsListView view, int firstVisibleItem,
                                 int visibleItemCount, int totalItemCount) {
                mChatListView.setFocusable(true);
            }
        });
    }

    /**
     * 显示或者隐藏EditText对应的软键盘
     *
     * @param isShow 显示或者隐藏
     */
    public void displayInputKeyBoard(boolean isShow) {
        setEditTextFocus(isShow);
        if (!isShow) {
            inputMethodManager.hideSoftInputFromWindow(mChatInputView.getInputEdt().getWindowToken(), 0);
            if (mChatListView.getTranscriptMode() == AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
                mChatListView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_NORMAL);
            }
        } else {
            inputMethodManager.toggleSoftInput(0, InputMethodManager.HIDE_NOT_ALWAYS);
        }
    }

    /**
     * 设置EditText对应的焦点
     *
     * @param isShow 获取焦点或者是去焦点
     */
    private void setEditTextFocus(boolean isShow) {
        if (isShow) {
            mChatInputView.getInputEdt().setFocusable(true);
            mChatInputView.getInputEdt().setFocusableInTouchMode(true);
            mChatInputView.getInputEdt().requestFocus();
        } else {
            mChatInputView.getInputEdt().setFocusable(false);
        }
    }

    /**
     * 重置action面板状态
     */
    @Override
    public void restoreActionState() {
        mChatActionView.setVisibility(View.GONE);
        mChatInputView.setShanState(false);
        mChatInputView.setMoreState(false);
        if (mChatListView.getTranscriptMode() == AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
            mChatListView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_NORMAL);
        }
    }

    @Override
    public void setTalkType(int talkType) {
        if (mToolbarAdd != null) {
            if (talkType == ConstDef.CHAT_TYPE_P2P) {
                mToolbarAdd.setImageResource(R.mipmap.im_uikit_ic_toolbar_add);
                mChatInputView.setChatType(talkType);
            } else if (talkType == ConstDef.CHAT_TYPE_P2G) {
                mToolbarAdd.setImageResource(R.mipmap.im_uikit_ic_toolbar_add_p2g);
                mChatInputView.setChatType(talkType);
            }
        }
    }

    @Override
    public void setChatMeet(String talkFlag){
        if (SpUtils.getInstance().getBoolean(SpUtils.meetChat) && talkFlag.equals(SpUtils.getInstance().getString(SpUtils.meetTalkFlag)))
            im_uikit_meeting_tips_layout.setVisibility(View.VISIBLE);
        else im_uikit_meeting_tips_layout.setVisibility(View.GONE);
    }

    /**
     * 显示控制面板
     */
    public void showActionView() {

        if (mRootLayout.isSoftInputShown()) {
            lockContentViewHeight();
            hideSoftInputView();
            restoreActionState();
            unlockContentViewHeightDelayed();
        }

        if (mChatListView.getTranscriptMode() != AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
            mChatListView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL);
        }
        mChatActionView.setVisibility(View.VISIBLE);
        mChatInputView.switchToInputEdt(true);
    }

    /**
     * 隐藏控制面板，并根据参数进行输入法的显示
     *
     * @param isShowSoftInputView
     */
    public void hideActionView(boolean isShowSoftInputView) {
        if (mChatActionView.isShown()) {
            mChatActionView.setVisibility(View.GONE);
            if (mChatListView.getTranscriptMode() == AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
                mChatListView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_NORMAL);
            }
            if (isShowSoftInputView) {
                showSoftInputView();
            }
        }
    }

    /**
     * 固定控制面板之外的内容布局的高度
     */
    public void lockContentViewHeight() {
        LinearLayout.LayoutParams params = getLayoutParamsForContent();
        params.height = mContentLayout.getHeight() + 200;
        params.weight = 0;
    }

    /**
     * 释放掉控制面板之外的内容布局的高度
     */
    public void unlockContentViewHeightDelayed() {
        mChatInputView.getInputEdt().postDelayed(new Runnable() {
            @Override
            public void run() {
                LinearLayout.LayoutParams params = getLayoutParamsForContent();
                params.weight = 1;
                mContentLayout.invalidate();
            }
        }, 200);
    }

    /**
     * 获取控制面板之外的内容布局的布局参数
     *
     * @return
     */
    private LinearLayout.LayoutParams getLayoutParamsForContent() {
        return (LinearLayout.LayoutParams) mContentLayout.getLayoutParams();
    }

    /**
     * 显示输入法
     */
    private void showSoftInputView() {
        final EditText et = mChatInputView.getInputEdt();
        et.requestFocus();
        et.post(new Runnable() {
            @Override
            public void run() {
                inputMethodManager.showSoftInput(et, 0);
            }
        });
    }

    /**
     * 隐藏输入法
     */
    private void hideSoftInputView() {
        inputMethodManager.hideSoftInputFromWindow(mChatInputView.getInputEdt().getWindowToken(), 0);
    }

    @Override
    public void changeViewSate(int state) {
        changeNetworkViewState(state);
        if (!NetworkHelper.getHelper().isFirstNotice()
                && FunctionUtils.isAppOnForeground(getActivity())) {
            if (state == NetworkHelper.NET_DISABLED) {
                Toast.makeText(getActivity(), "Network unavailable", Toast.LENGTH_LONG).show();
            } else if (state == NetworkHelper.NO_SERVER) {
                Toast.makeText(getActivity(), "Unable to access the server", Toast.LENGTH_LONG).show();
            }
        }
    }

    @Override
    public void setMeetState(boolean isShow, int talkType) {
        if (isShow && talkType == ConstDef.CHAT_TYPE_P2G) {
            im_uikit_meeting_tips_layout.setVisibility(View.VISIBLE);
        } else {
            im_uikit_meeting_tips_layout.setVisibility(View.GONE);
        }
    }

    /**
     * 网络状态监测
     */
    private void changeNetworkViewState(int flag) {
        String tips;
        switch (flag) {
            case NetworkHelper.NET_DISABLED:
                tips = getActivity().getResources().getString(R.string.im_uikit_network_disabled);
                networkStateTv.setText(tips);
                networkStateLineaLayout.setVisibility(View.VISIBLE);
                break;
            case NetworkHelper.NO_SERVER:
                tips = getActivity().getResources().getString(R.string.im_uikit_network_no_server);
                networkStateTv.setText(tips);
                networkStateLineaLayout.setVisibility(View.VISIBLE);
                break;
            case NetworkHelper.NET_OK:
                networkStateLineaLayout.setVisibility(View.GONE);
                break;
            default:
                break;
        }
    }
}
