package com.xdja.im.uikit.ui.view;

import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.xdja.im.base.frame.view.ActivitySuperBaseView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.adapter.FilePreviewAdapter;
import com.xdja.im.uikit.ui.presenter.FilePreviewPresenter;
import com.xdja.im.uikit.ui.view.vu.FilePreviewVu;

/**
 * @Package: com.xdja.im.uikit.ui.view
 * @Author: xdjaxa
 * @Creation: 2017-05-15 10:27
 * @Version V1.0
 * @Description:
 */
public class ViewFilePreview extends ActivitySuperBaseView<FilePreviewPresenter>
        implements FilePreviewVu {

    /**
     * ViewPager
     */
    private ViewPager mViewPager;
    /**
     * 加载进度
     */
    private ProgressBar mLoadingPbar;
    /**
     * 为空提示文本控件
     */
    private TextView mEmptyTv;
    /**
     * 适配器
     */
    private FilePreviewAdapter mPagerAdapter;
    /**
     * 当前位置
     */
    private int mCurPos;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_file_preview;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mViewPager = (ViewPager) findViewById(R.id.pager_file_preview);
        mLoadingPbar = (ProgressBar) findViewById(R.id.pbar_loading);
        mEmptyTv = (TextView) findViewById(R.id.tv_empty);

        mViewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {

            }

            @Override
            public void onPageScrollStateChanged(int state) {
                if (state == ViewPager.SCROLL_STATE_DRAGGING) {
                    mCurPos = mViewPager.getCurrentItem();
                } else if (state == ViewPager.SCROLL_STATE_SETTLING) {
                    if (mCurPos != mViewPager.getCurrentItem()) {
                        mPagerAdapter.onPageSelected(mCurPos, mViewPager.getCurrentItem());
                        mCurPos = mViewPager.getCurrentItem();
                    }
                }
            }
        });
        mEmptyTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getActivity().finish();
            }
        });
    }

    @Override
    public void setAdapter(FilePreviewAdapter adapter) {
        mPagerAdapter = adapter;
        mViewPager.setAdapter(adapter);
    }

    @Override
    public void setCurrentPosition(int position) {
        mViewPager.setCurrentItem(position, false);
    }

    @Override
    public ViewPager getViewPager() {
        return mViewPager;
    }

    @Override
    public void setProgressVisibility(int visibility) {
        mLoadingPbar.setVisibility(visibility);
    }

    @Override
    public void showEmptyView() {
        mViewPager.setVisibility(View.GONE);
        mEmptyTv.setVisibility(View.VISIBLE);
    }

    @Override
    public void fileDownloadFinish(int position) {
        if (position == mViewPager.getCurrentItem()) {
            mPagerAdapter.adapterVus.get(position).onFileDownloadFinish();
        }
    }
}
