package com.xdja.im.uikit.ui.view;

import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.ScreenUtil;
import com.xdja.im.uikit.view.ChatImageView;

import static com.xdja.im.lib.filemanage.util.HistoryFileUtils.isFileExist;


/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:43
 * @Version V1.0
 * @Description:
 */
public class ViewRecvImageItem extends BaseReceiveItem {

    //private static final int MAX_PLAY_GIF = 3 * 1024 * 1024;

    /**
     * 图片显示控件
     */
    private ChatImageView mChatImage;
    /**
     * gif
     */
    private ImageView mGifImageView;
    /**
     * 闪信标识
     */
    private ImageView mBombFlagImg;
    /**
     * 图片加载进度
     */
    private ProgressBar mLoadingPbar;
    /**
     * 重新下载按钮
     */
    private ImageButton mRetryBtn;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_receive_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mChatImage = (ChatImageView) findViewById(R.id.img_receive_image);
        mGifImageView = (ImageView) findViewById(R.id.img_receive_gif_image);
        mBombFlagImg = (ImageView) findViewById(R.id.img_bomb_flag);
        mLoadingPbar = (ProgressBar) findViewById(R.id.pbar_loading);
        mRetryBtn = (ImageButton) findViewById(R.id.img_retry_download);

        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().previewImage(dataSource);
            }
        });
        mRetryBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mLoadingPbar.setVisibility(View.VISIBLE);
                mChatImage.setImageBitmap(null);
                mRetryBtn.setVisibility(View.GONE);
                getPresenter().downLoadFile(dataSource.getFileInfo());
            }
        });
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
        mChatImage.setImageBitmap(null);
        mContentLayout.setBackgroundResource(0);
        mLoadingPbar.setVisibility(View.GONE);
        mRetryBtn.setVisibility(View.GONE);
    }

    @Override
    public void bindDataSource(int position, final TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

        ImageFileInfo fileInfo = (ImageFileInfo) dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("load image, but file info is null");
            mChatImage.setImageResource(R.mipmap.im_uikit_pic_failed);
            return;
        }

        if (dataSource.getMessageState() == ConstDef.STATE_DESTROY) {
            mBombFlagImg.setVisibility(View.GONE);
            mChatImage.setImageResource(R.mipmap.im_uikit_bg_shanxin_image);
        } else {
            mBombFlagImg.setVisibility(View.GONE);
            if (TextUtils.isEmpty(fileInfo.getFilePath())) {
                //加载失败，显示重新下载按钮
                setReDownloadVisible();
                return;
            }

            //如果本地文件存在
            if (fileInfo.getFileState() == ConstDef.FAIL) {
                setProgressBarVisible(false);
                setReDownloadVisible();
            } else if (fileInfo.getFileState() == ConstDef.DONE) {
                setProgressBarVisible(false);
                loadImage(fileInfo,dataSource);
            } else {
                mChatImage.setImageResource(R.drawable.im_uikit_bg_pbar_loading);
                setProgressBarVisible(true);
                getPresenter().downLoadFile(fileInfo);
            }

            //需求：图片下载成功后，才发送已阅读状态
            if (dataSource.getMessageState() < ConstDef.STATE_READED) {
                //发送阅读回执
                getPresenter().sendReadReceipt(dataSource);
            }

            //如果状态为闪信销毁，则启动销毁动画
            if (dataSource.getMessageState() == ConstDef.STATE_DESTROYING) {
                startBombAnim();

                final TalkMessageBean cloneSource = new TalkMessageBean(dataSource);
                new Handler().postDelayed(new Runnable() {

                    @Override
                    public void run() {
                        getPresenter().postDestroyAnimate(cloneSource);
                        loadImageResource(R.mipmap.im_uikit_bg_shanxin_image);
                    }
                }, 700);
            }
        }
    }

    /**
     * 当下载失败或者图片加载时，显示重新下载按钮
     */
    private void setReDownloadVisible() {

        loadImageResource(R.mipmap.im_uikit_pic_failed);

        if (mRetryBtn == null) {
            LogUtil.w("ERROR:reDownloadImageBtn is null.");
            return;
        }

        mRetryBtn.setVisibility(View.VISIBLE);
    }

    /**
     * 根据资源文件，加载图片
     */
    private void loadImageResource(int srcId) {
        mChatImage.setImageResource(srcId);
        mLoadingPbar.setVisibility(View.GONE);
        mBombFlagImg.setVisibility(View.GONE);
        setMessageDestroy(dataSource.isBomb());
    }

    /**
     * 加载图片
     */
    private void loadImage(ImageFileInfo fileInfo,TalkMessageBean dataSource) {
        //本地文件存在
        if (FileUtils.isFileExists(fileInfo.getFilePath())) {
            //mChatImage.loadImage(filePath);
            loadImageUrl(fileInfo, dataSource);
            if (mContentLayout.getVisibility() == View.VISIBLE) {
                getPresenter().scrollTo(curPosition);
            }
        } else {
            mChatImage.setError(R.mipmap.im_uikit_pic_default);
        }
    }

    /**
     * 图片加载进度是否显示
     *
     * @param isVisible
     */
    private void setProgressBarVisible(boolean isVisible) {
        if (isVisible) {
            mLoadingPbar.setVisibility(View.VISIBLE);
        } else {
            mLoadingPbar.setVisibility(View.GONE);
        }
    }

    /**
     * 加载URL指定图片
     *
     * @param imageFileInfo
     */
    private void loadImageUrl(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        String suffix = imageFileInfo.getSuffix();
        //fix bug 21243 by jyg 20171017
        if (imageFileInfo != null && ConstDef.GIF_TYPE.equalsIgnoreCase(suffix)
                && !TextUtils.isEmpty(imageFileInfo.getFilePath())) {
            String urlGif = imageFileInfo.getFilePath();
            long fileSize = imageFileInfo.getFileSize();
            //fix bug 21243 by jyg 20171017
            mChatImage.setVisibility(View.GONE);
            mGifImageView.setVisibility(View.VISIBLE);
            if (isFileExist(urlGif)) {
                Glide.with(getActivity())
                        .load(urlGif)
                        .placeholder(R.mipmap.im_uikit_pic_default)
                        .diskCacheStrategy(DiskCacheStrategy.SOURCE)
                        .into(mGifImageView);
            }
        } else {
            mChatImage.setVisibility(View.VISIBLE);
            mGifImageView.setVisibility(View.GONE);
            mChatImage.loadImage(imageFileInfo.getFilePath());
//            Glide.with(getActivity())
//                    .load(imageFileInfo.getFilePath())
//                    .dontAnimate().override(ScreenUtil.dp2px(getActivity(),getResources().getDimension(R.dimen.im_uikit_image_size_dp)),ScreenUtil.dp2px(getActivity(),getResources().getDimension(R.dimen.im_uikit_image_size_dp)))
//                    .diskCacheStrategy(DiskCacheStrategy.SOURCE)
//                    .into(mChatImage);
        }
    }

}
