package com.xdja.im.uikit.utils;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.text.TextUtils;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.lib.album.bean.ImageThumbBean;
import com.xdja.im.lib.camera.bean.PhotoThumbBean;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.model.MediaFileInfo;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.video.bean.VideoItem;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;

import rx.Observable;

/**
 * @Package: com.xdja.im.core.utils
 * @Author: xdjaxa
 * @Creation: 2017-05-02 14:53
 * @Version V1.0
 * @Description:数据工具类
 */
public class DataConvertUtils {

    /**
     * 图片信息转换
     *
     * @param thumbBean
     * @return
     */
    public static FileInfo mapImageFileInfo(ImageThumbBean thumbBean) {

        ImageFileInfo imageFileInfo = new ImageFileInfo();
        if (TextUtils.isEmpty(thumbBean.getThumbPath()) ||
                TextUtils.isEmpty(thumbBean.getHdThumbPath())) {
            LogUtil.e("ERROR:thumb path is empty or hd thumb path is null.");
            return null;
        }
        //缩略图
        FileInfo gifThumbFile = new FileInfo();
        gifThumbFile.setFileName(thumbBean.getThumbName());
        gifThumbFile.setFilePath(thumbBean.getThumbPath());
        gifThumbFile.setFileSize(thumbBean.getThumbSize());
        imageFileInfo.setGifFileInfo(gifThumbFile);
        //高清缩略图
        FileInfo hdThumbFile = new FileInfo();
        hdThumbFile.setFileName(thumbBean.getHdThumbName());
        hdThumbFile.setFilePath(thumbBean.getHdThumbPath());
        hdThumbFile.setFileSize(thumbBean.getHdThumbSize());
        imageFileInfo.setHdFileInfo(hdThumbFile);

        //原图
        if (!TextUtils.isEmpty(thumbBean.getRawPath())) {
            FileInfo rawFileInfo = new FileInfo();
            rawFileInfo.setFileName(thumbBean.getRawName());
            rawFileInfo.setFilePath(thumbBean.getRawPath());
            rawFileInfo.setFileSize(thumbBean.getRawSize());
            imageFileInfo.setRawFileInfo(rawFileInfo);
            imageFileInfo.setOriginal(true);
            String suffix = ToolUtil.getLastString(thumbBean.getRawPath(), ".");
            if (!TextUtils.isEmpty(suffix)) {
                rawFileInfo.setSuffix(suffix);
                imageFileInfo.setSuffix(suffix);
            }
            imageFileInfo.setFilePath(thumbBean.getRawPath());
            imageFileInfo.setFileName(thumbBean.getRawName());
            imageFileInfo.setFileSize(thumbBean.getRawSize());
        } else {
            imageFileInfo.setOriginal(false);
            String suffix = ToolUtil.getLastString(thumbBean.getHdThumbPath(), ".");
            if (!TextUtils.isEmpty(suffix)) {
                imageFileInfo.setSuffix(suffix);
            }
            imageFileInfo.setFilePath(thumbBean.getHdThumbPath());
            imageFileInfo.setFileName(thumbBean.getHdThumbPath());
            imageFileInfo.setFileSize(thumbBean.getHdThumbSize());
        }
        return imageFileInfo;
    }


    /**
     * 图片信息转换
     *
     * @param thumbBean
     * @return
     */
    public static ImageFileInfo mapImagePicFileInfo(FileInfo thumbBean) {
        ImageFileInfo imageFileInfo = new ImageFileInfo();
        if (TextUtils.isEmpty(thumbBean.getFilePath())) {
            LogUtil.e("ERROR:thumb path is empty or hd thumb path is null.");
            return null;
        }
        //缩略图
        FileInfo gifThumbFile = new FileInfo();
        gifThumbFile.setFileName(thumbBean.getFileName());
        gifThumbFile.setFilePath(thumbBean.getFilePath());
        gifThumbFile.setFileSize(thumbBean.getFileSize());
        imageFileInfo.setGifFileInfo(gifThumbFile);
        //高清缩略图
        FileInfo hdThumbFile = new FileInfo();
        hdThumbFile.setFileName(thumbBean.getFileName());
        hdThumbFile.setFilePath(thumbBean.getFilePath());
        hdThumbFile.setFileSize(thumbBean.getFileSize());
        imageFileInfo.setHdFileInfo(hdThumbFile);
        imageFileInfo.setFileType(thumbBean.getFileType());
        //原图
        if (!TextUtils.isEmpty(thumbBean.getFilePath())) {
            FileInfo rawFileInfo = new FileInfo();
            rawFileInfo.setFileName(thumbBean.getFileName());
            rawFileInfo.setFilePath(thumbBean.getFilePath());
            rawFileInfo.setFileSize(thumbBean.getFileSize());
            imageFileInfo.setRawFileInfo(rawFileInfo);
            imageFileInfo.setOriginal(true);
            String suffix = ToolUtil.getLastString(thumbBean.getFilePath(), ".");
            if (!TextUtils.isEmpty(suffix)) {
                rawFileInfo.setSuffix(suffix);
                imageFileInfo.setSuffix(suffix);
            }
            imageFileInfo.setFilePath(thumbBean.getFilePath());
            imageFileInfo.setFileName(thumbBean.getFileName());
            imageFileInfo.setFileSize(thumbBean.getFileSize());
        }
        return imageFileInfo;
    }

    /**
     * 小视频信息转化
     *
     * @param videoItem
     * @return
     */
    public static FileInfo mapVideoFileInfo(VideoItem videoItem) {
        if (TextUtils.isEmpty(videoItem.getFilePath()) ||
                TextUtils.isEmpty(videoItem.getRawFilePath())) {
            LogUtil.e("ERROR: video file path is null.");
            return null;
        }

        VideoFileInfo videoFileInfo = new VideoFileInfo();
        //缩略图文件
        videoFileInfo.setFileName(videoItem.getFileName());
        videoFileInfo.setFilePath(videoItem.getFilePath());
        videoFileInfo.setFileSize(videoItem.getFileSize());

        //视频源文件
        FileInfo rawFileInfo = new FileInfo();
        rawFileInfo.setFileName(videoItem.getRawFileName());
        rawFileInfo.setFilePath(videoItem.getRawFilePath());
        rawFileInfo.setFileSize(videoItem.getRawFileSize());
        videoFileInfo.setRawFileInfo(rawFileInfo);

        videoFileInfo.setAmountOfTime(videoItem.getDuration());
        videoFileInfo.setRawFileSize(videoItem.getRawFileSize());
        return videoFileInfo;
    }

    /**
     * 小视频信息转化
     *
     * @param videoItem
     * @return
     */
    public static FileInfo mapVideoFileInfo(FileInfo videoItem) {
        if (TextUtils.isEmpty(videoItem.getFilePath())) {
            LogUtil.e("ERROR: video file path is null.");
            return null;
        }

        File firstFrame = saveFirstFrame(videoItem.getFilePath());

//        VideoFileInfo videoFileInfo = new VideoFileInfo();
//        //缩略图文件
//        videoFileInfo.setFileName(videoItem.getFileName());
//        videoFileInfo.setFilePath(videoItem.getFilePath());
//        videoFileInfo.setFileSize(videoItem.getFileSize());
//
//        //视频源文件
//        FileInfo rawFileInfo = new FileInfo();
//        rawFileInfo.setFileName(videoItem.getFileName());
//        rawFileInfo.setFilePath(videoItem.getFilePath());
//        rawFileInfo.setFileSize(videoItem.getFileSize());
//        videoFileInfo.setRawFileInfo(rawFileInfo);
//
//        videoFileInfo.setAmountOfTime(IMFileUtils.getVideoDuration(videoItem.getFilePath()) / 1000);
//        videoFileInfo.setRawFileSize(videoItem.getFileSize());

        //生成第一帧错误，文件损坏或者文件本身不是视频文件
        if (firstFrame == null) {
            return null;
        }
        String suffix = ToolUtil.getLastString(videoItem.getFileName(), ".");

        //fix bug 19178 by jyg start 20170902
        int duration = IMFileUtils.getVideoDuration(videoItem.getFilePath());
        //fix bug 19178 by jyg end 20170902
        VideoFileInfo videoFileInfo = new VideoFileInfo();
        videoFileInfo.setAmountOfTime(duration / 1000);
        videoFileInfo.setFilePath(firstFrame.getPath());
        videoFileInfo.setFileName(firstFrame.getName());
        videoFileInfo.setSuffix(suffix);
        videoFileInfo.setFileType(ConstDef.FILE_TYPE_VIDEO);
        videoFileInfo.setFileSize(firstFrame.length());
        videoFileInfo.setRawFileSize(videoItem.getFileSize());

        FileInfo extraInfo = new FileInfo();
        extraInfo.setFilePath(videoItem.getFilePath());
        extraInfo.setFileName(videoItem.getFileName());
        extraInfo.setFileSize(videoItem.getFileSize());
        extraInfo.setSuffix(suffix);
        extraInfo.setFileType(ConstDef.FILE_TYPE_VIDEO);
        videoFileInfo.setRawFileInfo(extraInfo);
        return videoFileInfo;
    }


    /**
     * 保存短视频第一帧缩略图
     *
     * @param path 短视频地址
     */
    public static File saveFirstFrame(String path) {
        MediaMetadataRetriever media = null;
        File firstFrameFile;
        try {
            media = new MediaMetadataRetriever();
            media.setDataSource(path);
        } catch (IllegalArgumentException e) {
            LogUtil.d("share file", "保存短视频第一帧失败，短视频路径错误");
        }
        if (media == null) {
            return null;
        }
        Bitmap bitmap = media.getFrameAtTime(0);
        String fileName = UUID.randomUUID().toString();
        BufferedOutputStream bos = null;
        firstFrameFile = new File(ToolUtil.getVideoPath(), fileName);

        try {
            bos = new BufferedOutputStream(new FileOutputStream(firstFrameFile));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 20, bos);

        } catch (Exception e) {
            LogUtil.e("share file", "Get video first frame fail");
            return null;
        } finally {
            try {
                if (bos != null) {
                    bos.flush();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return firstFrameFile;
    }


    public static FileInfo mapPhotoFileInfo(PhotoThumbBean thumbBean) {
        ImageFileInfo imageFileInfo = new ImageFileInfo();
        if (TextUtils.isEmpty(thumbBean.getThumbPath()) ||
                TextUtils.isEmpty(thumbBean.getHdThumbPath())) {
            LogUtil.e("ERROR:thumb path is im_uikit_empty or hd thumb path is null.");
            return null;
        }
        //缩略图
        imageFileInfo.setFileName(thumbBean.getThumbName());
        imageFileInfo.setFilePath(thumbBean.getThumbPath());
        imageFileInfo.setFileSize(thumbBean.getThumbSize());

        //高清缩略图
        FileInfo hdThumbFile = new FileInfo();
        hdThumbFile.setFileName(thumbBean.getHdThumbName());
        hdThumbFile.setFilePath(thumbBean.getHdThumbPath());
        hdThumbFile.setFileSize(thumbBean.getHdThumbSize());
        imageFileInfo.setHdFileInfo(hdThumbFile);

        //原图
        if (!TextUtils.isEmpty(thumbBean.getRawPath())) {
            FileInfo rawFileInfo = new FileInfo();
            rawFileInfo.setFileName(thumbBean.getRawName());
            rawFileInfo.setFilePath(thumbBean.getRawPath());
            rawFileInfo.setFileSize(thumbBean.getRawSize());
            imageFileInfo.setRawFileInfo(rawFileInfo);
            imageFileInfo.setOriginal(true);
        }
        return imageFileInfo;
    }

    /**
     * 文件信息转化
     *
     * @param fileItem
     * @return
     */
    public static FileInfo mapFileInfo(FileItem fileItem) {
        if (TextUtils.isEmpty(fileItem.getFilePath())) {
            LogUtil.e("ERROR: file path is null.");
            return null;
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(fileItem.getFileName());
        fileInfo.setFilePath(fileItem.getFilePath());
        fileInfo.setFileSize(fileItem.getFileSize());

        String suffix = ToolUtil.getLastString(fileItem.getFileName(), ".");
        if (!TextUtils.isEmpty(suffix)) {
            fileInfo.setSuffix(suffix);
        }
        return fileInfo;
    }

}
