package com.xdja.im.base.di.module;

import com.xdja.im.common.cache.impl.UserCacheImpl;
import com.xdja.im.common.cache.impl.CardCacheImpl;
import com.xdja.im.common.cache.impl.ConfigCacheImpl;
import com.xdja.im.common.cache.impl.PropertyCacheImpl;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.common.cache.interf.CardCache;
import com.xdja.im.common.cache.interf.ConfigCache;
import com.xdja.im.common.cache.interf.PropertyCache;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;

/**
 * @Package:com.xdja.im.base.di.module
 * @Author:Lei
 * @Creation:2017-04-11 22:05
 * @Version 1.0
 * @Description:
 */
@Module
public class CacheModule {

    @Singleton
    @Provides
    UserCache provideUserCache(UserCacheImpl userCache) {
        return userCache;
    }

    @Singleton
    @Provides
    CardCache provideCardCache(CardCacheImpl cardCache) {
        return cardCache;
    }

    @Singleton
    @Provides
    ConfigCache provideConfigCache(ConfigCacheImpl configCache) {
        return configCache;
    }

    @Singleton
    @Provides
    PropertyCache providePropertyCache(PropertyCacheImpl propertyCache) {
        return propertyCache;
    }

}
